/****************************************************************************
*
* Copyright (c) 2024 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,
* USING com.st.stellar.pinmap.pincfg, Version 3.0.0.202505141520
* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.
*
*****************************************************************************/

/**
 * @file    sr6px_evbc8000p_b.h
 * @brief   sr6px_evbc8000p_b board header.
 *
 * @defgroup PLATFORM PLATFORM
 * @defgroup BOARD BOARD
 * @ingroup PLATFORM
 * @addtogroup SR6P7
 * @ingroup BOARD
 * @{
 */

#ifndef _SR6PX_EVBC8000P_B_H_
#define _SR6PX_EVBC8000P_B_H_

#define SR6PX_EVBC8000P_B 1

#include <siul2.h>

/*===========================================================================*/
/* Board defines.                                                            */
/*                                                                           */
/* 32-bit MCU family built on the embedded Power Architecture                */
/*                                                                           */
/*===========================================================================*/

#define SR6PX_EVBC8000P_B 1

/*--------------------- SIUL_0 pins definitions ---------------------*/
#define USER_SW0_IRQ_NUMBER          SIUL2_EIRQ2
/* PJ[11] - MSCR_IO943 */
#define USER_SW0_IRQ siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_11)

#define USER_SW0_IRQ_CFG                                                      \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> "0x0",         \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_SW0_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW0_IRQ_IOMUX             943u
#define USER_SW0_IRQ_IOMUX_CFG         42467330u


#define USER_SW1_IRQ_NUMBER          SIUL2_EIRQ8
/* PH[12] - MSCR_IO949 */
#define USER_SW1_IRQ siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_12)

#define USER_SW1_IRQ_CFG                                                      \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_SW1_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW1_IRQ_IOMUX             949u
#define USER_SW1_IRQ_IOMUX_CFG         42467329u


#define USER_SW2_IRQ_NUMBER          SIUL2_EIRQ9
/* PI[13] - MSCR_IO950 */
#define USER_SW2_IRQ siul2_iopack(SIUL2_PORT_I, SIUL2_PAD_13)

#define USER_SW2_IRQ_CFG                                                      \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_SW2_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW2_IRQ_IOMUX             950u
#define USER_SW2_IRQ_IOMUX_CFG         42467329u


/* PJ[6] - MSCR_IO150 */
#define USER_LED1 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_6)

#define USER_LED1_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED1_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[8] - MSCR_IO152 */
#define USER_LED2 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_8)

#define USER_LED2_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED2_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[9] - MSCR_IO153 */
#define USER_LED3 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_9)

#define USER_LED3_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED3_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[10] - MSCR_IO154 */
#define USER_LED4 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_10)

#define USER_LED4_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED4_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[12] - MSCR_IO156 */
#define USER_LED5 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_12)

#define USER_LED5_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED5_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[13] - MSCR_IO157 */
#define USER_LED6 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_13)

#define USER_LED6_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED6_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[3] - MSCR_IO147 */
#define USER_LED7 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_3)

#define USER_LED7_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED7_LATCHED_STATE		SIUL2_IO_HIGH


/* PF[6] - MSCR_IO86 */
#define USER_LED8 siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_6)

#define USER_LED8_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define USER_LED8_LATCHED_STATE		SIUL2_IO_HIGH


/*--------------------- LIN_0 pins definitions ---------------------*/
/* PD[1] - MSCR_IO49 */
#define LIN0_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_1)

#define LIN0_TXD_CFG                                                          \
	/* 0x22880017 : SSS -> 23, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(23) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define LIN0_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PD[0] - MSCR_IO874 */
#define LIN0_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_0)

#define LIN0_RXD_CFG                                                          \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define LIN0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN0_RXD_IOMUX             874u
#define LIN0_RXD_IOMUX_CFG         42467340u


/*--------------------- LIN_1 pins definitions ---------------------*/
/* PA[0] - MSCR_IO0 */
#define LIN1_TXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_0)

#define LIN1_TXD_CFG                                                          \
	/* 0x22880002 : SSS -> 2, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(2) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define LIN1_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PA[1] - MSCR_IO875 */
#define LIN1_RXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_1)

#define LIN1_RXD_CFG                                                          \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define LIN1_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN1_RXD_IOMUX             875u
#define LIN1_RXD_IOMUX_CFG         42467332u


/*--------------------- LIN_2 pins definitions ---------------------*/
/* PA[10] - MSCR_IO10 */
#define LIN2_TXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_10)

#define LIN2_TXD_CFG                                                          \
	/* 0x2288000D : SSS -> 13, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(13) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define LIN2_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PA[11] - MSCR_IO876 */
#define LIN2_RXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_11)

#define LIN2_RXD_CFG                                                          \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define LIN2_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN2_RXD_IOMUX             876u
#define LIN2_RXD_IOMUX_CFG         42467336u


/*--------------------- LIN_5 pins definitions ---------------------*/
/* PD[13] - MSCR_IO61 */
#define LIN5_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_13)

#define LIN5_TXD_CFG                                                          \
	/* 0x02880006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define LIN5_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PD[12] - MSCR_IO879 */
#define LIN5_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_12)

#define LIN5_RXD_CFG                                                          \
	/* 0x00080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define LIN5_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN5_RXD_IOMUX             879u
#define LIN5_RXD_IOMUX_CFG         42467329u


/*--------------------- LIN_6 pins definitions ---------------------*/
/* PM[12] - MSCR_IO204 */
#define LIN6_TXD siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_12)

#define LIN6_TXD_CFG                                                          \
	/* 0x02880005 : SSS -> 5, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK
#define LIN6_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PM[11] - MSCR_IO880 */
#define LIN6_RXD siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_11)

#define LIN6_RXD_CFG                                                          \
	/* 0x00080400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define LIN6_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN6_RXD_IOMUX             880u
#define LIN6_RXD_IOMUX_CFG         42467331u


/*--------------------- ADC_SAR_12b_0 pins definitions ---------------------*/
/* PB[0] - MSCR_IO16 */
#define SARADC_0_AN0 siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_0)

#define SARADC_0_AN0_CFG                                                      \
	/* 0x00800000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0, INV -> 0x0,         \
	WPDE -> 0x0, IBE -> "0x0", ILS -> 0x0, SMC -> 0x1, ODC -> 0x0,            \
	 */                                                                       \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_DISABLED                         \
	 | SIUL2_MSCR_IO_OERC_WEAK
#define SARADC_0_AN0_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- CAN_0_TT_sys0 pins definitions ---------------------*/
/* PN[2] - MSCR_IO210 */
#define CAN0_SYS0_TXD siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_2)

#define CAN0_SYS0_TXD_CFG                                                     \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define CAN0_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PN[3] - MSCR_IO672 */
#define CAN0_SYS0_RXD siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_3)

#define CAN0_SYS0_RXD_CFG                                                     \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define CAN0_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN0_SYS0_RXD_IOMUX             672u
#define CAN0_SYS0_RXD_IOMUX_CFG         42467336u


/*--------------------- CAN_1_sys1 pins definitions ---------------------*/
/* PD[3] - MSCR_IO51 */
#define CAN1_SYS1_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_3)

#define CAN1_SYS1_TXD_CFG                                                     \
	/* 0x3280000A : SSS -> 10, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(10) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define CAN1_SYS1_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PD[2] - MSCR_IO676 */
#define CAN1_SYS1_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_2)

#define CAN1_SYS1_RXD_CFG                                                     \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define CAN1_SYS1_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN1_SYS1_RXD_IOMUX             676u
#define CAN1_SYS1_RXD_IOMUX_CFG         42467333u


/*--------------------- CAN_2_sys0 pins definitions ---------------------*/
/* PF[0] - MSCR_IO80 */
#define CAN2_SYS0_TXD siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_0)

#define CAN2_SYS0_TXD_CFG                                                     \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define CAN2_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PF[1] - MSCR_IO674 */
#define CAN2_SYS0_RXD siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_1)

#define CAN2_SYS0_RXD_CFG                                                     \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define CAN2_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN2_SYS0_RXD_IOMUX             674u
#define CAN2_SYS0_RXD_IOMUX_CFG         42467330u


/*--------------------- CAN_3_sys0 pins definitions ---------------------*/
/* PB[9] - MSCR_IO25 */
#define CAN3_SYS0_TXD siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_9)

#define CAN3_SYS0_TXD_CFG                                                     \
	/* 0x32800006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define CAN3_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PA[3] - MSCR_IO675 */
#define CAN3_SYS0_RXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_3)

#define CAN3_SYS0_RXD_CFG                                                     \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define CAN3_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN3_SYS0_RXD_IOMUX             675u
#define CAN3_SYS0_RXD_IOMUX_CFG         42467329u


/*--------------------- Ethernet_1 pins definitions ---------------------*/
/* PN[10] - MSCR_IO218 */
#define ETH1_MDC siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_10)

#define ETH1_MDC_CFG                                                          \
	/* 0x1208000B : SSS -> 11, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(11) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_MEDIUM
#define ETH1_MDC_LATCHED_STATE		SIUL2_IO_LOW

#define ETH1_MDC_IOMUX             2728u
#define ETH1_MDC_IOMUX_CFG         1u


/* PN[9] - MSCR_IO217 */
#define ETH1_MDIO siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_9)

#define ETH1_MDIO_CFG                                                         \
	/* 0x1288040B : SSS -> 11, FILBYPASS -> "0x1", FILPRESC -> 0x0,           \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x1",           \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(11) | SIUL2_MSCR_IO_FILBYPASS                           \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_MEDIUM
#define ETH1_MDIO_LATCHED_STATE		SIUL2_IO_LOW

#define ETH1_MDIO_IOMUX             2729u
#define ETH1_MDIO_IOMUX_CFG         1u


/*--------------------- Ethernet_0 pins definitions ---------------------*/
/* PM[8] - MSCR_IO200 */
#define ETH0_MDC siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_8)

#define ETH0_MDC_CFG                                                          \
	/* 0x22080001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x0",           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_STRONG
#define ETH0_MDC_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_MDC_IOMUX             851u
#define ETH0_MDC_IOMUX_CFG         6u


/* PM[7] - MSCR_IO199 */
#define ETH0_MDIO siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_7)

#define ETH0_MDIO_CFG                                                         \
	/* 0x22880002 : SSS -> 2, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> "0x1",           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(2) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define ETH0_MDIO_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_MDIO_IOMUX             852u
#define ETH0_MDIO_IOMUX_CFG         6u


/* PC[12] - MSCR_IO853 */
#define ETH0_RDATA0 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_12)

#define ETH0_RDATA0_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA0_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA0_IOMUX             853u
#define ETH0_RDATA0_IOMUX_CFG         42467331u


/* PC[13] - MSCR_IO854 */
#define ETH0_RDATA1 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_13)

#define ETH0_RDATA1_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA1_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA1_IOMUX             854u
#define ETH0_RDATA1_IOMUX_CFG         42467331u


/* PM[1] - MSCR_IO855 */
#define ETH0_RDATA2 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_1)

#define ETH0_RDATA2_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA2_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA2_IOMUX             855u
#define ETH0_RDATA2_IOMUX_CFG         42467331u


/* PK[15] - MSCR_IO856 */
#define ETH0_RDATA3 siul2_iopack(SIUL2_PORT_K, SIUL2_PAD_15)

#define ETH0_RDATA3_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA3_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA3_IOMUX             856u
#define ETH0_RDATA3_IOMUX_CFG         42467331u


/* PC[10] - MSCR_IO857 */
#define ETH0_RX_CLK siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_10)

#define ETH0_RX_CLK_CFG                                                       \
	/* 0x00380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RX_CLK_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RX_CLK_IOMUX             857u
#define ETH0_RX_CLK_IOMUX_CFG         42467332u


/* PM[0] - MSCR_IO858 */
#define ETH0_RX_DV siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_0)

#define ETH0_RX_DV_CFG                                                        \
	/* 0x00380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RX_DV_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RX_DV_IOMUX             858u
#define ETH0_RX_DV_IOMUX_CFG         42467332u


/* PM[2] - MSCR_IO848 */
#define ETH0_COL siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_2)

#define ETH0_COL_CFG                                                          \
	/* 0x00380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> "0x3", SMC -> "0x0",         \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_COL_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_COL_IOMUX             848u
#define ETH0_COL_IOMUX_CFG         42467331u


/* PM[6] - MSCR_IO198 */
#define ETH0_TX_CLK siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_6)

#define ETH0_TX_CLK_CFG                                                       \
	/* 0x3280000B : SSS -> 11, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(11) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TX_CLK_LATCHED_STATE		SIUL2_IO_LOW


/* PC[14] - MSCR_IO46 */
#define ETH0_TX_EN siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_14)

#define ETH0_TX_EN_CFG                                                        \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TX_EN_LATCHED_STATE		SIUL2_IO_LOW


/* PC[15] - MSCR_IO47 */
#define ETH0_TDATA0 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_15)

#define ETH0_TDATA0_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TDATA0_LATCHED_STATE		SIUL2_IO_LOW


/* PE[12] - MSCR_IO76 */
#define ETH0_TDATA1 siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_12)

#define ETH0_TDATA1_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TDATA1_LATCHED_STATE		SIUL2_IO_LOW


/* PM[4] - MSCR_IO196 */
#define ETH0_TDATA2 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_4)

#define ETH0_TDATA2_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TDATA2_LATCHED_STATE		SIUL2_IO_LOW


/* PM[5] - MSCR_IO197 */
#define ETH0_TDATA3 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_5)

#define ETH0_TDATA3_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_TDATA3_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- SIUL_0 pins definitions ---------------------*/
#define TFT_T_IRQ_NUMBER          SIUL2_EIRQ3
/* PM[10] - MSCR_IO944 */
#define TFT_T_IRQ siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_10)

#define TFT_T_IRQ_CFG                                                         \
	/* 0x02880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> "0x0", SMC -> 0x1,            \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_WEAK | SIUL2_MSCR_IO_SMC
#define TFT_T_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define TFT_T_IRQ_IOMUX             944u
#define TFT_T_IRQ_IOMUX_CFG         42467330u


/*--------------------- SPIQ_0 pins definitions ---------------------*/
/* PE[8] - MSCR_IO72 */
#define TFT_CS siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_8)

#define TFT_CS_CFG                                                            \
	/* 0x2288000E : SSS -> 14, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(14) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define TFT_CS_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_CS_IOMUX             969u
#define TFT_CS_IOMUX_CFG         4u


/*--------------------- SIUL_0 pins definitions ---------------------*/
/* PA[2] - MSCR_IO2 */
#define TFT_DC siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_2)

#define TFT_DC_CFG                                                            \
	/* 0x22880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> "0x2", SMC -> 0x1,            \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_STRONG | SIUL2_MSCR_IO_SMC
#define TFT_DC_LATCHED_STATE		SIUL2_IO_HIGH


/*--------------------- SPIQ_0 pins definitions ---------------------*/
/* PE[9] - MSCR_IO73 */
#define TFT_MOSI siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_9)

#define TFT_MOSI_CFG                                                          \
	/* 0x2288000B : SSS -> 11, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(11) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define TFT_MOSI_LATCHED_STATE		SIUL2_IO_HIGH


/* PD[4] - MSCR_IO52 */
#define TFT_SCK siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_4)

#define TFT_SCK_CFG                                                           \
	/* 0x22880008 : SSS -> 8, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(8) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG
#define TFT_SCK_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_SCK_IOMUX             970u
#define TFT_SCK_IOMUX_CFG         4u


/*--------------------- SIUL_0 pins definitions ---------------------*/
/* PL[14] - MSCR_IO190 */
#define TFT_LED_BACKLIGHT siul2_iopack(SIUL2_PORT_L, SIUL2_PAD_14)

#define TFT_LED_BACKLIGHT_CFG                                                 \
	/* 0x22880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> "0x2", SMC -> 0x1,            \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_STRONG | SIUL2_MSCR_IO_SMC
#define TFT_LED_BACKLIGHT_LATCHED_STATE		SIUL2_IO_HIGH


/*--------------------- SPIQ_0 pins definitions ---------------------*/
/* PD[5] - MSCR_IO971 */
#define TFT_MISO siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_5)

#define TFT_MISO_CFG                                                          \
	/* 0x22880400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> "0x2", SMC -> 0x1,            \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG                \
	 | SIUL2_MSCR_IO_SMC
#define TFT_MISO_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_MISO_IOMUX             971u
#define TFT_MISO_IOMUX_CFG         42467335u


/*--------------------- OctalSPI_0 pins definitions ---------------------*/
/* PS[0] - MSCR_IO256 */
#define OCTALSPI_DQS siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_0)

#define OCTALSPI_DQS_CFG                                                      \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DQS_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DQS_IOMUX             2863u
#define OCTALSPI_DQS_IOMUX_CFG         1u


/* PS[1] - MSCR_IO257 */
#define OCTALSPI_CLK siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_1)

#define OCTALSPI_CLK_CFG                                                      \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_CLK_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_CLK_IOMUX             2862u
#define OCTALSPI_CLK_IOMUX_CFG         1u


/* PS[2] - MSCR_IO258 */
#define OCTALSPI_DATA0 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_2)

#define OCTALSPI_DATA0_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA0_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA0_IOMUX             2854u
#define OCTALSPI_DATA0_IOMUX_CFG         1u


/* PS[3] - MSCR_IO259 */
#define OCTALSPI_DATA1 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_3)

#define OCTALSPI_DATA1_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA1_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA1_IOMUX             2855u
#define OCTALSPI_DATA1_IOMUX_CFG         1u


/* PS[4] - MSCR_IO260 */
#define OCTALSPI_DATA2 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_4)

#define OCTALSPI_DATA2_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA2_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA2_IOMUX             2856u
#define OCTALSPI_DATA2_IOMUX_CFG         1u


/* PS[5] - MSCR_IO261 */
#define OCTALSPI_DATA3 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_5)

#define OCTALSPI_DATA3_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA3_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA3_IOMUX             2857u
#define OCTALSPI_DATA3_IOMUX_CFG         1u


/* PS[6] - MSCR_IO262 */
#define OCTALSPI_DATA4 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_6)

#define OCTALSPI_DATA4_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA4_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA4_IOMUX             2858u
#define OCTALSPI_DATA4_IOMUX_CFG         1u


/* PS[7] - MSCR_IO263 */
#define OCTALSPI_DATA5 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_7)

#define OCTALSPI_DATA5_CFG                                                    \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA5_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA5_IOMUX             2859u
#define OCTALSPI_DATA5_IOMUX_CFG         1u


/* PS[8] - MSCR_IO264 */
#define OCTALSPI_DATA6 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_8)

#define OCTALSPI_DATA6_CFG                                                    \
	/* 0x32880406 : SSS -> 6, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA6_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA6_IOMUX             2860u
#define OCTALSPI_DATA6_IOMUX_CFG         1u


/* PS[9] - MSCR_IO265 */
#define OCTALSPI_DATA7 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_9)

#define OCTALSPI_DATA7_CFG                                                    \
	/* 0x32880404 : SSS -> 4, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_DATA7_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA7_IOMUX             2861u
#define OCTALSPI_DATA7_IOMUX_CFG         1u


/* PS[10] - MSCR_IO266 */
#define OCTALSPI_CSN0 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_10)

#define OCTALSPI_CSN0_CFG                                                     \
	/* 0x32880404 : SSS -> 4, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_CSN0_LATCHED_STATE		SIUL2_IO_LOW


/* PS[11] - MSCR_IO267 */
#define OCTALSPI_CSN1 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_11)

#define OCTALSPI_CSN1_CFG                                                     \
	/* 0x32880406 : SSS -> 6, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x1", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define OCTALSPI_CSN1_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- FlexRay_0 pins definitions ---------------------*/
/* PH[7] - MSCR_IO119 */
#define FLEXRAY_0_CHA_TXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_7)

#define FLEXRAY_0_CHA_TXD_CFG                                                 \
	/* 0x32800004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> "0x0", ILS -> 0x0, SMC -> 0x1,           \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG


/* PH[8] - MSCR_IO120 */
#define FLEXRAY_0_CHA_TXEN siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_8)

#define FLEXRAY_0_CHA_TXEN_CFG                                                \
	/* 0x22800005 : SSS -> 5, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_STRONG


/* PH[9] - MSCR_IO861 */
#define FLEXRAY_0_CHA_RXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_9)

#define FLEXRAY_0_CHA_RXD_CFG                                                 \
	/* 0x00880400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_DISABLED                         \
	 | SIUL2_MSCR_IO_OERC_WEAK

#define FLEXRAY_0_CHA_RXD_IOMUX             861u
#define FLEXRAY_0_CHA_RXD_IOMUX_CFG         42467331u


/* PH[3] - MSCR_IO115 */
#define FLEXRAY_0_CHB_TXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_3)

#define FLEXRAY_0_CHB_TXD_CFG                                                 \
	/* 0x32800004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG


/* PH[4] - MSCR_IO116 */
#define FLEXRAY_0_CHB_TXEN siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_4)

#define FLEXRAY_0_CHB_TXEN_CFG                                                \
	/* 0x22800006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_STRONG


/* PH[10] - MSCR_IO862 */
#define FLEXRAY_0_CHB_RXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_10)

#define FLEXRAY_0_CHB_RXD_CFG                                                 \
	/* 0x00880400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_DISABLED                         \
	 | SIUL2_MSCR_IO_OERC_WEAK

#define FLEXRAY_0_CHB_RXD_IOMUX             862u
#define FLEXRAY_0_CHB_RXD_IOMUX_CFG         42467332u


/*--------------------- FlexRay_1 pins definitions ---------------------*/
/* PN[12] - MSCR_IO220 */
#define FLEXRAY_1_CHA_TXD siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_12)

#define FLEXRAY_1_CHA_TXD_CFG                                                 \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG


/* PN[14] - MSCR_IO222 */
#define FLEXRAY_1_CHA_TXEN siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_14)

#define FLEXRAY_1_CHA_TXEN_CFG                                                \
	/* 0x22800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_STRONG


/* PE[10] - MSCR_IO864 */
#define FLEXRAY_1_CHA_RXD siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_10)

#define FLEXRAY_1_CHA_RXD_CFG                                                 \
	/* 0x00880400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x0" */                                                          \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_DISABLED                         \
	 | SIUL2_MSCR_IO_OERC_WEAK

#define FLEXRAY_1_CHA_RXD_IOMUX             864u
#define FLEXRAY_1_CHA_RXD_IOMUX_CFG         42467329u


/* PN[13] - MSCR_IO221 */
#define FLEXRAY_1_CHB_TXD siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_13)

#define FLEXRAY_1_CHB_TXD_CFG                                                 \
	/* 0x32800004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG


/* PN[4] - MSCR_IO212 */
#define FLEXRAY_1_CHB_TXEN siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_4)

#define FLEXRAY_1_CHB_TXEN_CFG                                                \
	/* 0x22800003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x0, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x2" */                                                          \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_PUSH_PULL                        \
	 | SIUL2_MSCR_IO_OERC_STRONG


/* PN[8] - MSCR_IO865 */
#define FLEXRAY_1_CHB_RXD siul2_iopack(SIUL2_PORT_N, SIUL2_PAD_8)

#define FLEXRAY_1_CHB_RXD_CFG                                                 \
	/* 0x00880400 : SSS -> 0, FILBYPASS -> "0x1", FILPRESC -> 0x0,            \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_SMC | SIUL2_MSCR_IO_ODC_DISABLED                         \
	 | SIUL2_MSCR_IO_OERC_WEAK

#define FLEXRAY_1_CHB_RXD_IOMUX             865u
#define FLEXRAY_1_CHB_RXD_IOMUX_CFG         42467331u


/*--------------------- I2C_0 pins definitions ---------------------*/
/* PM[9] - MSCR_IO201 */
#define I2C_0_SDA siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_9)

#define I2C_0_SDA_CFG                                                         \
	/* 0x1188000F : SSS -> 15, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(15) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_OPEN_DRAIN | SIUL2_MSCR_IO_OERC_MEDIUM
#define I2C_0_SDA_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_0_SDA_IOMUX             871u
#define I2C_0_SDA_IOMUX_CFG         3u


/* PA[13] - MSCR_IO13 */
#define I2C_0_SCL siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_13)

#define I2C_0_SCL_CFG                                                         \
	/* 0x31880011 : SSS -> 17, FILBYPASS -> 0x0, FILPRESC -> 0x0,             \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(17) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                                           \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define I2C_0_SCL_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_0_SCL_IOMUX             870u
#define I2C_0_SCL_IOMUX_CFG         3u


/*--------------------- I2C_1 pins definitions ---------------------*/
/* PQ[15] - MSCR_IO239 */
#define I2C_1_SDA siul2_iopack(SIUL2_PORT_Q, SIUL2_PAD_15)

#define I2C_1_SDA_CFG                                                         \
	/* 0x11880001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x1" */                                                          \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_OPEN_DRAIN | SIUL2_MSCR_IO_OERC_MEDIUM
#define I2C_1_SDA_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_1_SDA_IOMUX             873u
#define I2C_1_SDA_IOMUX_CFG         2u


/* PQ[13] - MSCR_IO237 */
#define I2C_1_SCL siul2_iopack(SIUL2_PORT_Q, SIUL2_PAD_13)

#define I2C_1_SCL_CFG                                                         \
	/* 0x31880004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> "0x3" */                                                          \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                                           \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define I2C_1_SCL_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_1_SCL_IOMUX             872u
#define I2C_1_SCL_IOMUX_CFG         2u


/*===========================================================================*/
/* External declarations.                                                    */
/*===========================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

#define sr6px_evbc8000p_b_init() \
    do {                                                                      \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(USER_SW0_IRQ, USER_SW0_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW0_IRQ_IOMUX, USER_SW0_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW0_IRQ, USER_SW0_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_SW1_IRQ, USER_SW1_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW1_IRQ_IOMUX, USER_SW1_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW1_IRQ, USER_SW1_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_SW2_IRQ, USER_SW2_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW2_IRQ_IOMUX, USER_SW2_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW2_IRQ, USER_SW2_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_LED1, USER_LED1_CFG);                           \
	    siul2_iowrite(USER_LED1, USER_LED1_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED2, USER_LED2_CFG);                           \
	    siul2_iowrite(USER_LED2, USER_LED2_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED3, USER_LED3_CFG);                           \
	    siul2_iowrite(USER_LED3, USER_LED3_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED4, USER_LED4_CFG);                           \
	    siul2_iowrite(USER_LED4, USER_LED4_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED5, USER_LED5_CFG);                           \
	    siul2_iowrite(USER_LED5, USER_LED5_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED6, USER_LED6_CFG);                           \
	    siul2_iowrite(USER_LED6, USER_LED6_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED7, USER_LED7_CFG);                           \
	    siul2_iowrite(USER_LED7, USER_LED7_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED8, USER_LED8_CFG);                           \
	    siul2_iowrite(USER_LED8, USER_LED8_LATCHED_STATE);                    \
	                                                                          \
	    /* LIN_0 */                                                           \
	    siul2_set_iomode(LIN0_TXD, LIN0_TXD_CFG);                             \
	    siul2_iowrite(LIN0_TXD, LIN0_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN0_RXD, LIN0_RXD_CFG);                             \
	    siul2_set_muxmode(LIN0_RXD_IOMUX, LIN0_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN0_RXD, LIN0_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_1 */                                                           \
	    siul2_set_iomode(LIN1_TXD, LIN1_TXD_CFG);                             \
	    siul2_iowrite(LIN1_TXD, LIN1_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN1_RXD, LIN1_RXD_CFG);                             \
	    siul2_set_muxmode(LIN1_RXD_IOMUX, LIN1_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN1_RXD, LIN1_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_2 */                                                           \
	    siul2_set_iomode(LIN2_TXD, LIN2_TXD_CFG);                             \
	    siul2_iowrite(LIN2_TXD, LIN2_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN2_RXD, LIN2_RXD_CFG);                             \
	    siul2_set_muxmode(LIN2_RXD_IOMUX, LIN2_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN2_RXD, LIN2_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_5 */                                                           \
	    siul2_set_iomode(LIN5_TXD, LIN5_TXD_CFG);                             \
	    siul2_iowrite(LIN5_TXD, LIN5_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN5_RXD, LIN5_RXD_CFG);                             \
	    siul2_set_muxmode(LIN5_RXD_IOMUX, LIN5_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN5_RXD, LIN5_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_6 */                                                           \
	    siul2_set_iomode(LIN6_TXD, LIN6_TXD_CFG);                             \
	    siul2_iowrite(LIN6_TXD, LIN6_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN6_RXD, LIN6_RXD_CFG);                             \
	    siul2_set_muxmode(LIN6_RXD_IOMUX, LIN6_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN6_RXD, LIN6_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* ADC_SAR_12b_0 */                                                   \
	    siul2_set_iomode(SARADC_0_AN0, SARADC_0_AN0_CFG);                     \
	    siul2_iowrite(SARADC_0_AN0, SARADC_0_AN0_LATCHED_STATE);              \
	                                                                          \
	    /* CAN_0_TT_sys0 */                                                   \
	    siul2_set_iomode(CAN0_SYS0_TXD, CAN0_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN0_SYS0_TXD, CAN0_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN0_SYS0_RXD, CAN0_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN0_SYS0_RXD_IOMUX, CAN0_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN0_SYS0_RXD, CAN0_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_1_sys1 */                                                      \
	    siul2_set_iomode(CAN1_SYS1_TXD, CAN1_SYS1_TXD_CFG);                   \
	    siul2_iowrite(CAN1_SYS1_TXD, CAN1_SYS1_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN1_SYS1_RXD, CAN1_SYS1_RXD_CFG);                   \
	    siul2_set_muxmode(CAN1_SYS1_RXD_IOMUX, CAN1_SYS1_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN1_SYS1_RXD, CAN1_SYS1_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_2_sys0 */                                                      \
	    siul2_set_iomode(CAN2_SYS0_TXD, CAN2_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN2_SYS0_TXD, CAN2_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN2_SYS0_RXD, CAN2_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN2_SYS0_RXD_IOMUX, CAN2_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN2_SYS0_RXD, CAN2_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_3_sys0 */                                                      \
	    siul2_set_iomode(CAN3_SYS0_TXD, CAN3_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN3_SYS0_TXD, CAN3_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN3_SYS0_RXD, CAN3_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN3_SYS0_RXD_IOMUX, CAN3_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN3_SYS0_RXD, CAN3_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* Ethernet_1 */                                                      \
	    siul2_set_iomode(ETH1_MDC, ETH1_MDC_CFG);                             \
	    siul2_set_muxmode(ETH1_MDC_IOMUX, ETH1_MDC_IOMUX_CFG);                \
	    siul2_iowrite(ETH1_MDC, ETH1_MDC_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(ETH1_MDIO, ETH1_MDIO_CFG);                           \
	    siul2_set_muxmode(ETH1_MDIO_IOMUX, ETH1_MDIO_IOMUX_CFG);              \
	    siul2_iowrite(ETH1_MDIO, ETH1_MDIO_LATCHED_STATE);                    \
	                                                                          \
	    /* Ethernet_0 */                                                      \
	    siul2_set_iomode(ETH0_MDC, ETH0_MDC_CFG);                             \
	    siul2_set_muxmode(ETH0_MDC_IOMUX, ETH0_MDC_IOMUX_CFG);                \
	    siul2_iowrite(ETH0_MDC, ETH0_MDC_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(ETH0_MDIO, ETH0_MDIO_CFG);                           \
	    siul2_set_muxmode(ETH0_MDIO_IOMUX, ETH0_MDIO_IOMUX_CFG);              \
	    siul2_iowrite(ETH0_MDIO, ETH0_MDIO_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA0, ETH0_RDATA0_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA0_IOMUX, ETH0_RDATA0_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA0, ETH0_RDATA0_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA1, ETH0_RDATA1_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA1_IOMUX, ETH0_RDATA1_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA1, ETH0_RDATA1_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA2, ETH0_RDATA2_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA2_IOMUX, ETH0_RDATA2_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA2, ETH0_RDATA2_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA3, ETH0_RDATA3_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA3_IOMUX, ETH0_RDATA3_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA3, ETH0_RDATA3_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RX_CLK, ETH0_RX_CLK_CFG);                       \
	    siul2_set_muxmode(ETH0_RX_CLK_IOMUX, ETH0_RX_CLK_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RX_CLK, ETH0_RX_CLK_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RX_DV, ETH0_RX_DV_CFG);                         \
	    siul2_set_muxmode(ETH0_RX_DV_IOMUX, ETH0_RX_DV_IOMUX_CFG);            \
	    siul2_iowrite(ETH0_RX_DV, ETH0_RX_DV_LATCHED_STATE);                  \
	                                                                          \
	    siul2_set_iomode(ETH0_COL, ETH0_COL_CFG);                             \
	    siul2_set_muxmode(ETH0_COL_IOMUX, ETH0_COL_IOMUX_CFG);                \
	    siul2_iowrite(ETH0_COL, ETH0_COL_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(ETH0_TX_CLK, ETH0_TX_CLK_CFG);                       \
	    siul2_iowrite(ETH0_TX_CLK, ETH0_TX_CLK_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TX_EN, ETH0_TX_EN_CFG);                         \
	    siul2_iowrite(ETH0_TX_EN, ETH0_TX_EN_LATCHED_STATE);                  \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA0, ETH0_TDATA0_CFG);                       \
	    siul2_iowrite(ETH0_TDATA0, ETH0_TDATA0_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA1, ETH0_TDATA1_CFG);                       \
	    siul2_iowrite(ETH0_TDATA1, ETH0_TDATA1_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA2, ETH0_TDATA2_CFG);                       \
	    siul2_iowrite(ETH0_TDATA2, ETH0_TDATA2_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA3, ETH0_TDATA3_CFG);                       \
	    siul2_iowrite(ETH0_TDATA3, ETH0_TDATA3_LATCHED_STATE);                \
	                                                                          \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(TFT_T_IRQ, TFT_T_IRQ_CFG);                           \
	    siul2_set_muxmode(TFT_T_IRQ_IOMUX, TFT_T_IRQ_IOMUX_CFG);              \
	    siul2_iowrite(TFT_T_IRQ, TFT_T_IRQ_LATCHED_STATE);                    \
	                                                                          \
	    /* SPIQ_0 */                                                          \
	    siul2_set_iomode(TFT_CS, TFT_CS_CFG);                                 \
	    siul2_set_muxmode(TFT_CS_IOMUX, TFT_CS_IOMUX_CFG);                    \
	    siul2_iowrite(TFT_CS, TFT_CS_LATCHED_STATE);                          \
	                                                                          \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(TFT_DC, TFT_DC_CFG);                                 \
	    siul2_iowrite(TFT_DC, TFT_DC_LATCHED_STATE);                          \
	                                                                          \
	    /* SPIQ_0 */                                                          \
	    siul2_set_iomode(TFT_MOSI, TFT_MOSI_CFG);                             \
	    siul2_iowrite(TFT_MOSI, TFT_MOSI_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(TFT_SCK, TFT_SCK_CFG);                               \
	    siul2_set_muxmode(TFT_SCK_IOMUX, TFT_SCK_IOMUX_CFG);                  \
	    siul2_iowrite(TFT_SCK, TFT_SCK_LATCHED_STATE);                        \
	                                                                          \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(TFT_LED_BACKLIGHT, TFT_LED_BACKLIGHT_CFG);           \
	    siul2_iowrite(TFT_LED_BACKLIGHT, TFT_LED_BACKLIGHT_LATCHED_STATE);    \
	                                                                          \
	    /* SPIQ_0 */                                                          \
	    siul2_set_iomode(TFT_MISO, TFT_MISO_CFG);                             \
	    siul2_set_muxmode(TFT_MISO_IOMUX, TFT_MISO_IOMUX_CFG);                \
	    siul2_iowrite(TFT_MISO, TFT_MISO_LATCHED_STATE);                      \
	                                                                          \
	    /* OctalSPI_0 */                                                      \
	    siul2_set_iomode(OCTALSPI_DQS, OCTALSPI_DQS_CFG);                     \
	    siul2_set_muxmode(OCTALSPI_DQS_IOMUX, OCTALSPI_DQS_IOMUX_CFG);        \
	    siul2_iowrite(OCTALSPI_DQS, OCTALSPI_DQS_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CLK, OCTALSPI_CLK_CFG);                     \
	    siul2_set_muxmode(OCTALSPI_CLK_IOMUX, OCTALSPI_CLK_IOMUX_CFG);        \
	    siul2_iowrite(OCTALSPI_CLK, OCTALSPI_CLK_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA0, OCTALSPI_DATA0_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA0_IOMUX, OCTALSPI_DATA0_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA0, OCTALSPI_DATA0_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA1, OCTALSPI_DATA1_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA1_IOMUX, OCTALSPI_DATA1_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA1, OCTALSPI_DATA1_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA2, OCTALSPI_DATA2_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA2_IOMUX, OCTALSPI_DATA2_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA2, OCTALSPI_DATA2_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA3, OCTALSPI_DATA3_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA3_IOMUX, OCTALSPI_DATA3_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA3, OCTALSPI_DATA3_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA4, OCTALSPI_DATA4_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA4_IOMUX, OCTALSPI_DATA4_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA4, OCTALSPI_DATA4_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA5, OCTALSPI_DATA5_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA5_IOMUX, OCTALSPI_DATA5_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA5, OCTALSPI_DATA5_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA6, OCTALSPI_DATA6_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA6_IOMUX, OCTALSPI_DATA6_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA6, OCTALSPI_DATA6_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA7, OCTALSPI_DATA7_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA7_IOMUX, OCTALSPI_DATA7_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA7, OCTALSPI_DATA7_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CSN0, OCTALSPI_CSN0_CFG);                   \
	    siul2_iowrite(OCTALSPI_CSN0, OCTALSPI_CSN0_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CSN1, OCTALSPI_CSN1_CFG);                   \
	    siul2_iowrite(OCTALSPI_CSN1, OCTALSPI_CSN1_LATCHED_STATE);            \
	                                                                          \
	    /* FlexRay_0 */                                                       \
	    siul2_set_iomode(FLEXRAY_0_CHA_TXD, FLEXRAY_0_CHA_TXD_CFG);           \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHA_TXEN, FLEXRAY_0_CHA_TXEN_CFG);         \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHA_RXD, FLEXRAY_0_CHA_RXD_CFG);           \
	    siul2_set_muxmode(FLEXRAY_0_CHA_RXD_IOMUX, FLEXRAY_0_CHA_RXD_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHB_TXD, FLEXRAY_0_CHB_TXD_CFG);           \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHB_TXEN, FLEXRAY_0_CHB_TXEN_CFG);         \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHB_RXD, FLEXRAY_0_CHB_RXD_CFG);           \
	    siul2_set_muxmode(FLEXRAY_0_CHB_RXD_IOMUX, FLEXRAY_0_CHB_RXD_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    /* FlexRay_1 */                                                       \
	    siul2_set_iomode(FLEXRAY_1_CHA_TXD, FLEXRAY_1_CHA_TXD_CFG);           \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_1_CHA_TXEN, FLEXRAY_1_CHA_TXEN_CFG);         \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_1_CHA_RXD, FLEXRAY_1_CHA_RXD_CFG);           \
	    siul2_set_muxmode(FLEXRAY_1_CHA_RXD_IOMUX, FLEXRAY_1_CHA_RXD_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_1_CHB_TXD, FLEXRAY_1_CHB_TXD_CFG);           \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_1_CHB_TXEN, FLEXRAY_1_CHB_TXEN_CFG);         \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_1_CHB_RXD, FLEXRAY_1_CHB_RXD_CFG);           \
	    siul2_set_muxmode(FLEXRAY_1_CHB_RXD_IOMUX, FLEXRAY_1_CHB_RXD_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    /* I2C_0 */                                                           \
	    siul2_set_iomode(I2C_0_SDA, I2C_0_SDA_CFG);                           \
	    siul2_set_muxmode(I2C_0_SDA_IOMUX, I2C_0_SDA_IOMUX_CFG);              \
	    siul2_iowrite(I2C_0_SDA, I2C_0_SDA_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(I2C_0_SCL, I2C_0_SCL_CFG);                           \
	    siul2_set_muxmode(I2C_0_SCL_IOMUX, I2C_0_SCL_IOMUX_CFG);              \
	    siul2_iowrite(I2C_0_SCL, I2C_0_SCL_LATCHED_STATE);                    \
	                                                                          \
	    /* I2C_1 */                                                           \
	    siul2_set_iomode(I2C_1_SDA, I2C_1_SDA_CFG);                           \
	    siul2_set_muxmode(I2C_1_SDA_IOMUX, I2C_1_SDA_IOMUX_CFG);              \
	    siul2_iowrite(I2C_1_SDA, I2C_1_SDA_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(I2C_1_SCL, I2C_1_SCL_CFG);                           \
	    siul2_set_muxmode(I2C_1_SCL_IOMUX, I2C_1_SCL_IOMUX_CFG);              \
	    siul2_iowrite(I2C_1_SCL, I2C_1_SCL_LATCHED_STATE);                    \
	                                                                          \
	} while (0)
	
#ifdef __cplusplus
}
#endif

#endif /* _SR6PX_EVBC8000P_B_H_ */

/** @} */
		
