/****************************************************************************
*
* Copyright (c) 2022 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   AI test the Multicore.
 *
 * @{
 */

#include <typedefs.h>

#include <irq.h>

#include <agt.h>
#include <osal.h>
#include <siul2.h>

#include <board_cfg.h>

/**
 * @brief Cluster1 Core0 Main function for All core LED blink Test.
 *
 * @return void
 *
 */
int main(void)
{
    irq_init();
    osal_init();
    agt_init();
	siul2_init();

    /* Start OSAL for system time. */
    osal_start();

	/* Application main loop */
	for ( ; ; ) {
		siul2_iotoggle(USER_LED3);
    	osal_delay_milliseconds(400);
	}
}
/** @} */
