/****************************************************************************
 *
 * Copyright (c) 2024 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 *****************************************************************************/
/**
 * @file    modules_cfg.h
 * @brief   LIN send-receive: LIN module concfiguration.
 *
 * @addtogroup TESTS
 * @addtogroup COMMS_TESTS COMMS
 * @ingroup TESTS
 * @addtogroup LIN_TESTS LIN
 * @ingroup COMMS_TESTS
 * @{
 */

#define ENABLE_EDMA0 1
#define ENABLE_EDMA1 1
#define ENABLE_EDMA2 1
#define ENABLE_EDMA3 1

#define ENABLE_ME0   1
#define ENABLE_ME3   1
#ifndef sr6p3
#ifdef sr6g6
#define ENABLE_ME2   1
#else
#define ENABLE_ME1   1
#define ENABLE_ME2   1
#endif
#endif

/* AGT */
#define ENABLE_AGT_VIRT 1

/* GST */
#define ENABLE_GST_TBU0 1

/* The sr6g7_evbc6000s_a and sr6x7_zcu_v1_1 boards use UARTD1 */
#if (SR6G7_EVBC6000S_A == 1)
#define ENABLE_LINFLEX1 1
#define ENABLE_UART1 1
#else
#define ENABLE_LINFLEX5 1
#define ENABLE_UART5 1
#endif



