/****************************************************************************
*
* Copyright (c) 2025 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   Hello World UART test
 *
 * @addtogroup TESTS
 * @addtogroup COMMS_TESTS COMMS
 * @ingroup TESTS
 * @addtogroup UART_TESTS UART
 * @ingroup COMMS_TESTS
 * @addtogroup HELLO_WORLD uartHelloWorld
 * @ingroup UART_TESTS
 *
 * @{
 * @details
 * Stellar Studio AI main application for validation and run inference.
 * @verbatim

Configuration:
- UART setup: 115200, N, 8, 1

Prerequisites:
- Mini USB UART output (available on the board) cable connected to a Test Station
- Test Station running a serial terminal, same configuration as DUT configuration

 @endverbatim
 */

#include <typedefs.h>

#include <clock.h>
#include <irq.h>

#include <agt.h>
#include <edma.h>
#include <gst.h>
#include <siul2.h>
#include <osal.h>
#include <linflexd.h>
#include <uart.h>
#include <io.h>
#include <stdio.h>
#include <string.h>

#include <board_cfg.h>
#include "stellar_ai_cfg.h"

#if (STELLAR_AI_VALIDATE == TRUE)
#include "stellar_ai.h"
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/*===========================================================================*/
/* Driver defines.                                                           */
/*===========================================================================*/

/*===========================================================================*/
/* Driver local variables and types.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Driver exported variables.                                                */
/*===========================================================================*/

/*===========================================================================*/
/* Driver local functions.                                                   */
/*===========================================================================*/

int main(void);

/*
 * Example of system initialization function
 */
static void SystemInit(void)
{
    clockInit();
    siul2_init();
    siul2_start();

    BOARD_INIT_FUNC(BOARD_NAME);

    irq_init();
    gst_init(&GST_TBUD0);
    agt_init();

    /* GST driver: starting TBU_0 for AGT clock */
    gst_start(&GST_TBUD0);

    osal_init();
    osal_start();

    linflexd_init();

    /* Initialize the UART device */
    uart_init(&UARTD);

    /* Initialize Runtime IO module.*/
    io_init();

    /* Start Runtime IO module.*/
    io_start(&UARTD);
}

#if (STELLAR_AI_VALIDATE == TRUE)
/*
 * Application entry point for validation process
 */
int main(void) {

  SystemInit();

  aiValidateStart();

  /* never here...*/
  while (true) {
  }
}
#else
/*
 * Application entry point for inference run
 */
int main(void) {

  SystemInit();

  printf("#### Minimal application to run inference.\r\n");

  /* give a look at the main_loop() function inside the ws\build_network\stedgeai_app_main.c generated file on how to initialize and run the inference. */
  /* main_loop(); */
  
  /* never here...*/
  while (true) {
      siul2_iotoggle(USER_LED1);
      osal_delay_milliseconds(300);
  }
}
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */
/** @} */
