/****************************************************************************
*
* Copyright (c) 2024 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,
* USING com.st.stellar.pinmap.pincfg, Version 3.0.0.202502240849
* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.
*
*****************************************************************************/

/**
 * @file    sr6g6_evbc6000p_a.h
 * @brief   sr6g6_evbc6000p_a board header.
 *
 * @defgroup PLATFORM PLATFORM
 * @defgroup BOARD BOARD
 * @ingroup PLATFORM
 * @addtogroup SR6G6
 * @ingroup BOARD
 * @{
 */

#ifndef _SR6G6_EVBC6000P_A_H_
#define _SR6G6_EVBC6000P_A_H_

#define SR6G6_EVBC6000P_A 1

#include <siul2.h>

/*===========================================================================*/
/* Board defines.                                                            */
/*                                                                           */
/* 32-bit MCU family built on the embedded Power Architecture                */
/*                                                                           */
/*===========================================================================*/

#define SR6G6_EVBC6000P_A 1

/*--------------------- SIUL_0 pins definitions ---------------------*/
/* PJ[8] - MSCR_IO152 */
#define USER_LED1 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_8)

#define USER_LED1_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_LED1_LATCHED_STATE		SIUL2_IO_HIGH


/* PL[12] - MSCR_IO188 */
#define USER_LED2 siul2_iopack(SIUL2_PORT_L, SIUL2_PAD_12)

#define USER_LED2_CFG                                                         \
	/* 0x32880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x3 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define USER_LED2_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[2] - MSCR_IO146 */
#define USER_LED3 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_2)

#define USER_LED3_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_LED3_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[3] - MSCR_IO147 */
#define USER_LED4 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_3)

#define USER_LED4_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_LED4_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[9] - MSCR_IO153 */
#define USER_LED5 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_9)

#define USER_LED5_CFG                                                         \
	/* 0x12880000 : SSS -> 0, OERC -> "0x1", ODC -> "0x2", SMC -> "0x1",       \
	IBE -> "0x1" */                                                           \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_OERC_MEDIUM                          \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_SMC                        \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_IBE
#define USER_LED5_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[10] - MSCR_IO154 */
#define USER_LED6 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_10)

#define USER_LED6_CFG                                                         \
	/* 0x12880000 : SSS -> 0, OERC -> "0x1", ODC -> "0x2", SMC -> "0x1",       \
	IBE -> "0x1" */                                                           \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_OERC_MEDIUM                          \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_SMC                        \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_IBE
#define USER_LED6_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[12] - MSCR_IO156 */
#define USER_LED7 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_12)

#define USER_LED7_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_LED7_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[13] - MSCR_IO157 */
#define USER_LED8 siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_13)

#define USER_LED8_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_LED8_LATCHED_STATE		SIUL2_IO_HIGH


#define USER_SW0_IRQ_NUMBER          SIUL2_EIRQ8
/* PH[12] - MSCR_IO949 */
#define USER_SW0_IRQ siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_12)

#define USER_SW0_IRQ_CFG                                                      \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x0,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_SW0_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW0_IRQ_IOMUX             949u
#define USER_SW0_IRQ_IOMUX_CFG         1u


#define USER_SW1_IRQ_NUMBER          SIUL2_EIRQ15
/* PH[14] - MSCR_IO956 */
#define USER_SW1_IRQ siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_14)

#define USER_SW1_IRQ_CFG                                                      \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x0,             \
	OERC -> 0x2 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define USER_SW1_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW1_IRQ_IOMUX             956u
#define USER_SW1_IRQ_IOMUX_CFG         1u


#define USER_SW2_IRQ_NUMBER          SIUL2_EIRQ13
/* PH[15] - MSCR_IO954 */
#define USER_SW2_IRQ siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_15)

#define USER_SW2_IRQ_CFG                                                      \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x0,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define USER_SW2_IRQ_LATCHED_STATE		SIUL2_IO_LOW

#define USER_SW2_IRQ_IOMUX             954u
#define USER_SW2_IRQ_IOMUX_CFG         1u


/* PA[4] - MSCR_IO4 */
#define USER_SW3_IRQ siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_4)

#define USER_SW3_IRQ_CFG                                                      \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x2, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define USER_SW3_IRQ_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- LIN_0 pins definitions ---------------------*/
/* PD[1] - MSCR_IO49 */
#define LIN0_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_1)

#define LIN0_TXD_CFG                                                          \
	/* 0x12800017 : SSS -> 23, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(23) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define LIN0_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PD[0] - MSCR_IO874 */
#define LIN0_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_0)

#define LIN0_RXD_CFG                                                          \
	/* 0x30080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x3, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define LIN0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN0_RXD_IOMUX             874u
#define LIN0_RXD_IOMUX_CFG         12u


/*--------------------- LIN_10 pins definitions ---------------------*/
/* PE[7] - MSCR_IO71 */
#define LIN10_TXD siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_7)

#define LIN10_TXD_CFG                                                         \
	/* 0x22800011 : SSS -> 17, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x2, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(17) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG                \
	 | SIUL2_MSCR_IO_SMC
#define LIN10_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PE[8] - MSCR_IO884 */
#define LIN10_RXD siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_8)

#define LIN10_RXD_CFG                                                         \
	/* 0x20080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x2, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_STRONG
#define LIN10_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN10_RXD_IOMUX             884u
#define LIN10_RXD_IOMUX_CFG         2u


/*--------------------- LIN_2 pins definitions ---------------------*/
/* PA[10] - MSCR_IO10 */
#define LIN2_TXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_10)

#define LIN2_TXD_CFG                                                          \
	/* 0x3280000D : SSS -> 13, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(13) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define LIN2_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PA[11] - MSCR_IO876 */
#define LIN2_RXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_11)

#define LIN2_RXD_CFG                                                          \
	/* 0x30080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x3, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define LIN2_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN2_RXD_IOMUX             876u
#define LIN2_RXD_IOMUX_CFG         8u


/*--------------------- LIN_3 pins definitions ---------------------*/
/* PC[2] - MSCR_IO34 */
#define LIN3_TXD siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_2)

#define LIN3_TXD_CFG                                                          \
	/* 0x02800011 : SSS -> 17, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x0, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(17) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK                  \
	 | SIUL2_MSCR_IO_SMC
#define LIN3_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PC[1] - MSCR_IO877 */
#define LIN3_RXD siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_1)

#define LIN3_RXD_CFG                                                          \
	/* 0x00080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define LIN3_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN3_RXD_IOMUX             877u
#define LIN3_RXD_IOMUX_CFG         1u


/*--------------------- LIN_5 pins definitions ---------------------*/
/* PD[13] - MSCR_IO61 */
#define LIN5_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_13)

#define LIN5_TXD_CFG                                                          \
	/* 0x12800006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define LIN5_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PD[12] - MSCR_IO879 */
#define LIN5_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_12)

#define LIN5_RXD_CFG                                                          \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x1, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define LIN5_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN5_RXD_IOMUX             879u
#define LIN5_RXD_IOMUX_CFG         1u


/*--------------------- LIN_6 pins definitions ---------------------*/
/* PH[6] - MSCR_IO118 */
#define LIN6_TXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_6)

#define LIN6_TXD_CFG                                                          \
	/* 0x32800003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define LIN6_TXD_LATCHED_STATE		SIUL2_IO_HIGH


/* PJ[4] - MSCR_IO880 */
#define LIN6_RXD siul2_iopack(SIUL2_PORT_J, SIUL2_PAD_4)

#define LIN6_RXD_CFG                                                          \
	/* 0x10080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x1, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define LIN6_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define LIN6_RXD_IOMUX             880u
#define LIN6_RXD_IOMUX_CFG         1u


/*--------------------- ADC_SAR_12b_0 pins definitions ---------------------*/
/* PB[0] - MSCR_IO16 */
#define SARADC_0_AN0 siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_0)

#define SARADC_0_AN0_CFG                                                      \
	/* 0x00800000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0, IBE -> 0x0,         \
	INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x1, WPDE -> 0x0,             \
	 */                                                                       \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK                   \
	 | SIUL2_MSCR_IO_SMC
#define SARADC_0_AN0_LATCHED_STATE		SIUL2_IO_LOW


/* PB[1] - MSCR_IO17 */
#define SARADC_0_AN1 siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_1)

#define SARADC_0_AN1_CFG                                                      \
	/* 0x00800000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0, IBE -> 0x0,         \
	INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x1, WPDE -> 0x0,             \
	 */                                                                       \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK                   \
	 | SIUL2_MSCR_IO_SMC
#define SARADC_0_AN1_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- CAN_0_TT_sys0 pins definitions ---------------------*/
/* PE[5] - MSCR_IO69 */
#define CAN0_SYS0_TXD siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_5)

#define CAN0_SYS0_TXD_CFG                                                     \
	/* 0x12800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define CAN0_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PG[14] - MSCR_IO672 */
#define CAN0_SYS0_RXD siul2_iopack(SIUL2_PORT_G, SIUL2_PAD_14)

#define CAN0_SYS0_RXD_CFG                                                     \
	/* 0x10380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x1, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define CAN0_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN0_SYS0_RXD_IOMUX             672u
#define CAN0_SYS0_RXD_IOMUX_CFG         4u


/*--------------------- CAN_1_sys1 pins definitions ---------------------*/
/* PD[3] - MSCR_IO51 */
#define CAN1_SYS1_TXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_3)

#define CAN1_SYS1_TXD_CFG                                                     \
	/* 0x1280000A : SSS -> 10, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(10) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define CAN1_SYS1_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PD[2] - MSCR_IO676 */
#define CAN1_SYS1_RXD siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_2)

#define CAN1_SYS1_RXD_CFG                                                     \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define CAN1_SYS1_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN1_SYS1_RXD_IOMUX             676u
#define CAN1_SYS1_RXD_IOMUX_CFG         5u


/*--------------------- CAN_2_sys0 pins definitions ---------------------*/
/* PF[0] - MSCR_IO80 */
#define CAN2_SYS0_TXD siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_0)

#define CAN2_SYS0_TXD_CFG                                                     \
	/* 0x12800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define CAN2_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PF[1] - MSCR_IO674 */
#define CAN2_SYS0_RXD siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_1)

#define CAN2_SYS0_RXD_CFG                                                     \
	/* 0x10380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x1, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define CAN2_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN2_SYS0_RXD_IOMUX             674u
#define CAN2_SYS0_RXD_IOMUX_CFG         2u


/*--------------------- CAN_3_sys0 pins definitions ---------------------*/
/* PB[9] - MSCR_IO25 */
#define CAN3_SYS0_TXD siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_9)

#define CAN3_SYS0_TXD_CFG                                                     \
	/* 0x32800006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define CAN3_SYS0_TXD_LATCHED_STATE		SIUL2_IO_LOW


/* PA[3] - MSCR_IO675 */
#define CAN3_SYS0_RXD siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_3)

#define CAN3_SYS0_RXD_CFG                                                     \
	/* 0x10380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x1, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_MEDIUM
#define CAN3_SYS0_RXD_LATCHED_STATE		SIUL2_IO_LOW

#define CAN3_SYS0_RXD_IOMUX             675u
#define CAN3_SYS0_RXD_IOMUX_CFG         1u


/*--------------------- ETH_PHYIF_0 pins definitions ---------------------*/
/* PM[2] - MSCR_IO848 */
#define ETH0_COL siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_2)

#define ETH0_COL_CFG                                                          \
	/* 0x00380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_COL_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_COL_IOMUX             848u
#define ETH0_COL_IOMUX_CFG         3u


/* PC[10] - MSCR_IO857 */
#define ETH0_RX_CLK siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_10)

#define ETH0_RX_CLK_CFG                                                       \
	/* 0x30380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x3, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define ETH0_RX_CLK_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RX_CLK_IOMUX             857u
#define ETH0_RX_CLK_IOMUX_CFG         4u


/* PM[0] - MSCR_IO858 */
#define ETH0_RX_DV siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_0)

#define ETH0_RX_DV_CFG                                                        \
	/* 0x00380000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_CMOS | SIUL2_MSCR_IO_ODC_DISABLED                    \
	 | SIUL2_MSCR_IO_OERC_WEAK

#define ETH0_RX_DV_IOMUX             858u
#define ETH0_RX_DV_IOMUX_CFG         4u


/* PC[12] - MSCR_IO853 */
#define ETH0_RDATA0 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_12)

#define ETH0_RDATA0_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA0_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA0_IOMUX             853u
#define ETH0_RDATA0_IOMUX_CFG         3u


/* PC[13] - MSCR_IO854 */
#define ETH0_RDATA1 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_13)

#define ETH0_RDATA1_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA1_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA1_IOMUX             854u
#define ETH0_RDATA1_IOMUX_CFG         3u


/* PM[1] - MSCR_IO855 */
#define ETH0_RDATA2 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_1)

#define ETH0_RDATA2_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA2_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA2_IOMUX             855u
#define ETH0_RDATA2_IOMUX_CFG         3u


/* PK[15] - MSCR_IO856 */
#define ETH0_RDATA3 siul2_iopack(SIUL2_PORT_K, SIUL2_PAD_15)

#define ETH0_RDATA3_CFG                                                       \
	/* 0x00380400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x3, INV -> 0x0, ODC -> 0x0, OERC -> 0x0, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_CMOS                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_WEAK
#define ETH0_RDATA3_LATCHED_STATE		SIUL2_IO_LOW

#define ETH0_RDATA3_IOMUX             856u
#define ETH0_RDATA3_IOMUX_CFG         3u


/* PC[14] - MSCR_IO46 */
#define ETH0_TX_EN siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_14)

#define ETH0_TX_EN_CFG                                                        \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TX_EN_LATCHED_STATE		SIUL2_IO_LOW


/* PM[6] - MSCR_IO198 */
#define ETH0_TX_CLK siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_6)

#define ETH0_TX_CLK_CFG                                                       \
	/* 0x3280000B : SSS -> 11, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(11) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TX_CLK_LATCHED_STATE		SIUL2_IO_LOW


/* PC[15] - MSCR_IO47 */
#define ETH0_TDATA0 siul2_iopack(SIUL2_PORT_C, SIUL2_PAD_15)

#define ETH0_TDATA0_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TDATA0_LATCHED_STATE		SIUL2_IO_LOW


/* PE[12] - MSCR_IO76 */
#define ETH0_TDATA1 siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_12)

#define ETH0_TDATA1_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TDATA1_LATCHED_STATE		SIUL2_IO_LOW


/* PM[4] - MSCR_IO196 */
#define ETH0_TDATA2 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_4)

#define ETH0_TDATA2_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TDATA2_LATCHED_STATE		SIUL2_IO_LOW


/* PM[5] - MSCR_IO197 */
#define ETH0_TDATA3 siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_5)

#define ETH0_TDATA3_CFG                                                       \
	/* 0x32800001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define ETH0_TDATA3_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- SIUL_0 pins definitions ---------------------*/
/* PD[15] - MSCR_IO63 */
#define TFT_RESET siul2_iopack(SIUL2_PORT_D, SIUL2_PAD_15)

#define TFT_RESET_CFG                                                         \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_MEDIUM | SIUL2_MSCR_IO_SMC
#define TFT_RESET_LATCHED_STATE		SIUL2_IO_HIGH


/* PA[2] - MSCR_IO2 */
#define TFT_DC siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_2)

#define TFT_DC_CFG                                                            \
	/* 0x22880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x2, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_STRONG | SIUL2_MSCR_IO_SMC
#define TFT_DC_LATCHED_STATE		SIUL2_IO_HIGH


/* PB[10] - MSCR_IO26 */
#define TFT_LED_BACKLIGHT siul2_iopack(SIUL2_PORT_B, SIUL2_PAD_10)

#define TFT_LED_BACKLIGHT_CFG                                                 \
	/* 0x32880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x3 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define TFT_LED_BACKLIGHT_LATCHED_STATE		SIUL2_IO_HIGH


#define TFT_INT_IRQ_NUMBER          SIUL2_EIRQ5
/* PF[2] - MSCR_IO946 */
#define TFT_INT_IRQ siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_2)

#define TFT_INT_IRQ_CFG                                                       \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_MEDIUM | SIUL2_MSCR_IO_SMC
#define TFT_INT_IRQ_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_INT_IRQ_IOMUX             946u
#define TFT_INT_IRQ_IOMUX_CFG         2u


/*--------------------- SPIQ_0 pins definitions ---------------------*/
/* PF[15] - MSCR_IO95 */
#define TFT_CS9 siul2_iopack(SIUL2_PORT_F, SIUL2_PAD_15)

#define TFT_CS9_CFG                                                           \
	/* 0x1280000E : SSS -> 14, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(14) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define TFT_CS9_LATCHED_STATE		SIUL2_IO_HIGH


/* PK[13] - MSCR_IO173 */
#define TFT_MISO siul2_iopack(SIUL2_PORT_K, SIUL2_PAD_13)

#define TFT_MISO_CFG                                                          \
	/* 0x0280000E : SSS -> 14, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x0, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(14) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_WEAK                  \
	 | SIUL2_MSCR_IO_SMC
#define TFT_MISO_LATCHED_STATE		SIUL2_IO_HIGH


/* PI[13] - MSCR_IO141 */
#define TFT_SCK siul2_iopack(SIUL2_PORT_I, SIUL2_PAD_13)

#define TFT_SCK_CFG                                                           \
	/* 0x3288000C : SSS -> 12, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(12) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define TFT_SCK_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_SCK_IOMUX             970u
#define TFT_SCK_IOMUX_CFG         6u


/* PI[11] - MSCR_IO971 */
#define TFT_SIN siul2_iopack(SIUL2_PORT_I, SIUL2_PAD_11)

#define TFT_SIN_CFG                                                           \
	/* 0x12880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_MEDIUM | SIUL2_MSCR_IO_SMC
#define TFT_SIN_LATCHED_STATE		SIUL2_IO_HIGH

#define TFT_SIN_IOMUX             971u
#define TFT_SIN_IOMUX_CFG         5u


/* PE[6] - MSCR_IO70 */
#define TFT_CS1 siul2_iopack(SIUL2_PORT_E, SIUL2_PAD_6)

#define TFT_CS1_CFG                                                           \
	/* 0x1280000E : SSS -> 14, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(14) | SIUL2_MSCR_IO_ILS_AUTO                            \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define TFT_CS1_LATCHED_STATE		SIUL2_IO_HIGH


/*--------------------- OctalSPI_0 pins definitions ---------------------*/
/* PS[0] - MSCR_IO256 */
#define OCTALSPI_RWDS siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_0)

#define OCTALSPI_RWDS_CFG                                                     \
	/* 0x32880403 : SSS -> 3, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define OCTALSPI_RWDS_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_RWDS_IOMUX             2863u
#define OCTALSPI_RWDS_IOMUX_CFG         1u


/* PS[1] - MSCR_IO257 */
#define OCTALSPI_CLK siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_1)

#define OCTALSPI_CLK_CFG                                                      \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_CLK_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_CLK_IOMUX             2862u
#define OCTALSPI_CLK_IOMUX_CFG         1u


/* PS[2] - MSCR_IO258 */
#define OCTALSPI_DATA0 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_2)

#define OCTALSPI_DATA0_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA0_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA0_IOMUX             2854u
#define OCTALSPI_DATA0_IOMUX_CFG         1u


/* PS[3] - MSCR_IO259 */
#define OCTALSPI_DATA1 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_3)

#define OCTALSPI_DATA1_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA1_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA1_IOMUX             2855u
#define OCTALSPI_DATA1_IOMUX_CFG         1u


/* PS[4] - MSCR_IO260 */
#define OCTALSPI_DATA2 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_4)

#define OCTALSPI_DATA2_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA2_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA2_IOMUX             2856u
#define OCTALSPI_DATA2_IOMUX_CFG         1u


/* PS[5] - MSCR_IO261 */
#define OCTALSPI_DATA3 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_5)

#define OCTALSPI_DATA3_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA3_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA3_IOMUX             2857u
#define OCTALSPI_DATA3_IOMUX_CFG         1u


/* PS[6] - MSCR_IO262 */
#define OCTALSPI_DATA4 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_6)

#define OCTALSPI_DATA4_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA4_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA4_IOMUX             2858u
#define OCTALSPI_DATA4_IOMUX_CFG         1u


/* PS[7] - MSCR_IO263 */
#define OCTALSPI_DATA5 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_7)

#define OCTALSPI_DATA5_CFG                                                    \
	/* 0x32880003 : SSS -> 3, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(3) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA5_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA5_IOMUX             2859u
#define OCTALSPI_DATA5_IOMUX_CFG         1u


/* PS[8] - MSCR_IO264 */
#define OCTALSPI_DATA6 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_8)

#define OCTALSPI_DATA6_CFG                                                    \
	/* 0x32880006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA6_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA6_IOMUX             2860u
#define OCTALSPI_DATA6_IOMUX_CFG         1u


/* PS[9] - MSCR_IO265 */
#define OCTALSPI_DATA7 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_9)

#define OCTALSPI_DATA7_CFG                                                    \
	/* 0x32880004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define OCTALSPI_DATA7_LATCHED_STATE		SIUL2_IO_LOW

#define OCTALSPI_DATA7_IOMUX             2861u
#define OCTALSPI_DATA7_IOMUX_CFG         1u


/* PS[10] - MSCR_IO266 */
#define OCTALSPI_CSN0 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_10)

#define OCTALSPI_CSN0_CFG                                                     \
	/* 0x32800004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define OCTALSPI_CSN0_LATCHED_STATE		SIUL2_IO_LOW


/* PS[11] - MSCR_IO267 */
#define OCTALSPI_CSN1 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_11)

#define OCTALSPI_CSN1_CFG                                                     \
	/* 0x32800006 : SSS -> 6, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define OCTALSPI_CSN1_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- FlexRay_0 pins definitions ---------------------*/
/* PH[7] - MSCR_IO119 */
#define FLEXRAY_0_CHA_TXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_7)

#define FLEXRAY_0_CHA_TXD_CFG                                                 \
	/* 0x32800004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC


/* PH[8] - MSCR_IO120 */
#define FLEXRAY_0_CHA_TXEN siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_8)

#define FLEXRAY_0_CHA_TXEN_CFG                                                \
	/* 0x32800005 : SSS -> 5, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC


/* PH[9] - MSCR_IO861 */
#define FLEXRAY_0_CHA_RXD siul2_iopack(SIUL2_PORT_H, SIUL2_PAD_9)

#define FLEXRAY_0_CHA_RXD_CFG                                                 \
	/* 0x32880000 : SSS -> 0, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC

#define FLEXRAY_0_CHA_RXD_IOMUX             861u
#define FLEXRAY_0_CHA_RXD_IOMUX_CFG         3u


/*--------------------- I2C_0 pins definitions ---------------------*/
/* PM[9] - MSCR_IO201 */
#define I2C_0_SDA siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_9)

#define I2C_0_SDA_CFG                                                         \
	/* 0x3188000F : SSS -> 15, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x1, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(15) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                  \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define I2C_0_SDA_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_0_SDA_IOMUX             871u
#define I2C_0_SDA_IOMUX_CFG         3u


/* PA[13] - MSCR_IO13 */
#define I2C_0_SCL siul2_iopack(SIUL2_PORT_A, SIUL2_PAD_13)

#define I2C_0_SCL_CFG                                                         \
	/* 0x31880011 : SSS -> 17, FILBYPASS -> 0x0, FILPRESC -> 0x0,              \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x1, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(17) | SIUL2_MSCR_IO_IBE                                 \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                  \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define I2C_0_SCL_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_0_SCL_IOMUX             870u
#define I2C_0_SCL_IOMUX_CFG         3u


/*--------------------- I2C_1 pins definitions ---------------------*/
/* PQ[15] - MSCR_IO239 */
#define I2C_1_SDA siul2_iopack(SIUL2_PORT_Q, SIUL2_PAD_15)

#define I2C_1_SDA_CFG                                                         \
	/* 0x11880001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x1, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                  \
	 | SIUL2_MSCR_IO_OERC_MEDIUM | SIUL2_MSCR_IO_SMC
#define I2C_1_SDA_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_1_SDA_IOMUX             873u
#define I2C_1_SDA_IOMUX_CFG         2u


/* PQ[13] - MSCR_IO237 */
#define I2C_1_SCL siul2_iopack(SIUL2_PORT_Q, SIUL2_PAD_13)

#define I2C_1_SCL_CFG                                                         \
	/* 0x11880004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x1, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                  \
	 | SIUL2_MSCR_IO_OERC_MEDIUM | SIUL2_MSCR_IO_SMC
#define I2C_1_SCL_LATCHED_STATE		SIUL2_IO_HIGH

#define I2C_1_SCL_IOMUX             872u
#define I2C_1_SCL_IOMUX_CFG         2u


/*--------------------- SDMMC_0 pins definitions ---------------------*/
/* PS[12] - MSCR_IO268 */
#define SDMMC_0_DATA0 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_12)

#define SDMMC_0_DATA0_CFG                                                     \
	/* 0x22880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x2, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG                \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA0_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA0_IOMUX             2842u
#define SDMMC_0_DATA0_IOMUX_CFG         1u


/* PS[13] - MSCR_IO269 */
#define SDMMC_0_DATA1 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_13)

#define SDMMC_0_DATA1_CFG                                                     \
	/* 0x22880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x2, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_STRONG                \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA1_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA1_IOMUX             2843u
#define SDMMC_0_DATA1_IOMUX_CFG         1u


/* PS[14] - MSCR_IO270 */
#define SDMMC_0_DATA2 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_14)

#define SDMMC_0_DATA2_CFG                                                     \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA2_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA2_IOMUX             2844u
#define SDMMC_0_DATA2_IOMUX_CFG         1u


/* PS[15] - MSCR_IO271 */
#define SDMMC_0_DATA3 siul2_iopack(SIUL2_PORT_S, SIUL2_PAD_15)

#define SDMMC_0_DATA3_CFG                                                     \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA3_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA3_IOMUX             2845u
#define SDMMC_0_DATA3_IOMUX_CFG         1u


/* PT[0] - MSCR_IO272 */
#define SDMMC_0_DATA4 siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_0)

#define SDMMC_0_DATA4_CFG                                                     \
	/* 0x32880406 : SSS -> 6, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(6) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA4_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA4_IOMUX             2846u
#define SDMMC_0_DATA4_IOMUX_CFG         1u


/* PT[1] - MSCR_IO273 */
#define SDMMC_0_DATA5 siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_1)

#define SDMMC_0_DATA5_CFG                                                     \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA5_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA5_IOMUX             2847u
#define SDMMC_0_DATA5_IOMUX_CFG         1u


/* PT[2] - MSCR_IO274 */
#define SDMMC_0_DATA6 siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_2)

#define SDMMC_0_DATA6_CFG                                                     \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA6_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA6_IOMUX             2848u
#define SDMMC_0_DATA6_IOMUX_CFG         1u


/* PT[3] - MSCR_IO275 */
#define SDMMC_0_DATA7 siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_3)

#define SDMMC_0_DATA7_CFG                                                     \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_DATA7_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_DATA7_IOMUX             2849u
#define SDMMC_0_DATA7_IOMUX_CFG         1u


/* PT[4] - MSCR_IO276 */
#define SDMMC_0_CMD siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_4)

#define SDMMC_0_CMD_CFG                                                       \
	/* 0x31880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x1, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_OPEN_DRAIN                                           \
	 | SIUL2_MSCR_IO_OERC_VERY_STRONG | SIUL2_MSCR_IO_SMC
#define SDMMC_0_CMD_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_CMD_IOMUX             2851u
#define SDMMC_0_CMD_IOMUX_CFG         1u


/* PT[5] - MSCR_IO277 */
#define SDMMC_0_CLK siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_5)

#define SDMMC_0_CLK_CFG                                                       \
	/* 0x32880405 : SSS -> 5, FILBYPASS -> 0x1, FILPRESC -> 0x0,               \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x3, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(5) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_VERY_STRONG           \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_CLK_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_CLK_IOMUX             2850u
#define SDMMC_0_CLK_IOMUX_CFG         1u


/* PT[6] - MSCR_IO2852 */
#define SDMMC_0_FBCLK siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_6)

#define SDMMC_0_FBCLK_CFG                                                     \
	/* 0x30080400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x0, OERC -> 0x3, SMC -> 0x0,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_DISABLED | SIUL2_MSCR_IO_OERC_VERY_STRONG
#define SDMMC_0_FBCLK_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_FBCLK_IOMUX             2852u
#define SDMMC_0_FBCLK_IOMUX_CFG         1u


/* PT[7] - MSCR_IO2853 */
#define SDMMC_0_CD siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_7)

#define SDMMC_0_CD_CFG                                                        \
	/* 0x12880400 : SSS -> 0, FILBYPASS -> 0x1, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x1, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(0) | SIUL2_MSCR_IO_FILBYPASS                            \
	 | SIUL2_MSCR_IO_IBE | SIUL2_MSCR_IO_ILS_AUTO                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM                \
	 | SIUL2_MSCR_IO_SMC
#define SDMMC_0_CD_LATCHED_STATE		SIUL2_IO_LOW

#define SDMMC_0_CD_IOMUX             2853u
#define SDMMC_0_CD_IOMUX_CFG         1u


/* PT[8] - MSCR_IO280 */
#define SDMMC_0_POWER siul2_iopack(SIUL2_PORT_T, SIUL2_PAD_8)

#define SDMMC_0_POWER_CFG                                                     \
	/* 0x02880004 : SSS -> 4, FILBYPASS -> 0x0, FILPRESC -> 0x0,                \
	ILS -> 0x0, INV -> 0x0, ODC -> 0x2, OERC -> 0x0, SMC -> 0x1,              \
	WPUE -> 0x0 */                                                            \
	SIUL2_MSCR_IO_SSS(4) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_WEAK | SIUL2_MSCR_IO_SMC
#define SDMMC_0_POWER_LATCHED_STATE		SIUL2_IO_LOW


/*--------------------- SWITCH pins definitions ---------------------*/
/* PM[7] - MSCR_IO199 */
#define SWITCH_MAC0_MDIO siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_7)

#define SWITCH_MAC0_MDIO_CFG                                                  \
	/* 0x12880002 : SSS -> 2, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x1,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(2) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_SMC                             \
	 | SIUL2_MSCR_IO_ODC_PUSH_PULL | SIUL2_MSCR_IO_OERC_MEDIUM

#define SWITCH_MAC0_MDIO_IOMUX             2803u
#define SWITCH_MAC0_MDIO_IOMUX_CFG         6u


/* PM[8] - MSCR_IO200 */
#define SWITCH_MAC0_MDC siul2_iopack(SIUL2_PORT_M, SIUL2_PAD_8)

#define SWITCH_MAC0_MDC_CFG                                                   \
	/* 0x12080001 : SSS -> 1, FILBYPASS -> 0x0, FILPRESC -> 0x0,               \
	WPUE -> 0x0, WPDE -> 0x0, IBE -> 0x1, ILS -> 0x0, SMC -> 0x0,             \
	OERC -> 0x1 */                                                            \
	SIUL2_MSCR_IO_SSS(1) | SIUL2_MSCR_IO_IBE                                  \
	 | SIUL2_MSCR_IO_ILS_AUTO | SIUL2_MSCR_IO_ODC_PUSH_PULL                   \
	 | SIUL2_MSCR_IO_OERC_MEDIUM


/*===========================================================================*/
/* External declarations.                                                    */
/*===========================================================================*/

#ifdef __cplusplus
extern "C" {
#endif

#define sr6g6_evbc6000p_a_init() \
    do {                                                                      \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(USER_LED1, USER_LED1_CFG);                           \
	    siul2_iowrite(USER_LED1, USER_LED1_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED2, USER_LED2_CFG);                           \
	    siul2_iowrite(USER_LED2, USER_LED2_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED3, USER_LED3_CFG);                           \
	    siul2_iowrite(USER_LED3, USER_LED3_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED4, USER_LED4_CFG);                           \
	    siul2_iowrite(USER_LED4, USER_LED4_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED5, USER_LED5_CFG);                           \
	    siul2_iowrite(USER_LED5, USER_LED5_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED6, USER_LED6_CFG);                           \
	    siul2_iowrite(USER_LED6, USER_LED6_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED7, USER_LED7_CFG);                           \
	    siul2_iowrite(USER_LED7, USER_LED7_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_LED8, USER_LED8_CFG);                           \
	    siul2_iowrite(USER_LED8, USER_LED8_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(USER_SW0_IRQ, USER_SW0_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW0_IRQ_IOMUX, USER_SW0_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW0_IRQ, USER_SW0_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_SW1_IRQ, USER_SW1_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW1_IRQ_IOMUX, USER_SW1_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW1_IRQ, USER_SW1_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_SW2_IRQ, USER_SW2_IRQ_CFG);                     \
	    siul2_set_muxmode(USER_SW2_IRQ_IOMUX, USER_SW2_IRQ_IOMUX_CFG);        \
	    siul2_iowrite(USER_SW2_IRQ, USER_SW2_IRQ_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(USER_SW3_IRQ, USER_SW3_IRQ_CFG);                     \
	    siul2_iowrite(USER_SW3_IRQ, USER_SW3_IRQ_LATCHED_STATE);              \
	                                                                          \
	    /* LIN_0 */                                                           \
	    siul2_set_iomode(LIN0_TXD, LIN0_TXD_CFG);                             \
	    siul2_iowrite(LIN0_TXD, LIN0_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN0_RXD, LIN0_RXD_CFG);                             \
	    siul2_set_muxmode(LIN0_RXD_IOMUX, LIN0_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN0_RXD, LIN0_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_10 */                                                          \
	    siul2_set_iomode(LIN10_TXD, LIN10_TXD_CFG);                           \
	    siul2_iowrite(LIN10_TXD, LIN10_TXD_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(LIN10_RXD, LIN10_RXD_CFG);                           \
	    siul2_set_muxmode(LIN10_RXD_IOMUX, LIN10_RXD_IOMUX_CFG);              \
	    siul2_iowrite(LIN10_RXD, LIN10_RXD_LATCHED_STATE);                    \
	                                                                          \
	    /* LIN_2 */                                                           \
	    siul2_set_iomode(LIN2_TXD, LIN2_TXD_CFG);                             \
	    siul2_iowrite(LIN2_TXD, LIN2_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN2_RXD, LIN2_RXD_CFG);                             \
	    siul2_set_muxmode(LIN2_RXD_IOMUX, LIN2_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN2_RXD, LIN2_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_3 */                                                           \
	    siul2_set_iomode(LIN3_TXD, LIN3_TXD_CFG);                             \
	    siul2_iowrite(LIN3_TXD, LIN3_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN3_RXD, LIN3_RXD_CFG);                             \
	    siul2_set_muxmode(LIN3_RXD_IOMUX, LIN3_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN3_RXD, LIN3_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_5 */                                                           \
	    siul2_set_iomode(LIN5_TXD, LIN5_TXD_CFG);                             \
	    siul2_iowrite(LIN5_TXD, LIN5_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN5_RXD, LIN5_RXD_CFG);                             \
	    siul2_set_muxmode(LIN5_RXD_IOMUX, LIN5_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN5_RXD, LIN5_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* LIN_6 */                                                           \
	    siul2_set_iomode(LIN6_TXD, LIN6_TXD_CFG);                             \
	    siul2_iowrite(LIN6_TXD, LIN6_TXD_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(LIN6_RXD, LIN6_RXD_CFG);                             \
	    siul2_set_muxmode(LIN6_RXD_IOMUX, LIN6_RXD_IOMUX_CFG);                \
	    siul2_iowrite(LIN6_RXD, LIN6_RXD_LATCHED_STATE);                      \
	                                                                          \
	    /* ADC_SAR_12b_0 */                                                   \
	    siul2_set_iomode(SARADC_0_AN0, SARADC_0_AN0_CFG);                     \
	    siul2_iowrite(SARADC_0_AN0, SARADC_0_AN0_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(SARADC_0_AN1, SARADC_0_AN1_CFG);                     \
	    siul2_iowrite(SARADC_0_AN1, SARADC_0_AN1_LATCHED_STATE);              \
	                                                                          \
	    /* CAN_0_TT_sys0 */                                                   \
	    siul2_set_iomode(CAN0_SYS0_TXD, CAN0_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN0_SYS0_TXD, CAN0_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN0_SYS0_RXD, CAN0_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN0_SYS0_RXD_IOMUX, CAN0_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN0_SYS0_RXD, CAN0_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_1_sys1 */                                                      \
	    siul2_set_iomode(CAN1_SYS1_TXD, CAN1_SYS1_TXD_CFG);                   \
	    siul2_iowrite(CAN1_SYS1_TXD, CAN1_SYS1_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN1_SYS1_RXD, CAN1_SYS1_RXD_CFG);                   \
	    siul2_set_muxmode(CAN1_SYS1_RXD_IOMUX, CAN1_SYS1_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN1_SYS1_RXD, CAN1_SYS1_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_2_sys0 */                                                      \
	    siul2_set_iomode(CAN2_SYS0_TXD, CAN2_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN2_SYS0_TXD, CAN2_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN2_SYS0_RXD, CAN2_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN2_SYS0_RXD_IOMUX, CAN2_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN2_SYS0_RXD, CAN2_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* CAN_3_sys0 */                                                      \
	    siul2_set_iomode(CAN3_SYS0_TXD, CAN3_SYS0_TXD_CFG);                   \
	    siul2_iowrite(CAN3_SYS0_TXD, CAN3_SYS0_TXD_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(CAN3_SYS0_RXD, CAN3_SYS0_RXD_CFG);                   \
	    siul2_set_muxmode(CAN3_SYS0_RXD_IOMUX, CAN3_SYS0_RXD_IOMUX_CFG);      \
	    siul2_iowrite(CAN3_SYS0_RXD, CAN3_SYS0_RXD_LATCHED_STATE);            \
	                                                                          \
	    /* ETH_PHYIF_0 */                                                     \
	    siul2_set_iomode(ETH0_COL, ETH0_COL_CFG);                             \
	    siul2_set_muxmode(ETH0_COL_IOMUX, ETH0_COL_IOMUX_CFG);                \
	    siul2_iowrite(ETH0_COL, ETH0_COL_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(ETH0_RX_CLK, ETH0_RX_CLK_CFG);                       \
	    siul2_set_muxmode(ETH0_RX_CLK_IOMUX, ETH0_RX_CLK_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RX_CLK, ETH0_RX_CLK_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RX_DV, ETH0_RX_DV_CFG);                         \
	    siul2_set_muxmode(ETH0_RX_DV_IOMUX, ETH0_RX_DV_IOMUX_CFG);            \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA0, ETH0_RDATA0_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA0_IOMUX, ETH0_RDATA0_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA0, ETH0_RDATA0_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA1, ETH0_RDATA1_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA1_IOMUX, ETH0_RDATA1_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA1, ETH0_RDATA1_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA2, ETH0_RDATA2_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA2_IOMUX, ETH0_RDATA2_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA2, ETH0_RDATA2_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_RDATA3, ETH0_RDATA3_CFG);                       \
	    siul2_set_muxmode(ETH0_RDATA3_IOMUX, ETH0_RDATA3_IOMUX_CFG);          \
	    siul2_iowrite(ETH0_RDATA3, ETH0_RDATA3_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TX_EN, ETH0_TX_EN_CFG);                         \
	    siul2_iowrite(ETH0_TX_EN, ETH0_TX_EN_LATCHED_STATE);                  \
	                                                                          \
	    siul2_set_iomode(ETH0_TX_CLK, ETH0_TX_CLK_CFG);                       \
	    siul2_iowrite(ETH0_TX_CLK, ETH0_TX_CLK_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA0, ETH0_TDATA0_CFG);                       \
	    siul2_iowrite(ETH0_TDATA0, ETH0_TDATA0_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA1, ETH0_TDATA1_CFG);                       \
	    siul2_iowrite(ETH0_TDATA1, ETH0_TDATA1_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA2, ETH0_TDATA2_CFG);                       \
	    siul2_iowrite(ETH0_TDATA2, ETH0_TDATA2_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(ETH0_TDATA3, ETH0_TDATA3_CFG);                       \
	    siul2_iowrite(ETH0_TDATA3, ETH0_TDATA3_LATCHED_STATE);                \
	                                                                          \
	    /* SIUL_0 */                                                          \
	    siul2_set_iomode(TFT_RESET, TFT_RESET_CFG);                           \
	    siul2_iowrite(TFT_RESET, TFT_RESET_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(TFT_DC, TFT_DC_CFG);                                 \
	    siul2_iowrite(TFT_DC, TFT_DC_LATCHED_STATE);                          \
	                                                                          \
	    siul2_set_iomode(TFT_LED_BACKLIGHT, TFT_LED_BACKLIGHT_CFG);           \
	    siul2_iowrite(TFT_LED_BACKLIGHT, TFT_LED_BACKLIGHT_LATCHED_STATE);    \
	                                                                          \
	    siul2_set_iomode(TFT_INT_IRQ, TFT_INT_IRQ_CFG);                       \
	    siul2_set_muxmode(TFT_INT_IRQ_IOMUX, TFT_INT_IRQ_IOMUX_CFG);          \
	    siul2_iowrite(TFT_INT_IRQ, TFT_INT_IRQ_LATCHED_STATE);                \
	                                                                          \
	    /* SPIQ_0 */                                                          \
	    siul2_set_iomode(TFT_CS9, TFT_CS9_CFG);                               \
	    siul2_iowrite(TFT_CS9, TFT_CS9_LATCHED_STATE);                        \
	                                                                          \
	    siul2_set_iomode(TFT_MISO, TFT_MISO_CFG);                             \
	    siul2_iowrite(TFT_MISO, TFT_MISO_LATCHED_STATE);                      \
	                                                                          \
	    siul2_set_iomode(TFT_SCK, TFT_SCK_CFG);                               \
	    siul2_set_muxmode(TFT_SCK_IOMUX, TFT_SCK_IOMUX_CFG);                  \
	    siul2_iowrite(TFT_SCK, TFT_SCK_LATCHED_STATE);                        \
	                                                                          \
	    siul2_set_iomode(TFT_SIN, TFT_SIN_CFG);                               \
	    siul2_set_muxmode(TFT_SIN_IOMUX, TFT_SIN_IOMUX_CFG);                  \
	    siul2_iowrite(TFT_SIN, TFT_SIN_LATCHED_STATE);                        \
	                                                                          \
	    siul2_set_iomode(TFT_CS1, TFT_CS1_CFG);                               \
	    siul2_iowrite(TFT_CS1, TFT_CS1_LATCHED_STATE);                        \
	                                                                          \
	    /* OctalSPI_0 */                                                      \
	    siul2_set_iomode(OCTALSPI_RWDS, OCTALSPI_RWDS_CFG);                   \
	    siul2_set_muxmode(OCTALSPI_RWDS_IOMUX, OCTALSPI_RWDS_IOMUX_CFG);      \
	    siul2_iowrite(OCTALSPI_RWDS, OCTALSPI_RWDS_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CLK, OCTALSPI_CLK_CFG);                     \
	    siul2_set_muxmode(OCTALSPI_CLK_IOMUX, OCTALSPI_CLK_IOMUX_CFG);        \
	    siul2_iowrite(OCTALSPI_CLK, OCTALSPI_CLK_LATCHED_STATE);              \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA0, OCTALSPI_DATA0_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA0_IOMUX, OCTALSPI_DATA0_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA0, OCTALSPI_DATA0_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA1, OCTALSPI_DATA1_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA1_IOMUX, OCTALSPI_DATA1_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA1, OCTALSPI_DATA1_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA2, OCTALSPI_DATA2_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA2_IOMUX, OCTALSPI_DATA2_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA2, OCTALSPI_DATA2_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA3, OCTALSPI_DATA3_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA3_IOMUX, OCTALSPI_DATA3_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA3, OCTALSPI_DATA3_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA4, OCTALSPI_DATA4_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA4_IOMUX, OCTALSPI_DATA4_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA4, OCTALSPI_DATA4_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA5, OCTALSPI_DATA5_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA5_IOMUX, OCTALSPI_DATA5_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA5, OCTALSPI_DATA5_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA6, OCTALSPI_DATA6_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA6_IOMUX, OCTALSPI_DATA6_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA6, OCTALSPI_DATA6_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_DATA7, OCTALSPI_DATA7_CFG);                 \
	    siul2_set_muxmode(OCTALSPI_DATA7_IOMUX, OCTALSPI_DATA7_IOMUX_CFG);    \
	    siul2_iowrite(OCTALSPI_DATA7, OCTALSPI_DATA7_LATCHED_STATE);          \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CSN0, OCTALSPI_CSN0_CFG);                   \
	    siul2_iowrite(OCTALSPI_CSN0, OCTALSPI_CSN0_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(OCTALSPI_CSN1, OCTALSPI_CSN1_CFG);                   \
	    siul2_iowrite(OCTALSPI_CSN1, OCTALSPI_CSN1_LATCHED_STATE);            \
	                                                                          \
	    /* FlexRay_0 */                                                       \
	    siul2_set_iomode(FLEXRAY_0_CHA_TXD, FLEXRAY_0_CHA_TXD_CFG);           \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHA_TXEN, FLEXRAY_0_CHA_TXEN_CFG);         \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(FLEXRAY_0_CHA_RXD, FLEXRAY_0_CHA_RXD_CFG);           \
	    siul2_set_muxmode(FLEXRAY_0_CHA_RXD_IOMUX, FLEXRAY_0_CHA_RXD_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    /* I2C_0 */                                                           \
	    siul2_set_iomode(I2C_0_SDA, I2C_0_SDA_CFG);                           \
	    siul2_set_muxmode(I2C_0_SDA_IOMUX, I2C_0_SDA_IOMUX_CFG);              \
	    siul2_iowrite(I2C_0_SDA, I2C_0_SDA_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(I2C_0_SCL, I2C_0_SCL_CFG);                           \
	    siul2_set_muxmode(I2C_0_SCL_IOMUX, I2C_0_SCL_IOMUX_CFG);              \
	    siul2_iowrite(I2C_0_SCL, I2C_0_SCL_LATCHED_STATE);                    \
	                                                                          \
	    /* I2C_1 */                                                           \
	    siul2_set_iomode(I2C_1_SDA, I2C_1_SDA_CFG);                           \
	    siul2_set_muxmode(I2C_1_SDA_IOMUX, I2C_1_SDA_IOMUX_CFG);              \
	    siul2_iowrite(I2C_1_SDA, I2C_1_SDA_LATCHED_STATE);                    \
	                                                                          \
	    siul2_set_iomode(I2C_1_SCL, I2C_1_SCL_CFG);                           \
	    siul2_set_muxmode(I2C_1_SCL_IOMUX, I2C_1_SCL_IOMUX_CFG);              \
	    siul2_iowrite(I2C_1_SCL, I2C_1_SCL_LATCHED_STATE);                    \
	                                                                          \
	    /* SDMMC_0 */                                                         \
	    siul2_set_iomode(SDMMC_0_DATA0, SDMMC_0_DATA0_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA0_IOMUX, SDMMC_0_DATA0_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA0, SDMMC_0_DATA0_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA1, SDMMC_0_DATA1_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA1_IOMUX, SDMMC_0_DATA1_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA1, SDMMC_0_DATA1_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA2, SDMMC_0_DATA2_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA2_IOMUX, SDMMC_0_DATA2_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA2, SDMMC_0_DATA2_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA3, SDMMC_0_DATA3_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA3_IOMUX, SDMMC_0_DATA3_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA3, SDMMC_0_DATA3_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA4, SDMMC_0_DATA4_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA4_IOMUX, SDMMC_0_DATA4_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA4, SDMMC_0_DATA4_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA5, SDMMC_0_DATA5_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA5_IOMUX, SDMMC_0_DATA5_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA5, SDMMC_0_DATA5_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA6, SDMMC_0_DATA6_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA6_IOMUX, SDMMC_0_DATA6_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA6, SDMMC_0_DATA6_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_DATA7, SDMMC_0_DATA7_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_DATA7_IOMUX, SDMMC_0_DATA7_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_DATA7, SDMMC_0_DATA7_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_CMD, SDMMC_0_CMD_CFG);                       \
	    siul2_set_muxmode(SDMMC_0_CMD_IOMUX, SDMMC_0_CMD_IOMUX_CFG);          \
	    siul2_iowrite(SDMMC_0_CMD, SDMMC_0_CMD_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_CLK, SDMMC_0_CLK_CFG);                       \
	    siul2_set_muxmode(SDMMC_0_CLK_IOMUX, SDMMC_0_CLK_IOMUX_CFG);          \
	    siul2_iowrite(SDMMC_0_CLK, SDMMC_0_CLK_LATCHED_STATE);                \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_FBCLK, SDMMC_0_FBCLK_CFG);                   \
	    siul2_set_muxmode(SDMMC_0_FBCLK_IOMUX, SDMMC_0_FBCLK_IOMUX_CFG);      \
	    siul2_iowrite(SDMMC_0_FBCLK, SDMMC_0_FBCLK_LATCHED_STATE);            \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_CD, SDMMC_0_CD_CFG);                         \
	    siul2_set_muxmode(SDMMC_0_CD_IOMUX, SDMMC_0_CD_IOMUX_CFG);            \
	    siul2_iowrite(SDMMC_0_CD, SDMMC_0_CD_LATCHED_STATE);                  \
	                                                                          \
	    siul2_set_iomode(SDMMC_0_POWER, SDMMC_0_POWER_CFG);                   \
	    siul2_iowrite(SDMMC_0_POWER, SDMMC_0_POWER_LATCHED_STATE);            \
	                                                                          \
	    /* SWITCH */                                                          \
	    siul2_set_iomode(SWITCH_MAC0_MDIO, SWITCH_MAC0_MDIO_CFG);             \
	    siul2_set_muxmode(SWITCH_MAC0_MDIO_IOMUX, SWITCH_MAC0_MDIO_IOMUX_CFG); \
	                                                                          \
	                                                                          \
	    siul2_set_iomode(SWITCH_MAC0_MDC, SWITCH_MAC0_MDC_CFG);               \
	                                                                          \
	                                                                          \
	} while (0)
	
#ifdef __cplusplus
}
#endif

#endif /* _SR6G6_EVBC6000P_A_H_ */

/** @} */
		
