/**
  ******************************************************************************
  * @file    lite_conv2d_sssa8_ch.h
  * @author  AIS
  * @brief   ST header for signed simmetric signed antisimmetric 8 bits
  * layers with channel quantization
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2021-2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
#ifndef LITE_CONV2D_SSSA8_CH_H
#define LITE_CONV2D_SSSA8_CH_H

void
forward_lite_conv2d_rgb_sssa8_ch(const ai_i8 *pData_in,
                                 const ai_u16 dim_im_in,
                                 const ai_i8 *pWeights,
                                 const ai_u16 n_channel_out,
                                 const ai_u16 dim_kernel,
                                 const ai_u16 padding,
                                 const ai_u16 stride,
                                 const ai_i32 *pBias,
                                 const ai_i8 in_zeropoint,
                                 const ai_i8 out_zeropoint,
                                 const ai_float in_scale,
                                 const ai_float out_scale,
                                 const ai_float *pWt_scale,
                                 const ai_layer_format_type out_ch_format,
                                 ai_i8 *pData_out,
                                 const ai_u16 dim_im_out,
                                 ai_i32 scratch_size,
                                 ai_i16 *pBuffer_a);
void
forward_lite_conv2d_sssa8_ch(const ai_i8 *pData_in,
                             const ai_u16 dim_im_in_x,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 n_channel_in,
                             const ai_i8 *pWeights,
                             const ai_u16 n_channel_out,
                             const ai_u16 dim_kernel_x,
                             const ai_u16 dim_kernel_y,
                             const ai_u16 stride_x,
                             const ai_u16 stride_y,
                             const ai_u16 padding_x,
                             const ai_u16 padding_y,
                             const ai_i32 *pBias,
                             const ai_i8 in_zeropoint,
                             const ai_i8 out_zeropoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             const ai_layer_format_type out_ch_format,
                             ai_i8 *pData_out,
                             const ai_u16 dim_im_out_x,
                             const ai_u16 dim_im_out_y,
                             const ai_u16 weights_prefetch_enabled,
                             ai_i32 scratch_size,
                             ai_i16 *pBuffer_a);


void forward_lite_conv2d_hsp_1step_sssa8_ch(const ai_i8 *pData_in,
                                      const ai_u16 dim_im_in_x,
                                      const ai_u16 dim_im_in_y,
                                      const ai_u16 n_channel_in,
                                      const ai_i8 *pWeights,
                                      const ai_u16 n_channel_out,
                                      const ai_u16 dim_kernel_x,
                                      const ai_u16 dim_kernel_y,
                                      const ai_u16 stride_x,
                                      const ai_u16 stride_y,
                                      const ai_u16 padding_x,
                                      const ai_u16 padding_x_r,
                                      const ai_u16 padding_y,
                                      const ai_u16 padding_y_b,
                                      const ai_i32 *pBias,
                                      const ai_i8 in_zeropoint,
                                      const ai_i8 out_zeropoint,
                                      const ai_float in_scale,
                                      const ai_float out_scale,
                                      const ai_float *pWt_scale,
                                      const ai_layer_format_type out_ch_format,
                                      ai_i8 *pData_out,
                                      const ai_u16 dim_im_out_x,
                                      const ai_u16 dim_im_out_y);

void forward_lite_conv2d_hsp_2step_sssa8_ch(const ai_i8 *pData_in,
                                      const ai_u16 dim_im_in_x,
                                      const ai_u16 dim_im_in_y,
                                      const ai_u16 n_channel_in,
                                      const ai_i8 *pWeights,
                                      const ai_u16 n_channel_out,
                                      const ai_u16 dim_kernel_x,
                                      const ai_u16 dim_kernel_y,
                                      const ai_u16 stride_x,
                                      const ai_u16 stride_y,
                                      const ai_u16 padding_x,
                                      const ai_u16 padding_x_r,
                                      const ai_u16 padding_y,
                                      const ai_u16 padding_y_b,
                                      const ai_i32 *pBias,
                                      const ai_i8 in_zeropoint,
                                      const ai_i8 out_zeropoint,
                                      const ai_float in_scale,
                                      const ai_float out_scale,
                                      const ai_float *pWt_scale,
                                      const ai_layer_format_type out_ch_format,
                                      ai_i8 *pData_out,
                                      const ai_u16 dim_im_out_x,
                                      const ai_u16 dim_im_out_y);

void forward_lite_conv2d_hsp_3step_sssa8_ch(const ai_i8 *pData_in,
                                      const ai_u16 dim_im_in_x,
                                      const ai_u16 dim_im_in_y,
                                      const ai_u16 n_channel_in,
                                      const ai_i8 *pWeights,
                                      const ai_u16 n_channel_out,
                                      const ai_u16 dim_kernel_x,
                                      const ai_u16 dim_kernel_y,
                                      const ai_u16 stride_x,
                                      const ai_u16 stride_y,
                                      const ai_u16 padding_x,
                                      const ai_u16 padding_x_r,
                                      const ai_u16 padding_y,
                                      const ai_u16 padding_y_b,
                                      const ai_i32 *pBias,
                                      const ai_i8 in_zeropoint,
                                      const ai_i8 out_zeropoint,
                                      const ai_float in_scale,
                                      const ai_float out_scale,
                                      const ai_float *pWt_scale,
                                      const ai_layer_format_type out_ch_format,
                                      ai_i8 *pData_out,
                                      const ai_u16 dim_im_out_x,
                                      const ai_u16 dim_im_out_y);

void
forward_lite_conv2d_dilated_sssa8_ch(const ai_i8 *pData_in,
                                     const ai_u16 dim_im_in_x,
                                     const ai_u16 dim_im_in_y,
                                     const ai_u16 n_channel_in,
                                     const ai_i8 *pWeights,
                                     const ai_u16 n_channel_out,
                                     const ai_u16 dim_kernel_x,
                                     const ai_u16 dim_kernel_y,
                                     const ai_u16 stride_x,
                                     const ai_u16 stride_y,
                                     const ai_u16 dilation_x,
                                     const ai_u16 dilation_y,
                                     const ai_i32 *pBias,
                                     const ai_i8 in_zeropoint,
                                     const ai_i8 out_zeropoint,
                                     const ai_float in_scale,
                                     const ai_float out_scale,
                                     const ai_float *pWt_scale,
                                     const ai_layer_format_type out_ch_format,
                                     ai_i8 *pData_out,
                                     const ai_u16 dim_im_out_x,
                                     const ai_u16 dim_im_out_y,
                                     ai_u32 height_loop_cnt_0,
                                     const ai_u16 weights_prefetch_enabled,
                                     ai_i32 scratch_size,
                                     ai_i16 *pBuffer_a);

void forward_lite_conv2d_deep_sssa8_ch(const ai_i8 *pData_in,
                                       const ai_u16 dim_im_in_x,
                                       const ai_u16 dim_im_in_y,
                                       const ai_u16 n_channel_in,
                                       const ai_i8 *pWeights,
                                       const ai_u16 n_channel_out,
                                       const ai_u16 dim_kernel_x,
                                       const ai_u16 dim_kernel_y,
                                       const ai_u16 stride_x,
                                       const ai_u16 stride_y,
                                       const ai_i32 *pBias,
                                       const ai_i8 in_zeropoint,
                                       const ai_i8 out_zeropoint,
                                       const ai_float in_scale,
                                       const ai_float out_scale,
                                       const ai_float *pWt_scale,
                                       const ai_layer_format_type out_ch_format,
                                       ai_i8 *pData_out,
                                       const ai_u16 dim_im_out_x,
                                       const ai_u16 dim_im_out_y,
                                       ai_u32 height_loop_cnt_0,
                                       const ai_u16 weights_prefetch_enabled,
                                       ai_i32 scratch_size,
                                       ai_i16 *pBuffer_a);

void forward_lite_conv2d_deep_3x3_sssa8_ch(const ai_i8 *pData_in,
                                           const ai_u16 dim_im_in_x,
                                           const ai_u16 dim_im_in_y,
                                           const ai_u16 n_channel_in,
                                           const ai_i8 *pWeights,
                                           const ai_u16 n_channel_out,
                                           const ai_i32 *pBias,
                                           const ai_i8 in_zeropoint,
                                           const ai_i8 out_zeropoint,
                                           const ai_float in_scale,
                                           const ai_float out_scale,
                                           const ai_float *pWt_scale,
                                           const ai_layer_format_type out_ch_format,
                                           ai_i8 *pData_out,
                                           const ai_u16 dim_im_out_x,
                                           const ai_u16 dim_im_out_y,
                                           ai_u32 height_loop_cnt_0,
                                           ai_i32 scratch_size,
                                           ai_i16 *pBuffer_a);


void
forward_lite_pw_sssa8_ch(const ai_i8 *pData_in,
                         const ai_u16 width_in,
                         const ai_u16 height_in,
                         const ai_u16 filt_stride_x,
                         const ai_u16 filt_stride_y,
                         const ai_u16 n_channel_in,
                         const ai_i8 *pWeights,
                         const ai_u16 n_channel_out,
                         const ai_i32 *pBias,
                         const ai_i8 in_zeropoint,
                         const ai_i8 out_zeropoint,
                         const ai_float in_scale,
                         const ai_float out_scale,
                         const ai_float *pWt_scale,
                         const ai_layer_format_type out_ch_format,
                         ai_i8 *pData_out,
                         ai_u16 weights_prefetch_enabled,
                         ai_i32 scratch_size,
                         ai_i16 *pBuffer_a);

void
forward_lite_pw_hsp_2step_sssa8_ch(const ai_i8 *pData_in,
                         const ai_u16 width_in,
                         const ai_u16 height_in,
                         const ai_u16 filt_stride_x,
                         const ai_u16 filt_stride_y,
                         const ai_u16 n_channel_in,
                         const ai_i8 *pWeights,
                         const ai_u16 n_channel_out,
                         const ai_i32 *pBias,
                         const ai_i8 in_zeropoint,
                         const ai_i8 out_zeropoint,
                         const ai_float in_scale,
                         const ai_float out_scale,
                         const ai_float *pWt_scale,
                         const ai_layer_format_type out_ch_format,
                         ai_i8 *pData_out);

void 
forward_lite_pw_hsp_1step_sssa8_ch(const ai_i8 *pData_in,
                         const ai_u16 width_in,
                         const ai_u16 height_in,
                         const ai_u16 filt_stride_x,
                         const ai_u16 filt_stride_y,
                         const ai_u16 n_channel_in,
                         const ai_i8 *pWeights,
                         const ai_u16 n_channel_out, 
                         const ai_i32 *pBias,
                         const ai_i8 in_zeropoint,
                         const ai_i8 out_zeropoint,
                         const ai_float in_scale,
                         const ai_float out_scale,
                         const ai_float *pWt_scale,
                         const ai_layer_format_type out_ch_format,
                         ai_i8 *pData_out);

void 
forward_lite_pw_hsp_3step_sssa8_ch(const ai_i8 *pData_in,
                         const ai_u16 width_in,
                         const ai_u16 height_in,
                         const ai_u16 filt_stride_x,
                         const ai_u16 filt_stride_y,
                         const ai_u16 n_channel_in,
                         const ai_i8 *pWeights,
                         const ai_u16 n_channel_out, 
                         const ai_i32 *pBias,
                         const ai_i8 in_zeropoint,
                         const ai_i8 out_zeropoint,
                         const ai_float in_scale,
                         const ai_float out_scale,
                         const ai_float *pWt_scale,
                         const ai_layer_format_type out_ch_format,
                         ai_i8 *pData_out);

void
forward_lite_dw_dm_sssa8_ch(const ai_i8 *Im_in,
                            const ai_u16 dim_im_in_x,
                            const ai_u16 dim_im_in_y,
                            const ai_u16 ch_im_in,
                            const ai_i8 *wt,
                            const ai_u16 ch_im_out,
                            const ai_u16 dim_kernel_x,
                            const ai_u16 dim_kernel_y,
                            const ai_u16 padding_x,
                            const ai_u16 padding_y,
                            const ai_u16 stride_x,
                            const ai_u16 stride_y,
                            const ai_i32 *bias,
                            const ai_i8 In_ZeroPoint,
                            const ai_i8 Out_ZeroPoint,
                            const ai_float in_scale,
                            const ai_float out_scale,
                            const ai_float *pWt_scale,
                            ai_i8 *Im_out,
                            const ai_u16 dim_im_out_x,
                            const ai_u16 dim_im_out_y,
                            const ai_i32 nl_pool_fused,
                            const ai_u32 scratch_size,
                            ai_i16 *bufferA);

void
forward_lite_dw_sssa8_ch(const ai_i8 *Im_in,
                         const ai_u16 dim_im_in_x,
                         const ai_u16 dim_im_in_y,
                         const ai_u16 ch_im_in,
                         const ai_i8 *wt,
                         const ai_u16 dim_kernel_x,
                         const ai_u16 dim_kernel_y,
                         const ai_u16 padding_x,
                         const ai_u16 padding_y,
                         const ai_u16 stride_x,
                         const ai_u16 stride_y,
                         const ai_i32 *bias,
                         const ai_i8 In_ZeroPoint,
                         const ai_i8 Out_ZeroPoint,
                         const ai_float in_scale,
                         const ai_float out_scale,
                         const ai_float *pWt_scale,
                         ai_i8 *Im_out,
                         const ai_u16 dim_im_out_x,
                         const ai_u16 dim_im_out_y,
                         const ai_i32 nl_pool_fused,
                         const ai_u32 scratch_size,
                         ai_i16 *bufferA);

void
forward_lite_dw_hsp_2step_sssa8_ch(const ai_i8 *Im_in,
                             const ai_u16 dim_im_in_x,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 ch_im_in,
                             const ai_i8 *wt,
                             const ai_u16 dim_kernel_x,
                             const ai_u16 dim_kernel_y,
                             const ai_u16 padding_x,
                             const ai_u16 padding_x_r,
                             const ai_u16 padding_y,
                             const ai_u16 padding_y_b,
                             const ai_u16 stride_x,
                             const ai_u16 stride_y,
                             const ai_i32 *bias,
                             const ai_i8 In_ZeroPoint,
                             const ai_i8 Out_ZeroPoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             ai_i8 *Im_out,
                             const ai_u16 dim_im_out_x,
                             const ai_u16 dim_im_out_y);

void
forward_lite_dw_hsp_1step_sssa8_ch(const ai_i8 *Im_in,
                             const ai_u16 dim_im_in_x,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 ch_im_in,
                             const ai_i8 *wt,
                             const ai_u16 dim_kernel_x,
                             const ai_u16 dim_kernel_y,
                             const ai_u16 padding_x,
                             const ai_u16 padding_x_r,
                             const ai_u16 padding_y,
                             const ai_u16 padding_y_b,
                             const ai_u16 stride_x,
                             const ai_u16 stride_y,
                             const ai_i32 *bias,
                             const ai_i8 In_ZeroPoint,
                             const ai_i8 Out_ZeroPoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             ai_i8 *Im_out,
                             const ai_u16 dim_im_out_x,
                             const ai_u16 dim_im_out_y);

void
forward_lite_dw_hsp_3Step_sssa8_ch(const ai_i8 *Im_in,
                             const ai_u16 dim_im_in_x,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 ch_im_in,
                             const ai_i8 *wt,
                             const ai_u16 dim_kernel_x,
                             const ai_u16 dim_kernel_y,
                             const ai_u16 padding_x,
                             const ai_u16 padding_x_r,
                             const ai_u16 padding_y,
                             const ai_u16 padding_y_b,
                             const ai_u16 stride_x,
                             const ai_u16 stride_y,
                             const ai_i32 *bias,
                             const ai_i8 In_ZeroPoint,
                             const ai_i8 Out_ZeroPoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             ai_i8 *Im_out,
                             const ai_u16 dim_im_out_x,
                             const ai_u16 dim_im_out_y);


void
forward_lite_dw_3x3_sssa8_ch(const ai_i8 *Im_in,
                             const ai_u16 dim_im_in_x,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 ch_im_in,
                             const ai_i8 *wt,
                             const ai_u16 stride_x,
                             const ai_u16 stride_y,
                             const ai_i32 *bias,
                             const ai_i8 In_ZeroPoint,
                             const ai_i8 Out_ZeroPoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             ai_i8 *Im_out,
                             const ai_u16 dim_im_out_x,
                             const ai_u16 dim_im_out_y,
                             const ai_i32 nl_pool_fused,
                             const ai_u32 scratch_size,
                             ai_i16 *bufferA);

void
forward_lite_dw_3x3_ch1st_sssa8_ch(const ai_i8 *Im_in,
                                   const ai_u16 dim_im_in_x,
                                   const ai_u16 dim_im_in_y,
                                   const ai_u16 ch_im_in,
                                   const ai_i8 *wt,
                                   const ai_u16 stride_x,
                                   const ai_u16 stride_y,
                                   const ai_i32 *bias,
                                   const ai_i8 In_ZeroPoint,
                                   const ai_i8 Out_ZeroPoint,
                                   const ai_float in_scale,
                                   const ai_float out_scale,
                                   const ai_float *pWt_scale,
                                   ai_i8 *Im_out,
                                   const ai_u16 dim_im_out_x,
                                   const ai_u16 dim_im_out_y,
                                   const ai_i32 nl_pool_fused,
                                   const ai_u32 scratch_size,
                                   ai_i16 *bufferA);


void
forward_lite_dw_1xN_sssa8_ch(const ai_i8 *Im_in,
                             const ai_u16 dim_im_in_y,
                             const ai_u16 ch_im_in,
                             const ai_i8 *wt,
                             const ai_u16 dim_kernel_y,
                             const ai_i32 *bias,
                             const ai_i8 In_ZeroPoint,
                             const ai_i8 Out_ZeroPoint,
                             const ai_float in_scale,
                             const ai_float out_scale,
                             const ai_float *pWt_scale,
                             ai_i8 *Im_out,
                             const ai_u16 dim_im_out_y,
                             const ai_i32 nl_pool_fused,
                             const ai_u32 scratch_size,
                             ai_i16 *bufferA);



#endif   /* LITE_CONV2D_SSSA8_CH_H */
