package com.st.stellar.components.ai.generator

//import com.google.inject.Inject
//import com.google.inject.Provider
import com.st.stellar.ai.aiComponent.AIComponent
//import com.st.stellar.ai.utils.AIComponentHelper
import java.util.Locale
//import org.apache.log4j.LogManager
//import org.apache.log4j.Logger
import org.eclipse.emf.ecore.resource.Resource
//import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.ai.aiComponent.StellarType
import com.st.stellar.ai.aiComponent.ModeType
import java.io.BufferedReader
import java.io.FileReader

class AICodeGenerator extends AbstractGenerator {

//	@Inject Provider<ResourceSet> rsp

//	@Inject extension AIComponentHelper

//	static Logger logger = LogManager.getLogger(AICodeGenerator);

	override doGenerate(Resource r, IFileSystemAccess2 fsa, IGeneratorContext context) {
		
	}

	def String generateAIheader(AIComponent component) {
			
		'''
			/****************************************************************************
			*
			* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved
			*
			* License terms: STMicroelectronics Proprietary in accordance with licensing
			* terms SLA0098 at www.st.com.
			*
			* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
			* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
			*
			*****************************************************************************/
			
			/**
			 * @file    stellar_ai_cfg.h
			 * @brief   Includes of the Stellar AI cfg module.
			 *
			 * @addtogroup STELLAR_AI
			 * @{
			 */
			#ifndef _STELLAR_AI_CFG_H_
			#define _STELLAR_AI_CFG_H_
			«IF component.networks.filter[enabled].size == 0»
				#error "The Network List must include at least one network enabled."
			«ENDIF»
			
			/**
			 * @brief   Validate settings switch.
			 * @details If set to @p TRUE the validate procedure is enabled.   
			 */
			#define STELLAR_AI_VALIDATE    «component.validate.isEnabled?"TRUE":"FALSE"»
			
			#endif /* _STELLAR_AI_CFG_H_ */
			
			/** @} */
		'''
	}

	def String generateValidateAIHeader(AIComponent component) {
		if(!component.validate.isEnabled) {
			""
		} else {
			//val networks = component.networks.filter[isEnabled].map(it|it.name)
			val networks = component.networks.filter[isEnabled]
		'''
				/****************************************************************************
				*
				* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved
				*
				* License terms: STMicroelectronics Proprietary in accordance with licensing
				* terms SLA0098 at www.st.com.
				*
				* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
				* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
				*
				*****************************************************************************/
				
				/**
				 * @file    app_stellar-studio-ai.h
				 * @author  ADG team
				 * @brief   AI Validation application (ST AI embedded legacy/c-api)
				 *
				 * @addtogroup APP_STELLAR-STUDIO-AI
				 * @{
				 */
				
				#ifndef _APP_STELLAR_STUDIO_AI_H_
				#define _APP_STELLAR_STUDIO_AI_H_
				
				#ifdef __cplusplus
				 extern "C" {
				#endif
				
				/* Includes ------------------------------------------------------------------*/
				«IF component.api.configuration == ModeType.STAI»
					#include "stai.h"
				«ENDIF»
				#include "ai_platform.h"
				«FOR network : networks»
					#include "«network.name.toLowerCase(Locale.ENGLISH)».h"
					#include "«network.name.toLowerCase(Locale.ENGLISH)»_data.h"
				«ENDFOR»
				
				#define MIN_HEAP_SIZE 0x2000
				#define MIN_STACK_SIZE 0x1000
				
				«IF component.api.configuration == ModeType.LEGACY»
					«FOR network : networks»
						#define AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_START_ADDR 0xFFFFFFFF
					«ENDFOR»
				«ENDIF»
				
				«IF component.api.configuration == ModeType.LEGACY»	
					#define AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE 0
				«ELSE»
					#define STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE 0
				«ENDIF»
				
				«IF component.api.configuration == ModeType.LEGACY»
					«FOR network : networks»
						#if AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_SIZE > AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE
						#undef AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE
						#define AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_SIZE
						#endif 
					«ENDFOR»
				«ELSE»
					«FOR network : networks»
						#if STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_SIZE > STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE
						#undef STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE
						#define STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_SIZE
						#endif 
					«ENDFOR»
				«ENDIF»
				
				/* IO buffers ----------------------------------------------------------------*/
				
				«IF component.api.configuration == ModeType.LEGACY»
					extern ai_i8* data_ins[];
					extern ai_i8* data_outs[];
					
					«FOR network : networks»
						extern ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[];
					«ENDFOR»
				«ELSE»
					extern stai_ptr data_ins[];
					extern stai_ptr data_outs[];
					
					extern stai_ptr data_activations[];
					extern stai_ptr data_states[];
				«ENDIF»
				
				#if 0
				int STELLAR_AI_Init(void);
				int STELLAR_AI_Process(void);
				#endif
				
				/* USER CODE BEGIN includes */
				/* USER CODE END includes */
				
				/* Multiple network support --------------------------------------------------*/
				
				«IF component.api.configuration == ModeType.LEGACY»
					typedef struct {
					    const char *name;
					    ai_buffer *config;
					    ai_bool (*ai_data_params_get)(ai_network_params* params);
					    ai_bool (*ai_get_report)(ai_handle network, ai_network_report* report);
					    ai_error (*ai_create)(ai_handle* network, const ai_buffer* network_config);
					    ai_error (*ai_get_error)(ai_handle network);
					    ai_handle (*ai_destroy)(ai_handle network);
					    ai_bool (*ai_init)(ai_handle network, const ai_network_params* params);
					    ai_i32 (*ai_run)(ai_handle network, const ai_buffer* input, ai_buffer* output);
					    ai_i32 (*ai_forward)(ai_handle network, const ai_buffer* input);
					    ai_handle *activations;
					} ai_network_entry_t;
					
					#define AI_MNETWORK_NUMBER  («networks.size»)
					
					AI_API_DECLARE_BEGIN
					
					AI_API_ENTRY
					const char* ai_mnetwork_find(const char *name, ai_int idx);
					
					/*!
					 * @brief Get network library report as a datastruct.
					 * @ingroup network
					 * @param[in] network: the handler to the network context
					 * @param[out] report a pointer to the report struct where to
					 * store network info. See @ref ai_network_report struct for details
					 * @return a boolean reporting the exit status of the API
					 */
					AI_API_ENTRY
					ai_bool ai_mnetwork_get_report(
					  ai_handle network, ai_network_report* report);
					
					/*!
					 * @brief Get first network error code.
					 * @ingroup network
					 * @details Get an error code related to the 1st error generated during
					 * network processing. The error code is structure containing an
					 * error type indicating the type of error with an associated error code
					 * Note: after this call the error code is internally reset to AI_ERROR_NONE
					 * @param network an opaque handle to the network context
					 * @return an error type/code pair indicating both the error type and code
					 * see @ref ai_error for struct definition
					 */
					AI_API_ENTRY
					ai_error ai_mnetwork_get_error(ai_handle network);
					
					/*!
					 * @brief Create a neural network.
					 * @ingroup network
					 * @details Instantiate a network and returns an object to handle it;
					 * @param network an opaque handle to the network context
					 * @param network_config a pointer to the network configuration info coded as a
					 * buffer
					 * @return an error code reporting the status of the API on exit
					 */
					AI_API_ENTRY
					ai_error ai_mnetwork_create(const char *name,
					  ai_handle* network, const ai_buffer* network_config);
					
					/*!
					 * @brief Destroy a neural network and frees the allocated memory.
					 * @ingroup network
					 * @details Destroys the network and frees its memory. The network handle is returned;
					 * if the handle is not NULL, the unloading has not been successful.
					 * @param network an opaque handle to the network context
					 * @return an object handle : AI_HANDLE_NULL if network was destroyed
					 * correctly. The same input network handle if destroy failed.
					 */
					AI_API_ENTRY
					ai_handle ai_mnetwork_destroy(ai_handle network);
					
					/*!
					 * @brief Initialize the data structures of the network.
					 * @ingroup network
					 * @details This API initialized the network after a successfull
					 * @ref ai_network_create. Address of the activations memory buffer
					 * need to be provided by caller application
					 *
					 * @param network an opaque handle to the network context
					 * @return true if the network was correctly initialized, false otherwise
					 * in case of error the error type could be queried by
					 * using @ref ai_network_get_error
					 */
					AI_API_ENTRY
					ai_bool ai_mnetwork_init(ai_handle network);
					
					/*!
					 * @brief Run the network and return the output
					 * @ingroup network
					 *
					 * @details Runs the network on the inputs and returns the corresponding output.
					 * The size of the input and output buffers is stored in this
					 * header generated by the code generation tool. See AI_NETWORK_*
					 * defines into file @ref network.h for all network sizes defines
					 *
					 * @param network an opaque handle to the network context
					 * @param[in] input buffer with the input data
					 * @param[out] output buffer with the output data
					 * @return the number of input batches processed (default 1) or <= 0 if it fails
					 * in case of error the error type could be queried by
					 * using @ref ai_network_get_error
					 */
					AI_API_ENTRY
					ai_i32 ai_mnetwork_run(
					  ai_handle network, const ai_buffer* input, ai_buffer* output);
					
					/*!
					 * @brief Runs the network on the inputs.
					 * @ingroup network
					 *
					 * @details Differently from @ref ai_network_run, no output is returned, e.g. for
					 * temporal models with a fixed step size.
					 *
					 * @param network the network to be run
					 * @param[in] input buffer with the input data
					 * @return the number of input batches processed (usually 1) or <= 0 if it fails
					 * in case of error the error type could be queried by
					 * using @ref ai_network_get_error
					 */
					AI_API_ENTRY
					ai_i32 ai_mnetwork_forward(
					  ai_handle network, const ai_buffer* input);
					
					AI_API_ENTRY
					int ai_mnetwork_get_private_handle(ai_handle network,
					        ai_handle *phandle,
					        ai_network_params* pparams);
					
					AI_API_DECLARE_END
				«ELSE»
					typedef struct {
					    const char *name;
					    stai_size (*get_context_size)(void);
					    stai_return_code (*init)(stai_network* network);
					    stai_return_code (*deinit)(stai_network* network);
					    stai_return_code (*run)(stai_network* network, const stai_run_mode mode);
					    stai_return_code (*get_info)(stai_network* network, stai_network_info* info);
					    stai_return_code (*get_error)(stai_network* network);
					
					    stai_return_code (*get_activations)(stai_network* network, stai_ptr* activations, stai_size *n_activations);
					    stai_return_code (*get_states)(stai_network* network, stai_ptr* states, stai_size *n_states);
					    stai_return_code (*get_weights)(stai_network* network, stai_ptr* weights, stai_size *n_weights);
					    stai_return_code (*get_inputs)(stai_network* network, stai_ptr* inputs, stai_size* n_inputs);
					    stai_return_code (*get_outputs)(stai_network* network, stai_ptr* outputs, stai_size* n_outputs);
					
					    stai_return_code (*set_activations)(stai_network* network, const stai_ptr* activations, const stai_size n_activations);
					    stai_return_code (*set_states)(stai_network* network, const stai_ptr* states, const stai_size n_states);
					    stai_return_code (*set_weights)(stai_network* network, const stai_ptr* weights, const stai_size n_weights);
					    stai_return_code (*set_inputs)(stai_network* network, const stai_ptr* inputs, const stai_size n_inputs);
					    stai_return_code (*set_outputs)(stai_network* network, const stai_ptr* outputs, const stai_size n_outputs);
					    stai_return_code (*set_callback)(stai_network* network, const stai_event_cb cb, void* cb_cookie);
					
					    stai_network *context;
					    stai_size n_inputs;
					    stai_size n_outputs;
					    stai_size n_activations;
					    stai_size n_states;
					    stai_size n_weights;
					
					    uintptr_t *weights_addr;
					    
					    const stai_network_details *details;
					
					} stai_network_entry_t;
					
					#define STAI_MNETWORK_NUMBER  («networks.size»)
					
					STAI_API_DECLARE_BEGIN
					
					STAI_API_ENTRY
					const char* stai_mnetwork_find(const char *name, ai_int idx);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_init(const char *name, stai_ptr* network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_deinit(stai_ptr network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_info(stai_ptr network, stai_network_info* report);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_error(stai_ptr network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_run(stai_ptr network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_activations(stai_ptr network, const stai_ptr* activations);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_states(stai_ptr network, const stai_ptr* states);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_weights(stai_ptr network, const stai_ptr* weights);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_inputs(stai_ptr network, const stai_ptr* inputs);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_outputs(stai_ptr network, const stai_ptr* outputs);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_callback(stai_ptr network, const stai_event_cb cb, void* cb_cookie);
					
					STAI_API_ENTRY
					const stai_network_details *stai_mnetwork_get_details(stai_ptr network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_activations(stai_ptr network, stai_ptr* activations);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_states(stai_ptr network, stai_ptr* states);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_weights(stai_ptr network, stai_ptr* weights);
					
					STAI_API_ENTRY
					stai_ptr *stai_mnetwork_get_weights_ext(stai_ptr network);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_inputs(stai_ptr network, stai_ptr* inputs);
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_outputs(stai_ptr network, stai_ptr* outputs);
					
					STAI_API_ENTRY
					ai_handle ai_mnetwork_get_internal_handle(const ai_handle network);
					
					STAI_API_DECLARE_END
				«ENDIF»
				
				#ifdef __cplusplus
				}
				#endif
				
				«IF component.validate.networkToValidate == ""»
					/**
					 * @brief   Validate network check.
					 * @details Check the network on which the validate on target procedure
					 *          is based on.
					 *          If empty, a preprocessor error is generated.
					 */
					#error "For validation on target a valid network (not empty) must be selected: check the Network To Validate configuration field!"
				«ENDIF»
				
				«IF component.validate.serial == ""»
					/**
					 * @brief   Validate serial check.
					 * @details Check the serial used for host to target communication on which
					 *          the validate on target procedure is based on.
					 *          If empty, a preprocessor error is generated.
					 */
					#error "For validation on target a Validate Serial (not empty) must be selected: check the Serial configuration field!"
					#define STELLAR_AI_VALIDATE_SERIAL             NONE
				«ELSE»
					/**
					 * @brief   Validate serial.
					 * @details Specify the serial used for host to target communication on which
					 *          the validate on target procedure is based on.
					 */
					#define STELLAR_AI_VALIDATE_SERIAL             «component.validate.serial.toUpperCase(Locale.ENGLISH)»
				«ENDIF»
				
				#endif /* _APP_STELLAR_STUDIO_AI_H_ */
				
				/** @} */
			'''
		}
	}

	def String generateValidateAIcode(AIComponent component) {
		if(!component.validate.isEnabled) {
			""
		} else {
			val networks = component.networks.filter[isEnabled]
		'''
				/****************************************************************************
				*
				* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved
				*
				* License terms: STMicroelectronics Proprietary in accordance with licensing
				* terms SLA0098 at www.st.com.
				*
				* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
				* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
				*
				*****************************************************************************/
				
				/**
				 * @file    app_stellar-studio-ai.c
				 * @author  ADG team
				 * @brief   Entry point for the Stellar AI test application
				 *
				 * @addtogroup APP_STELLAR-STUDIO-AI
				 * @{
				 */
				
				#ifdef __cplusplus
				 extern "C" {
				#endif
				
				/* Includes ------------------------------------------------------------------*/
				#include <string.h>
				#include "app_stellar-studio-ai.h"
				#include "stellar_ai_validate.h"
				#include "aiTestUtility.h"
				#include "aiValidation.h"
				
				#if 0
				int STELLAR_AI_Init(void)
				{
				  int ret = 0;
				  /* SR5E1_UART_Init(); */
				  /* SR6X_UART_Init(); */
				  aiValidationInit();
				  /* USER CODE BEGIN */
				  /* USER CODE END */
				  return ret;
				}
				
				int STELLAR_AI_Process(void)
				{
				  int ret = aiValidationProcess();
				  port_hal_delay(1000); /* delay 1s */
				  /* USER CODE BEGIN */
				  /* USER CODE END */
				  return ret;
				}
				#endif
				
				/* IO buffers ----------------------------------------------------------------*/
				
				DEF_DATA_IN
				
				DEF_DATA_OUT
				
				
				/* Activations buffers allocation --------------------------------------------*/
				
				«IF component.api.configuration == ModeType.LEGACY»
					«FOR network : networks»
						#if AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_COUNT == 0
						/* Dummy buffer is allocated */
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[4];
						ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[] = {
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_1
						};
						#elif AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_COUNT == 1
						#if AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_1_SIZE == 0
						/* Dummy buffer is allocated */
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[4];
						#else
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_1_SIZE];
						#endif
						ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[] = {
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_1
						};
						#elif AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_COUNT == 2
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_1_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_2[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_2_SIZE];
						ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[] = {
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_1,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_2
						};
						#elif AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_COUNT == 3
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_1_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_2[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_2_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_3[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_3_SIZE];
						ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[] = {
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_1,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_2,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_3
						};
						#elif AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATIONS_COUNT == 4
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_1[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_1_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_2[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_2_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_3[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_3_SIZE];
						AI_ALIGNED(32) static ai_i8 activations_«network.name.toLowerCase(Locale.ENGLISH)»_4[AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_ACTIVATION_4_SIZE];
						ai_handle data_activations_«network.name.toLowerCase(Locale.ENGLISH)»[] = {
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_1,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_2,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_3,
						  activations_«network.name.toLowerCase(Locale.ENGLISH)»_4
						};
						#else
						#error Maximum of 4 activations buffer are supported for the network named «network.name»
						#endif
					«ENDFOR»
				«ELSE»
					«FOR network : networks»
						«IF component.validate.networkToValidate.matches(network.name)»
							«IF network.advancedSettings.allocateActivations == true»
								#undef  STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES 4
								#undef  STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES 4
								#undef  STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES 4
								#undef  STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES 4
							«ELSE»
								#undef  STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATION_1_SIZE_BYTES
								#undef  STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATION_2_SIZE_BYTES
								#undef  STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATION_3_SIZE_BYTES
								#undef  STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES
								#define STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATION_4_SIZE_BYTES
							«ENDIF»
							
							#if STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM == 0
							/* Dummy buffer is allocated */
							STAI_ALIGNED(32) static uint8_t activations_1[4];
							stai_ptr data_activations[] = {
							  activations_1
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM == 1
							#if STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATION_1_SIZE_BYTES == 0
							/* Dummy buffer is allocated */
							STAI_ALIGNED(32) static uint8_t activations_1[4];
							#else
							STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];
							#endif
							stai_ptr data_activations[] = {
							  activations_1
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM == 2
							STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];
							stai_ptr data_activations[] = {
							  activations_1,
							  activations_2
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM == 3
							STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_3[STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES];
							stai_ptr data_activations[] = {
							  activations_1,
							  activations_2,
							  activations_3
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM == 4
							STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_3[STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t activations_4[STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES];
							stai_ptr data_activations[] = {
							  activations_1,
							  activations_2,
							  activations_3,
							  activations_4
							};
							#else
							#error Maximum of 4 activations buffer are supported for the network named «network.name»
							#endif
						«ENDIF»
					«ENDFOR»
				«ENDIF»
				
				/* States buffers allocation -------------------------------------------------*/
				
				«IF component.api.configuration == ModeType.STAI»
					«FOR network : networks»
						«IF component.validate.networkToValidate.matches(network.name)»
							«IF network.advancedSettings.allocateStates == true»
								#undef  STAI_MNETWORK_STATE_1_SIZE_BYTES
								#define STAI_MNETWORK_STATE_1_SIZE_BYTES 4
								#undef  STAI_MNETWORK_STATE_2_SIZE_BYTES
								#define STAI_MNETWORK_STATE_2_SIZE_BYTES 4
								#undef  STAI_MNETWORK_STATE_3_SIZE_BYTES
								#define STAI_MNETWORK_STATE_3_SIZE_BYTES 4
								#undef  STAI_MNETWORK_STATE_4_SIZE_BYTES
								#define STAI_MNETWORK_STATE_4_SIZE_BYTES 4
							«ELSE»
								#undef  STAI_MNETWORK_STATE_1_SIZE_BYTES
								#define STAI_MNETWORK_STATE_1_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATE_1_SIZE_BYTES
								#undef  STAI_MNETWORK_STATE_2_SIZE_BYTES
								#define STAI_MNETWORK_STATE_2_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATE_2_SIZE_BYTES
								#undef  STAI_MNETWORK_STATE_3_SIZE_BYTES
								#define STAI_MNETWORK_STATE_3_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATE_3_SIZE_BYTES
								#undef  STAI_MNETWORK_STATE_4_SIZE_BYTES
								#define STAI_MNETWORK_STATE_4_SIZE_BYTES STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATE_4_SIZE_BYTES
							«ENDIF»
							
							#if STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM == 0
							/* Dummy buffer is allocated */
							STAI_ALIGNED(32) static uint8_t states_1[4];
							stai_ptr data_states[] = {
							  states_1
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM == 1
							#if STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATE_1_SIZE_BYTES == 0
							/* Dummy buffer is allocated */
							STAI_ALIGNED(32) static uint8_t states_1[4];
							#else
							STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];
							#endif
							stai_ptr data_states[] = {
							  states_1
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM == 2
							STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];
							stai_ptr data_states[] = {
							  states_1,
							  states_2
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM == 3
							STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_3[STAI_MNETWORK_STATE_3_SIZE_BYTES];
							stai_ptr data_states[] = {
							  states_1,
							  states_2,
							  states_3
							};
							#elif STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM == 4
							STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_3[STAI_MNETWORK_STATE_3_SIZE_BYTES];
							STAI_ALIGNED(32) static uint8_t states_4[STAI_MNETWORK_STATE_4_SIZE_BYTES];
							stai_ptr data_states[] = {
							  states_1,
							  states_2,
							  states_3,
							  states_4
							};
							#else
							#error Maximum of 4 state buffer are supported for the network named «network.name»
							#endif
						«ENDIF»
					«ENDFOR»
				«ENDIF»
				
				/* Multiple network support --------------------------------------------------*/
				
				#include <string.h>
				#include "ai_datatypes_defines.h"
				
				«IF component.api.configuration == ModeType.LEGACY»
					static const ai_network_entry_t networks[AI_MNETWORK_NUMBER] = {
					«FOR network : networks»
						{
						    .name = (const char *)AI_«network.name.toUpperCase(Locale.ENGLISH)»_MODEL_NAME,
						    .config = AI_«network.name.toUpperCase(Locale.ENGLISH)»_DATA_CONFIG,
						    .ai_get_report = ai_«network.name.toLowerCase(Locale.ENGLISH)»_get_report,
						    .ai_create = ai_«network.name.toLowerCase(Locale.ENGLISH)»_create,
						    .ai_destroy = ai_«network.name.toLowerCase(Locale.ENGLISH)»_destroy,
						    .ai_get_error = ai_«network.name.toLowerCase(Locale.ENGLISH)»_get_error,
						    .ai_init = ai_«network.name.toLowerCase(Locale.ENGLISH)»_init,
						    .ai_run = ai_«network.name.toLowerCase(Locale.ENGLISH)»_run,
						    .ai_forward = ai_«network.name.toLowerCase(Locale.ENGLISH)»_forward,
						    .ai_data_params_get = ai_«network.name.toLowerCase(Locale.ENGLISH)»_data_params_get,
						    .activations = data_activations_«network.name.toLowerCase(Locale.ENGLISH)»
						},
					«ENDFOR»
					};
					
					struct network_instance {
					     const ai_network_entry_t *entry;
					     ai_handle handle;
					     ai_network_params params;
					};
					
					/* Number of instance is aligned on the number of network */
					AI_STATIC struct network_instance gnetworks[AI_MNETWORK_NUMBER] = {0};
					
					AI_DECLARE_STATIC
					ai_bool ai_mnetwork_is_valid(const char* name,
					        const ai_network_entry_t *entry)
					{
					    if (name && (strlen(entry->name) == strlen(name)) &&
					            (strncmp(entry->name, name, strlen(entry->name)) == 0))
					        return true;
					    return false;
					}
					
					AI_DECLARE_STATIC
					struct network_instance *ai_mnetwork_handle(struct network_instance *inst)
					{
					    for (int i=0; i<AI_MNETWORK_NUMBER; i++) {
					        if ((inst) && (&gnetworks[i] == inst))
					            return inst;
					        else if ((!inst) && (gnetworks[i].entry == NULL))
					            return &gnetworks[i];
					    }
					    return NULL;
					}
					
					AI_DECLARE_STATIC
					void ai_mnetwork_release_handle(struct network_instance *inst)
					{
					    for (int i=0; i<AI_MNETWORK_NUMBER; i++) {
					        if ((inst) && (&gnetworks[i] == inst)) {
					            gnetworks[i].entry = NULL;
					            return;
					        }
					    }
					}
					
					AI_API_ENTRY
					const char* ai_mnetwork_find(const char *name, ai_int idx)
					{
					    const ai_network_entry_t *entry;
					
					    for (int i=0; i<AI_MNETWORK_NUMBER; i++) {
					        entry = &networks[i];
					        if (ai_mnetwork_is_valid(name, entry))
					            return entry->name;
					        else {
					            if (!idx--)
					                return entry->name;
					        }
					    }
					    return NULL;
					}
					
					AI_API_ENTRY
					ai_error ai_mnetwork_create(const char *name, ai_handle* network,
					        const ai_buffer* network_config)
					{
					    const ai_network_entry_t *entry;
					    const ai_network_entry_t *found = NULL;
					    ai_error err;
					    struct network_instance *inst = ai_mnetwork_handle(NULL);
					
					    if (!inst) {
					        err.type = AI_ERROR_ALLOCATION_FAILED;
					        err.code = AI_ERROR_CODE_NETWORK;
					        return err;
					    }
					
					    for (int i=0; i<AI_MNETWORK_NUMBER; i++) {
					        entry = &networks[i];
					        if (ai_mnetwork_is_valid(name, entry)) {
					            found = entry;
					            break;
					        }
					    }
					
					    if (!found) {
					        err.type = AI_ERROR_INVALID_PARAM;
					        err.code = AI_ERROR_CODE_NETWORK;
					        return err;
					    }
					
					    if (network_config == NULL)
					        err = found->ai_create(network, found->config);
					    else
					        err = found->ai_create(network, network_config);
					    if ((err.code == AI_ERROR_CODE_NONE) && (err.type == AI_ERROR_NONE)) {
					        inst->entry = found;
					        inst->handle = *network;
					        *network = (ai_handle*)inst;
					    }
					
					    return err;
					}
					
					AI_API_ENTRY
					ai_handle ai_mnetwork_destroy(ai_handle network)
					{
					    struct network_instance *inn;
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn) {
					        ai_handle hdl = inn->entry->ai_destroy(inn->handle);
					        if (hdl != inn->handle) {
					            ai_mnetwork_release_handle(inn);
					            network = AI_HANDLE_NULL;
					        }
					    }
					    return network;
					}
					
					AI_API_ENTRY
					ai_bool ai_mnetwork_get_report(ai_handle network, ai_network_report* report)
					{
					    struct network_instance *inn;
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn)
					        return inn->entry->ai_get_report(inn->handle, report);
					    else
					        return false;
					}
					
					AI_API_ENTRY
					ai_error ai_mnetwork_get_error(ai_handle network)
					{
					    struct network_instance *inn;
					    ai_error err;
					    err.type = AI_ERROR_INVALID_PARAM;
					    err.code = AI_ERROR_CODE_NETWORK;
					
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn)
					        return inn->entry->ai_get_error(inn->handle);
					    else
					        return err;
					}
					
					AI_API_ENTRY
					ai_bool ai_mnetwork_init(ai_handle network)
					{
					    struct network_instance *inn;
					    ai_network_params par;
					
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn) {
					        inn->entry->ai_data_params_get(&par);
					        for (int idx=0; idx < par.map_activations.size; idx++)
					          AI_BUFFER_ARRAY_ITEM_SET_ADDRESS(&par.map_activations, idx, inn->entry->activations[idx]);
					        return inn->entry->ai_init(inn->handle, &par);
					    }
					    else
					        return false;
					}
					
					AI_API_ENTRY
					ai_i32 ai_mnetwork_run(ai_handle network, const ai_buffer* input,
					        ai_buffer* output)
					{
					    struct network_instance* inn;
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn)
					        return inn->entry->ai_run(inn->handle, input, output);
					    else
					        return 0;
					}
					
					AI_API_ENTRY
					ai_i32 ai_mnetwork_forward(ai_handle network, const ai_buffer* input)
					{
					    struct network_instance *inn;
					    inn =  ai_mnetwork_handle((struct network_instance *)network);
					    if (inn)
					        return inn->entry->ai_forward(inn->handle, input);
					    else
					        return 0;
					}
					
					AI_API_ENTRY
					 int ai_mnetwork_get_private_handle(ai_handle network,
					         ai_handle *phandle,
					         ai_network_params *pparams)
					{
					     struct network_instance* inn;
					     inn =  ai_mnetwork_handle((struct network_instance *)network);
					     if (inn && phandle && pparams) {
					         *phandle = inn->handle;
					         *pparams = inn->params;
					         return 0;
					     }
					     else
					         return -1;
					}
				«ELSE»
					«FOR network : networks»
						STAI_NETWORK_CONTEXT_DECLARE(_context_«network.name.toLowerCase(Locale.ENGLISH)», STAI_«network.name.toUpperCase(Locale.ENGLISH)»_CONTEXT_SIZE)
						uintptr_t stai_«network.name.toLowerCase(Locale.ENGLISH)»_weights_addr[STAI_«network.name.toUpperCase(Locale.ENGLISH)»_WEIGHTS_NUM];
						extern const stai_network_details g_«network.name.toLowerCase(Locale.ENGLISH)»_details;
					«ENDFOR»
					
					static const stai_network_entry_t networks[STAI_MNETWORK_NUMBER] = {
					«FOR network : networks»
						{
							.name = (const char *)STAI_«network.name.toUpperCase(Locale.ENGLISH)»_MODEL_NAME,
							.get_context_size = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_context_size,
							.init = stai_«network.name.toLowerCase(Locale.ENGLISH)»_init,
							.deinit = stai_«network.name.toLowerCase(Locale.ENGLISH)»_deinit,
							.run = stai_«network.name.toLowerCase(Locale.ENGLISH)»_run,
							.get_info = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_info,
							.get_error = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_error,
							
							.get_activations = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_activations,
							.get_states = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_states,
							.get_weights = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_weights,
							.get_inputs = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_inputs,
							.get_outputs = stai_«network.name.toLowerCase(Locale.ENGLISH)»_get_outputs,
							
							.set_activations = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_activations,
							.set_states = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_states,
							.set_weights = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_weights,
							.set_inputs = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_inputs,
							.set_outputs = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_outputs,
							.set_callback = stai_«network.name.toLowerCase(Locale.ENGLISH)»_set_callback,
							
							.context = _context_«network.name.toLowerCase(Locale.ENGLISH)»,
							
							.n_inputs = STAI_«network.name.toUpperCase(Locale.ENGLISH)»_IN_NUM,
							.n_outputs = STAI_«network.name.toUpperCase(Locale.ENGLISH)»_OUT_NUM,
							
							.n_activations = STAI_«network.name.toUpperCase(Locale.ENGLISH)»_ACTIVATIONS_NUM,
							.n_states = STAI_«network.name.toUpperCase(Locale.ENGLISH)»_STATES_NUM,
							.n_weights = STAI_«network.name.toUpperCase(Locale.ENGLISH)»_WEIGHTS_NUM,
							.weights_addr = stai_«network.name.toLowerCase(Locale.ENGLISH)»_weights_addr,
							
							.details = &g_«network.name.toLowerCase(Locale.ENGLISH)»_details,
							},
					«ENDFOR»
					};
					
					struct network_instance {
					     const stai_network_entry_t *entry;
					     ai_handle handle;
					};
					
					/* Number of instance is aligned on the number of network */
					static struct network_instance gnetworks[STAI_MNETWORK_NUMBER] = {0};
					
					static ai_bool _stai_mnetwork_is_valid(const char* name,
					    const stai_network_entry_t *entry)
					{
					  if (name && (strlen(entry->name) == strlen(name)) &&
					      (strncmp(entry->name, name, strlen(entry->name)) == 0))
					    return true;
					  return false;
					}
					
					static struct network_instance *_stai_mnetwork_handle(struct network_instance *inst)
					{
					  for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {
					    if ((inst) && (&gnetworks[i] == inst))
					      return inst;
					    else if ((!inst) && (gnetworks[i].entry == NULL))
					      return &gnetworks[i];
					  }
					  return NULL;
					}
					
					static void _stai_mnetwork_release_handle(struct network_instance *inst)
					{
					  for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {
					    if ((inst) && (&gnetworks[i] == inst)) {
					      gnetworks[i].entry = NULL;
					      return;
					    }
					  }
					}
					
					STAI_API_ENTRY
					ai_handle stai_mnetwork_get_internal_handle(const ai_handle network)
					{
					    struct network_instance *inn;
					    inn =  _stai_mnetwork_handle((struct network_instance *)network);
					    if (inn)
					      return inn->handle;
					    return NULL;
					}
					
					STAI_API_ENTRY
					const char* stai_mnetwork_find(const char *name, ai_int idx)
					{
					  const stai_network_entry_t *entry;
					
					  for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {
					    entry = &networks[i];
					    if (_stai_mnetwork_is_valid(name, entry))
					      return entry->name;
					    else {
					      if (!idx--)
					        return entry->name;
					    }
					  }
					  return NULL;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_init(const char *name, stai_ptr* network)
					{
					  const stai_network_entry_t *entry;
					  const stai_network_entry_t *found = NULL;
					  stai_return_code stai_err;
					
					  struct network_instance *inst = _stai_mnetwork_handle(NULL);
					
					  if (!inst || !network) {
					    return STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					  }
					
					  *network = NULL;
					
					  for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {
					    entry = &networks[i];
					    if (_stai_mnetwork_is_valid(name, entry)) {
					      found = entry;
					      break;
					    }
					  }
					
					  if (!found) {
					    return STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					  }
					
					  stai_err = found->init(found->context);
					  if (stai_err == STAI_SUCCESS) {
					    stai_size tmp_;
					    inst->entry = found;
					    inst->handle = found->context;
					    found->get_weights(found->context, (stai_ptr *)found->weights_addr, &tmp_);
					    *network = (stai_ptr)inst;
					    return STAI_SUCCESS;
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_activations(stai_ptr network, const stai_ptr* activations)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn =  _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->set_activations(inn->handle, activations, inn->entry->n_activations);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_states(stai_ptr network, const stai_ptr* states)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn =  _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->set_states(inn->handle, states, inn->entry->n_states);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_weights(stai_ptr network, const stai_ptr* weights)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn =  _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->set_weights(inn->handle, weights, inn->entry->n_weights);
					    inn->entry->get_weights(inn->handle, (stai_ptr *)inn->entry->weights_addr, &tmp_);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_inputs(stai_ptr network, const stai_ptr* inputs)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->set_inputs(inn->handle, inputs, inn->entry->n_inputs);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_outputs(stai_ptr network, const stai_ptr* outputs)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->set_outputs(inn->handle, outputs, inn->entry->n_outputs);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_set_callback(stai_ptr network, const stai_event_cb cb, void* cb_cookie)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->set_callback(inn->handle, cb, cb_cookie);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					const stai_network_details *stai_mnetwork_get_details(stai_ptr network)
					{
					  struct network_instance *inn;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    return inn->entry->details;
					  }
					  return NULL;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_activations(stai_ptr network, stai_ptr* activations)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->get_activations(inn->handle, activations, &tmp_);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_states(stai_ptr network, stai_ptr* states)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->get_states(inn->handle, states, &tmp_);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_weights(stai_ptr network, stai_ptr* weights)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->get_weights(inn->handle, weights, &tmp_);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_ptr *stai_mnetwork_get_weights_ext(stai_ptr network)
					{
					  struct network_instance *inn;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    return (stai_ptr *)inn->entry->weights_addr;
					  }
					  return NULL;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_inputs(stai_ptr network, stai_ptr* inputs)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->get_inputs(inn->handle, inputs, &tmp_);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_outputs(stai_ptr network, stai_ptr* outputs)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_size tmp_;
					    stai_err = inn->entry->get_outputs(inn->handle, outputs, &tmp_);
					  }
					  return stai_err;
					}
					
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_deinit(stai_ptr network)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    stai_err = inn->entry->deinit(inn->handle);
					    if (stai_err == STAI_SUCCESS) {
					      _stai_mnetwork_release_handle(inn);
					    }
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_info(stai_ptr network, stai_network_info* report)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    return inn->entry->get_info(inn->handle, report);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_get_error(stai_ptr network)
					{
					  struct network_instance *inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    return inn->entry->get_error(inn->handle);
					  }
					  return stai_err;
					}
					
					STAI_API_ENTRY
					stai_return_code stai_mnetwork_run(stai_ptr network)
					{
					  struct network_instance* inn;
					  stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;
					
					  inn = _stai_mnetwork_handle((struct network_instance *)network);
					  if (inn) {
					    return inn->entry->run(inn->handle, STAI_MODE_SYNC);
					  }
					  return stai_err;
					}
				«ENDIF»
				
				#ifdef __cplusplus
				}
				#endif
				
				
				/** @} */
			'''
		}
	}

	def String getNetworkCustomLayerFile(String AbsoluteFilePath) {
		var String line = null;
		var int first_index = 0;
		var int last_index = 0;
		/*
		 * Open the json file containing the c file custom layer file.
		 */
		var fileReader = new BufferedReader(new FileReader(AbsoluteFilePath));
		/* Scan the json file searching for the .c file. */
		while ((line = fileReader.readLine()) !== null && !line.contains("c\":")) {
	        /* nothing to do here. */
		}
		/* If c file is found, get the name. */
		if (line !== null) {
			/* get the index of the first occurrence of the " character. */
			first_index = line.indexOf("\"");
			/* update the line based on the index found. */
			line = line.substring(first_index+1);
			/* get the index of the second occurrence of the " character. */
			first_index = line.indexOf("\"");
			/* update the line based on the index found. */
			line = line.substring(first_index+1);
			/* get the index of the third occurrence of the " character. */
			first_index = line.indexOf("\"");
			/* get the length of the updated line. */
			last_index = line.length;
			/* finally get the name of the .c file. */
			line = line.substring(first_index+1, last_index-1);
		}
		/* Close the json file. */
		fileReader.close();
		/* return the result. */
		return line;
	}

	def String generateMakefileAIcode(AIComponent component) {
		val networks = component.networks.filter[isEnabled]
		'''
			«IF component.validate.isEnabled == true»
				################################################################################
				# Project makefile for AI validation.
				################################################################################
			«ELSE»
				################################################################################
				# Project makefile for custom AI application.
				################################################################################
			«ENDIF»
			
			# AI auto-genereted folder
			DIR_NAME := «component.getName()»
			
			################################################################################
			# Add project files
			################################################################################
			
			«IF component.validate.isEnabled == true»
			«IF component.mcu.stellarMcu == StellarType.SR5E1»
				# C sources
				C_SRCS += \
					$(DIR_NAME)/lib/stellar/src/stellar_ai.c \
					$(DIR_NAME)/lib/validation/src/aiPbIO.c \
					$(DIR_NAME)/lib/validation/src/aiPbMemRWServices.c \
					$(DIR_NAME)/lib/validation/src/aiPbMgr.c \
					«IF component.api.configuration == ModeType.LEGACY»
						$(DIR_NAME)/lib/validation/src/aiValidation.c \
					«ELSE»
						$(DIR_NAME)/lib/validation/src/aiValidation_ST_AI.c \
					«ENDIF»
					$(DIR_NAME)/lib/validation/src/pb_common.c \
					$(DIR_NAME)/lib/validation/src/pb_decode.c \
					$(DIR_NAME)/lib/validation/src/pb_encode.c \
					$(DIR_NAME)/lib/validation/src/stellar_ai_validate.c \
					$(DIR_NAME)/lib/validation/src/stm32msg.pb.c \
					$(DIR_NAME)/lib/misc/src/ai_device_adaptor.c \
					«IF component.api.configuration == ModeType.LEGACY»
						$(DIR_NAME)/lib/misc/src/aiTestHelper.c \
					«ELSE»
						$(DIR_NAME)/lib/misc/src/aiTestHelper_ST_AI.c \
					«ENDIF»
					$(DIR_NAME)/lib/misc/src/aiTestUtility.c \
					$(DIR_NAME)/lib/misc/src/syscalls.c
		    «ELSE»
				# C sources
				ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
				C_SRCS += \
					$(DIR_NAME)/lib/stellar/src/stellar_ai.c \
					$(DIR_NAME)/lib/validation/src/aiPbIO.c \
					$(DIR_NAME)/lib/validation/src/aiPbMemRWServices.c \
					$(DIR_NAME)/lib/validation/src/aiPbMgr.c \
					«IF component.api.configuration == ModeType.LEGACY»
						$(DIR_NAME)/lib/validation/src/aiValidation.c \
					«ELSE»
						$(DIR_NAME)/lib/validation/src/aiValidation_ST_AI.c \
					«ENDIF»
					$(DIR_NAME)/lib/validation/src/pb_common.c \
					$(DIR_NAME)/lib/validation/src/pb_decode.c \
					$(DIR_NAME)/lib/validation/src/pb_encode.c \
					$(DIR_NAME)/lib/validation/src/stellar_ai_validate.c \
					$(DIR_NAME)/lib/validation/src/stm32msg.pb.c \
					$(DIR_NAME)/lib/misc/src/ai_device_adaptor.c \
					«IF component.api.configuration == ModeType.LEGACY»
						$(DIR_NAME)/lib/misc/src/aiTestHelper.c \
					«ELSE»
						$(DIR_NAME)/lib/misc/src/aiTestHelper_ST_AI.c \
					«ENDIF»
					$(DIR_NAME)/lib/misc/src/aiTestUtility.c \
					$(DIR_NAME)/lib/misc/src/syscalls.c
				endif
			«ENDIF»
			«ENDIF»
			
			«FOR network : networks»
				C_SRCS += \
					«IF network.customLayerSettings.enable»
						«var customlayerfilename = getNetworkCustomLayerFile(network.customLayerSettings.customLayerJsonAbsoluteFile)»
						«IF customlayerfilename !== null»
							$(DIR_NAME)/cfg/src/«customlayerfilename» \
						«ELSE»
							$(DIR_NAME)/cfg/src/«network.name.toLowerCase(Locale.ENGLISH)»_custom_layers.c \
						«ENDIF»
					«ENDIF»
					«IF component.api.configuration == ModeType.LEGACY»
						$(DIR_NAME)/cfg/src/«network.name.toLowerCase(Locale.ENGLISH)»_data_params.c \
					«ENDIF»
					$(DIR_NAME)/cfg/src/«network.name.toLowerCase(Locale.ENGLISH)»_data.c \
					$(DIR_NAME)/cfg/src/«network.name.toLowerCase(Locale.ENGLISH)».c
			«ENDFOR»
			
			«IF component.validate.isEnabled == true»
			«IF component.mcu.stellarMcu == StellarType.SR5E1»
				C_SRCS += \
					$(DIR_NAME)/cfg/app_stellar-studio-ai.c
		    «ELSE»
				ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
				C_SRCS += \
					$(DIR_NAME)/cfg/app_stellar-studio-ai.c
				endif
			«ENDIF»
			«ENDIF»
			
			# C includes
			C_INCS += \
				$(DIR_NAME)/lib/ai/inc \
				«IF component.validate.isEnabled == true»
				«IF component.mcu.stellarMcu == StellarType.SR5E1»
					$(DIR_NAME)/lib/stellar/inc \
				«ELSE»
					ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph)) \
					$(DIR_NAME)/lib/stellar/inc \
					endif \
				«ENDIF»
				«ENDIF»
				$(DIR_NAME)/cfg/inc \
				$(DIR_NAME)/cfg
			
			«IF component.validate.isEnabled == true»
			«IF component.mcu.stellarMcu == StellarType.SR5E1»
				C_INCS += \
					$(DIR_NAME)/lib/validation/inc \
					$(DIR_NAME)/lib/misc/inc
			«ELSE»
				ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
				C_INCS += \
					$(DIR_NAME)/lib/validation/inc \
					$(DIR_NAME)/lib/misc/inc
				endif
			«ENDIF»
			«ENDIF»
			
			«IF component.mcu.stellarMcu == StellarType.SR5E1»
				# Library includes
				ifeq ($(TOOLCHAIN), ARM)
				LIBS += \
					$(DIR_NAME)/lib/ai/Lib/GCC/StellarE/NetworkRuntime1020_CM7_GCC.a \
					-lm
				else ifeq ($(TOOLCHAIN), HIGHTEC)
				LIBS += \
					$(DIR_NAME)/lib/ai/Lib/HT/StellarE/NetworkRuntime1020_CM7_HT.a
				else ifeq ($(TOOLCHAIN), ARMCLANG)
				LIBS += \
					$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarE/NetworkRuntime1020_CM7_ARMCLANG.a
				else ifeq ($(TOOLCHAIN), IAR)
				LIBS += \
					$(DIR_NAME)/lib/ai/Lib/IAR/StellarE/NetworkRuntime1020_CM7_IAR.a
				endif
			«ELSE»
				# Library includes
				ifneq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
				# dme dsph cores on sr6 devices
					ifeq ($(TOOLCHAIN), ARM)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_M4/NetworkRuntime1020_CM4_GCC.a \
						-lm
					else ifeq ($(TOOLCHAIN), HIGHTEC)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_M4/NetworkRuntime1020_CM4_HT.a
					else ifeq ($(TOOLCHAIN), ARMCLANG)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_M4/NetworkRuntime1020_CM4_ARMCLANG.a
					endif
				else ifneq (,$(filter $(CONFIG_DEVICE),sr6p7g7 sr6p7lp sr6p7 sr6g7))
				# sr6p7g7 sr6p7lp sr6p7 sr6g7 cores
					ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0 cluster1))
						ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a
							endif
						else
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
							endif
						endif
					else
						ifeq ($(TOOLCHAIN), ARM)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
							-lm
						else ifeq ($(TOOLCHAIN), HIGHTEC)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
						else ifeq ($(TOOLCHAIN), ARMCLANG)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
						endif
					endif
				else ifneq (,$(filter $(CONFIG_DEVICE),sr6g6))
				# sr6g6 core
					ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))
						ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a
							endif
						else
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
							endif
						endif
					else
						ifeq ($(TOOLCHAIN), ARM)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
							-lm
						else ifeq ($(TOOLCHAIN), HIGHTEC)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
						else ifeq ($(TOOLCHAIN), ARMCLANG)
						LIBS += \
							$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
						endif
					endif
				else ifneq (,$(filter $(CONFIG_DEVICE),sr6g3))
				# sr6g3 core
					ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))
						ifneq (,$(filter $(CONFIG_TARGET_CORE),core0 core2))
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a
							endif
						else
							ifeq ($(TOOLCHAIN), ARM)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
								-lm
							else ifeq ($(TOOLCHAIN), HIGHTEC)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
							else ifeq ($(TOOLCHAIN), ARMCLANG)
							LIBS += \
								$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
							endif
						endif
					endif
				else
				# sr6p6 sr6p3
					ifeq ($(TOOLCHAIN), ARM)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \
						-lm
					else ifeq ($(TOOLCHAIN), HIGHTEC)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a
					else ifeq ($(TOOLCHAIN), ARMCLANG)
					LIBS += \
						$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a
					endif
				endif
			«ENDIF»
			
			«IF component.validate.isEnabled == true»
				«IF component.mcu.stellarMcu == StellarType.SR5E1»
					# C defines
					C_DEFS += \
						SR5E1
				«ELSE»
					# C defines
					ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
					C_DEFS += \
						SR6X
					endif
				«ENDIF»
			«ENDIF»
			
			«FOR network : networks»
				«IF component.api.configuration == ModeType.STAI»
					# C defines
					C_DEFS += \
						HAVE_«network.name.toUpperCase(Locale.ENGLISH)»_INFO
				«ENDIF»
			«ENDFOR»
		'''
	}
}
