package com.st.stellar.ai.utils

import com.st.stellar.ai.aiComponent.AIComponent
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.Path
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.edit.command.SetCommand

class AIComponentHelper {

	static public AIComponentHelper instance = new AIComponentHelper
//	static String indent = ""

	private new() {
	}


	/**
	 * Get the generated file from PinSettings
	 * @param pinSettings the root object
	 * @return the IFile corresponding to the pinSettings, or null if it does not exist
	 * 
	 */
	def IFile getGeneratedFile(AIComponent component, String ext) {
		val segments = component.eResource.URI.segmentsList
		val segCount = component.eResource.URI.segmentCount

		var destFileName = segments.get(segCount - 1).replaceAll("ai", ext)

		var uri = component.eResource().getURI();
		uri = component.eResource().getResourceSet().getURIConverter().normalize(uri);
		val scheme = uri.scheme();
		if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
			var platformResourcePath = new StringBuffer();
			var int j = 2;
			var size = uri.segmentCount()
			if (size > 3) {
//			platformResourcePath.append('/');
//			platformResourcePath.append(uri.segment(1));
				for (; j < size - 1; j++) {
					platformResourcePath.append('/');
					platformResourcePath.append(uri.segment(j));
				}
				platformResourcePath.append('/');
				platformResourcePath.append(destFileName);
				val file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(platformResourcePath.toString()));
				// file.toString.replace("L/", './data-gen/')
				file
			} else {
				platformResourcePath.append('/');
				platformResourcePath.append(uri.segment(1))
				platformResourcePath.append('/');
				platformResourcePath.append('./data-gen/')
				{
					val folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(
						new Path(platformResourcePath.toString()));
					// val folder = file.getRawLocation().makeAbsolute().toFile
					if (!folder.exists()) {
						folder.create(true, true, null)
					}
				}
				platformResourcePath.append(destFileName);
				val file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(platformResourcePath.toString()));
				// val fileStr = file.toString.replace("L/" + uri.segment(1) + "/", './data-gen/')
				// println(fileStr)
				file
			}
		} else {
			null
		}
	}
	
	def setAttributeValue(EObject object, EAttribute attribute, String value) {
		val editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object)

		val eClassifier = attribute.EType
		if (eClassifier instanceof EDataType) {
			val eDataType = eClassifier as EDataType
			val eFactory = eDataType.getEPackage().getEFactoryInstance()
			val newValue = eFactory.createFromString(eDataType, value)
			val org.eclipse.emf.common.command.Command command = SetCommand.create(editingDomain, object, attribute,
				newValue);
			// System.out.println("Attribute '" + attribute.getName() + "' set to " + newValue.toString());
			editingDomain.getCommandStack().execute(command);
		}
	}
	
}
