package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.Analyze
import com.st.stellar.ai.utils.Utils
import com.st.stellar.components.ai.commands.AIParam
import com.st.stellar.components.ai.commands.impl.AnalyzeCommand
import com.st.stellar.osutils.OsUtils
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.swt.widgets.Display
import org.eclipse.ui.console.MessageConsole
import com.st.stellar.ai.aiComponent.Actions

// This class overrides the generated class and will be instantiated by factory
class AnalyzeImpl extends MAnalyzeImpl implements Analyze {
	static Logger logger = LogManager.getLogger(AnalyzeImpl)

	// Implements: SW_DD_AIAnalyze
	override void analyze() {
		val Actions actions = (this.eContainer() as Actions)
		val AIComponentImpl root = (actions.eContainer() as AIComponentImpl)
		AIParam.getInstance().setAppModel(root)

		if (OsUtils.isWindows()) {
			root.out.println("AI network analysis processing...")
			System.out.println("AI network analysis processing...")
			/* Get the path of the project that includes the AI Component */
			AIParam.getInstance().setAppModel(root)
			Utils.showConsoleView()
			/* Find or create a console. */
			val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
			/* Clear console before printing the Validate output */
			console.clearConsole()
			Display.getDefault().asyncExec([ /* Get AI Command */
				var AnalyzeCommand cmd = new AnalyzeCommand(AIParam.getInstance())
				if (!AIParam.getInstance().launchCommand(cmd)) {
					logger.error("AI network analysis failed")
				} // Refresh explorer view
				Utils.updateExplorer(AnalyzeImpl.this)
				Utils.showConsoleView()
			])
		} else {
			root.out.println("This only works on windows")
			System.out.println("This only works on windows")
		}
	}

	override boolean isEnabled() {
		val actions = eContainer as Actions
		val parent = actions.eContainer as AIComponent 
		val res = parent.networks.filter[isEnabled].size>0
		res
	}
}
