package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.AIFactory
import org.eclipse.emf.ecore.plugin.EcorePlugin

// This factory  renames the generated factory interface to use it as an overriden factory
class AIFactoryImpl extends MAIFactoryImpl implements AIFactory {
	def static AIFactory init() {
		try {
			var Object fact = MAIFactoryImpl::init()
			if((fact !== null) && (fact instanceof AIFactory)) return (fact as AIFactory)
		} catch (Exception exception) {
			EcorePlugin::INSTANCE.log(exception)
		}

		return new AIFactoryImpl()
	}
	
	override createAIComponent() {
		var AIComponent rootObject = super.createAIComponent()
		return rootObject
	}
	
	static int networksNb = 0;
	override createNetwork() {
		val network = new NetworkImpl()
		network.name = "network"+networksNb++
		return network
	}
	
}
