package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.AIPackage
import com.st.stellar.ai.component.validation.MyValidator
import com.st.stellar.ai.utils.Utils
import org.eclipse.emf.ecore.EValidator
import org.eclipse.swt.widgets.Display
import org.eclipse.ui.console.MessageConsole
import org.eclipse.ui.console.MessageConsoleStream

// This class overrides the generated class and will be instantiated by factory
class AIComponentImpl extends MAIComponentImpl implements AIComponent {
	MessageConsoleStream msg
	MessageConsoleStream out
	MessageConsoleStream err
	MessageConsoleStream warn

	new() {
		val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
		/* Clear console before printing the output */
		console.clearConsole()
		Display.getDefault().syncExec([
			Utils.activateConsole(console)
			msg = console.newMessageStream()
			msg.setColor(Utils.DEFAULT_MESSAGE)
			out = console.newMessageStream()
			out.setColor(Utils.DEFAULT_OUTPUT)
			err = console.newMessageStream()
			err.setColor(Utils.DEFAULT_ERROR)
			warn = console.newMessageStream()
			warn.setColor(Utils.DEFAULT_WARNING)
		])
		
		EValidator.Registry.INSTANCE.put(AIPackage.eINSTANCE, new EValidator.Descriptor() {
			override getEValidator() {
				return MyValidator.INSTANCE;
			}
		});
	}
	
	def getOut() {
		return out
	}
	def getMsg() {
		return msg
	}
	def getErr() {
		return err
	}
	def getWarn() {
		return warn
	}
	
	override getName() {
		val uri = eResource.URI
		val fileName = uri.segmentsList().lastOrNull.split("\\.")
		fileName.get(0)
	}
	
}
