/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.generator;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.st.stellar.ai.aiComponent.AIComponent;
import com.st.stellar.ai.utils.AIComponentHelper;
import com.st.stellar.ai.utils.Utils;
import com.st.stellar.component.Component;
import com.st.stellar.components.ai.generator.AICodeGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.xbase.lib.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AIGenerator
extends AbstractGeneratorAdapter {
    public static final Object MODEL_PROJECT_TYPE = "ai";
    static Logger logger = LogManager.getLogger(AIGenerator.class);
    @Inject
    @Extension
    private AIComponentHelper _AIComponentHelper;

    public boolean canGenerate(Object object, Object projectType) {
        return true;
    }

    protected Diagnostic doGenerate(Object object, Object projectType, Monitor monitor) throws Exception {
        AICodeGenerator generator = new AICodeGenerator();
        AIComponent comp = (AIComponent)object;
        String conf = generator.generateAIheader(comp);
        String fileName = "stellar_ai_cfg.h";
        AIGenerator.generateText(comp.getName() + File.separator + "cfg", fileName, conf, monitor);
        conf = generator.generateValidateAIHeader(comp);
        fileName = "app_stellar-studio-ai.h";
        AIGenerator.generateText(comp.getName() + File.separator + "cfg", fileName, conf, monitor);
        conf = generator.generateValidateAIcode(comp);
        fileName = "app_stellar-studio-ai.c";
        AIGenerator.generateText(comp.getName() + File.separator + "cfg", fileName, conf, monitor);
        conf = generator.generateMakefileAIcode(comp);
        fileName = "../stellar_ai.mk";
        AIGenerator.generateText(comp.getName(), fileName, conf, monitor);
        this.generateLibs(comp, (IProgressMonitor)new NullProgressMonitor());
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return Diagnostic.OK_INSTANCE;
    }

    private void generateLibs(Component comp, IProgressMonitor monitor) throws CoreException {
        try {
            this.generateFolders(comp, monitor);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private void generateFolders(Component component, IProgressMonitor monitor) throws CoreException, IOException {
        this.generateFolders(component, monitor, false);
    }

    private void generateFolders(Component component, IProgressMonitor monitor, boolean recreateDeletedWOFiled) throws CoreException, IOException {
        Bundle bundle = FrameworkUtil.getBundle(AIGenerator.class);
        URL resourceURL = bundle.getResource("lib");
        if (resourceURL == null) {
            return;
        }
        IProject project = Utils.getProject((EObject)component);
        project.refreshLocal(2, monitor);
        this.copyResources(component, resourceURL, monitor);
    }

    private void copyResources(Component component, URL resourceURL, IProgressMonitor monitor) throws CoreException, IOException {
        IProject project;
        Path path;
        if (resourceURL == null) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)(path = new Path(File.separator + (project = Utils.getProject((EObject)component)).getName() + File.separator + component.getName() + File.separator + "lib")));
        if (!folder.exists()) {
            AIGenerator.create((IResource)folder, monitor);
            Utils.setReadonly(folder);
        }
        try {
            Utils.copydir(new File(FileLocator.toFileURL((URL)resourceURL).getPath()), (IContainer)folder);
        }
        catch (Exception e) {
            throw new IOException(NLS.bind((String)"An error occurred while generating component ''{0}''", (Object)component.getName()), e);
        }
    }

    private static void create(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            AIGenerator.create((IResource)resource.getParent(), monitor);
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
                break;
            }
            case 2: {
                if (resource.exists()) break;
                ((IFolder)resource).create(0, true, monitor);
                break;
            }
            case 4: {
                ((IProject)resource).create(monitor);
                ((IProject)resource).open(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateText(String targetDir, String fileName, CharSequence text, Monitor monitor) {
        try {
            monitor.beginTask("", 3);
            try {
                IEditorPart ieditorpart;
                IEditorInput editorinput;
                IWorkbenchPage iworkbenchpage;
                IWorkbenchWindow iworkbenchwindow;
                IWorkbench iworkbench = PlatformUI.getWorkbench();
                if (iworkbench != null && (iworkbenchwindow = iworkbench.getActiveWorkbenchWindow()) != null && (iworkbenchpage = iworkbenchwindow.getActivePage()) != null && (editorinput = (ieditorpart = iworkbenchpage.getActiveEditor()).getEditorInput()) instanceof IFileEditorInput) {
                    IFile ifile;
                    File file;
                    IFileEditorInput fei = (IFileEditorInput)editorinput;
                    IProject project = fei.getFile().getProject();
                    IFolder folder = project.getFolder(targetDir);
                    if (!folder.exists()) {
                        AIGenerator.create((IResource)folder, null);
                    }
                    if (!(file = (ifile = project.getFile(targetDir + File.separator + fileName)).getRawLocation().makeAbsolute().toFile()).exists()) {
                        file.createNewFile();
                    }
                    Files.asCharSink((File)file, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]).write(text);
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log((Object)exception);
            }
        }
        finally {
            monitor.done();
        }
    }
}

