/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.generator;

import com.st.stellar.ai.aiComponent.AIComponent;
import com.st.stellar.ai.aiComponent.ModeType;
import com.st.stellar.ai.aiComponent.Network;
import com.st.stellar.ai.aiComponent.StellarType;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AICodeGenerator
extends AbstractGenerator {
    public void doGenerate(Resource r, IFileSystemAccess2 fsa, IGeneratorContext context) {
    }

    public String generateAIheader(AIComponent component) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @file    stellar_ai_cfg.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @brief   Includes of the Stellar AI cfg module.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @addtogroup STELLAR_AI");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @{");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#ifndef _STELLAR_AI_CFG_H_");
        _builder.newLine();
        _builder.append("#define _STELLAR_AI_CFG_H_");
        _builder.newLine();
        Functions.Function1 _function = it -> it.isEnabled();
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(component.getNetworks(), (Functions.Function1)_function));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            _builder.append("#error \"The Network List must include at least one network enabled.\"");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @brief   Validate settings switch.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @details If set to @p TRUE the validate procedure is enabled.   ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#define STELLAR_AI_VALIDATE    ");
        String _xifexpression = null;
        boolean _isEnabled = component.getValidate().isEnabled();
        _xifexpression = _isEnabled ? "TRUE" : "FALSE";
        _builder.append(_xifexpression);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /* _STELLAR_AI_CFG_H_ */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/** @} */");
        _builder.newLine();
        return _builder.toString();
    }

    public String generateValidateAIHeader(AIComponent component) {
        boolean _not;
        String _xifexpression = null;
        boolean _isEnabled = component.getValidate().isEnabled();
        boolean bl = _not = !_isEnabled;
        if (_not) {
            _xifexpression = "";
        } else {
            String _xblockexpression = null;
            Functions.Function1 _function = it -> it.isEnabled();
            Iterable networks = IterableExtensions.filter(component.getNetworks(), (Functions.Function1)_function);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/****************************************************************************");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
            _builder.newLine();
            _builder.append("* terms SLA0098 at www.st.com.");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
            _builder.newLine();
            _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("*****************************************************************************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @file    app_stellar-studio-ai.h");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @author  ADG team");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @brief   AI Validation application (ST AI embedded legacy/c-api)");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @addtogroup APP_STELLAR-STUDIO-AI");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @{");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#ifndef _APP_STELLAR_STUDIO_AI_H_");
            _builder.newLine();
            _builder.append("#define _APP_STELLAR_STUDIO_AI_H_");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#ifdef __cplusplus");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("extern \"C\" {");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* Includes ------------------------------------------------------------------*/");
            _builder.newLine();
            ModeType _configuration = component.getApi().getConfiguration();
            boolean _equals = Objects.equals((Object)_configuration, (Object)ModeType.STAI);
            if (_equals) {
                _builder.append("#include \"stai.h\"");
                _builder.newLine();
            }
            _builder.append("#include \"ai_platform.h\"");
            _builder.newLine();
            for (Network network : networks) {
                _builder.append("#include \"");
                Iterator _lowerCase = network.getName().toLowerCase(Locale.ENGLISH);
                _builder.append((String)((Object)_lowerCase));
                _builder.append(".h\"");
                _builder.newLineIfNotEmpty();
                _builder.append("#include \"");
                String _lowerCase_1 = network.getName().toLowerCase(Locale.ENGLISH);
                _builder.append(_lowerCase_1);
                _builder.append("_data.h\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("#define MIN_HEAP_SIZE 0x2000");
            _builder.newLine();
            _builder.append("#define MIN_STACK_SIZE 0x1000");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration_1 = component.getApi().getConfiguration();
            boolean _equals_1 = Objects.equals((Object)_configuration_1, (Object)ModeType.LEGACY);
            if (_equals_1) {
                for (Network network_1 : networks) {
                    _builder.append("#define AI_");
                    String _upperCase = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase);
                    _builder.append("_DATA_ACTIVATIONS_START_ADDR 0xFFFFFFFF");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.newLine();
            ModeType _configuration_2 = component.getApi().getConfiguration();
            boolean _equals_2 = Objects.equals((Object)_configuration_2, (Object)ModeType.LEGACY);
            if (_equals_2) {
                _builder.append("#define AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE 0");
                _builder.newLine();
            } else {
                _builder.append("#define STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE 0");
                _builder.newLine();
            }
            _builder.newLine();
            ModeType _configuration_3 = component.getApi().getConfiguration();
            boolean _equals_3 = Objects.equals((Object)_configuration_3, (Object)ModeType.LEGACY);
            if (_equals_3) {
                for (Network network_2 : networks) {
                    _builder.append("#if AI_");
                    String _upperCase_1 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_1);
                    _builder.append("_DATA_ACTIVATIONS_SIZE > AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#undef AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE");
                    _builder.newLine();
                    _builder.append("#define AI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE AI_");
                    String _upperCase_2 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_2);
                    _builder.append("_DATA_ACTIVATIONS_SIZE");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif ");
                    _builder.newLine();
                }
            } else {
                for (Network network_3 : networks) {
                    _builder.append("#if STAI_");
                    String _upperCase_3 = network_3.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_3);
                    _builder.append("_ACTIVATIONS_SIZE > STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#undef STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE");
                    _builder.newLine();
                    _builder.append("#define STAI_MNETWORK_DATA_ACTIVATIONS_INT_SIZE STAI_");
                    String _upperCase_4 = network_3.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_4);
                    _builder.append("_ACTIVATIONS_SIZE");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif ");
                    _builder.newLine();
                }
            }
            _builder.newLine();
            _builder.append("/* IO buffers ----------------------------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration_4 = component.getApi().getConfiguration();
            boolean _equals_4 = Objects.equals((Object)_configuration_4, (Object)ModeType.LEGACY);
            if (_equals_4) {
                _builder.append("extern ai_i8* data_ins[];");
                _builder.newLine();
                _builder.append("extern ai_i8* data_outs[];");
                _builder.newLine();
                _builder.newLine();
                for (Network network_4 : networks) {
                    _builder.append("extern ai_handle data_activations_");
                    String _lowerCase_2 = network_4.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_2);
                    _builder.append("[];");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append("extern stai_ptr data_ins[];");
                _builder.newLine();
                _builder.append("extern stai_ptr data_outs[];");
                _builder.newLine();
                _builder.newLine();
                _builder.append("extern stai_ptr data_activations[];");
                _builder.newLine();
                _builder.append("extern stai_ptr data_states[];");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("#if 0");
            _builder.newLine();
            _builder.append("int STELLAR_AI_Init(void);");
            _builder.newLine();
            _builder.append("int STELLAR_AI_Process(void);");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* USER CODE BEGIN includes */");
            _builder.newLine();
            _builder.append("/* USER CODE END includes */");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* Multiple network support --------------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration_5 = component.getApi().getConfiguration();
            boolean _equals_5 = Objects.equals((Object)_configuration_5, (Object)ModeType.LEGACY);
            if (_equals_5) {
                _builder.append("typedef struct {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const char *name;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_buffer *config;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_bool (*ai_data_params_get)(ai_network_params* params);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_bool (*ai_get_report)(ai_handle network, ai_network_report* report);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_error (*ai_create)(ai_handle* network, const ai_buffer* network_config);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_error (*ai_get_error)(ai_handle network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_handle (*ai_destroy)(ai_handle network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_bool (*ai_init)(ai_handle network, const ai_network_params* params);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_i32 (*ai_run)(ai_handle network, const ai_buffer* input, ai_buffer* output);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_i32 (*ai_forward)(ai_handle network, const ai_buffer* input);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_handle *activations;");
                _builder.newLine();
                _builder.append("} ai_network_entry_t;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("#define AI_MNETWORK_NUMBER  (");
                int _size = IterableExtensions.size((Iterable)networks);
                _builder.append((Object)_size);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("AI_API_DECLARE_BEGIN");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("const char* ai_mnetwork_find(const char *name, ai_int idx);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Get network library report as a datastruct.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param[in] network: the handler to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param[out] report a pointer to the report struct where to");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* store network info. See @ref ai_network_report struct for details");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return a boolean reporting the exit status of the API");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_bool ai_mnetwork_get_report(");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("ai_handle network, ai_network_report* report);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Get first network error code.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Get an error code related to the 1st error generated during");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* network processing. The error code is structure containing an");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* error type indicating the type of error with an associated error code");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Note: after this call the error code is internally reset to AI_ERROR_NONE");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network an opaque handle to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return an error type/code pair indicating both the error type and code");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* see @ref ai_error for struct definition");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_error ai_mnetwork_get_error(ai_handle network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Create a neural network.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Instantiate a network and returns an object to handle it;");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network an opaque handle to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network_config a pointer to the network configuration info coded as a");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* buffer");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return an error code reporting the status of the API on exit");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_error ai_mnetwork_create(const char *name,");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("ai_handle* network, const ai_buffer* network_config);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Destroy a neural network and frees the allocated memory.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Destroys the network and frees its memory. The network handle is returned;");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* if the handle is not NULL, the unloading has not been successful.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network an opaque handle to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return an object handle : AI_HANDLE_NULL if network was destroyed");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* correctly. The same input network handle if destroy failed.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_handle ai_mnetwork_destroy(ai_handle network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Initialize the data structures of the network.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details This API initialized the network after a successfull");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ref ai_network_create. Address of the activations memory buffer");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* need to be provided by caller application");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network an opaque handle to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return true if the network was correctly initialized, false otherwise");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* in case of error the error type could be queried by");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* using @ref ai_network_get_error");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_bool ai_mnetwork_init(ai_handle network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Run the network and return the output");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Runs the network on the inputs and returns the corresponding output.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* The size of the input and output buffers is stored in this");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* header generated by the code generation tool. See AI_NETWORK_*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* defines into file @ref network.h for all network sizes defines");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network an opaque handle to the network context");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param[in] input buffer with the input data");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param[out] output buffer with the output data");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return the number of input batches processed (default 1) or <= 0 if it fails");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* in case of error the error type could be queried by");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* using @ref ai_network_get_error");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_i32 ai_mnetwork_run(");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("ai_handle network, const ai_buffer* input, ai_buffer* output);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/*!");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief Runs the network on the inputs.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @ingroup network");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Differently from @ref ai_network_run, no output is returned, e.g. for");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* temporal models with a fixed step size.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param network the network to be run");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @param[in] input buffer with the input data");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return the number of input batches processed (usually 1) or <= 0 if it fails");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* in case of error the error type could be queried by");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* using @ref ai_network_get_error");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_i32 ai_mnetwork_forward(");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("ai_handle network, const ai_buffer* input);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("int ai_mnetwork_get_private_handle(ai_handle network,");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("ai_handle *phandle,");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("ai_network_params* pparams);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_DECLARE_END");
                _builder.newLine();
            } else {
                _builder.append("typedef struct {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const char *name;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size (*get_context_size)(void);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*init)(stai_network* network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*deinit)(stai_network* network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*run)(stai_network* network, const stai_run_mode mode);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_info)(stai_network* network, stai_network_info* info);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_error)(stai_network* network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_activations)(stai_network* network, stai_ptr* activations, stai_size *n_activations);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_states)(stai_network* network, stai_ptr* states, stai_size *n_states);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_weights)(stai_network* network, stai_ptr* weights, stai_size *n_weights);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_inputs)(stai_network* network, stai_ptr* inputs, stai_size* n_inputs);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*get_outputs)(stai_network* network, stai_ptr* outputs, stai_size* n_outputs);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_activations)(stai_network* network, const stai_ptr* activations, const stai_size n_activations);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_states)(stai_network* network, const stai_ptr* states, const stai_size n_states);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_weights)(stai_network* network, const stai_ptr* weights, const stai_size n_weights);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_inputs)(stai_network* network, const stai_ptr* inputs, const stai_size n_inputs);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_outputs)(stai_network* network, const stai_ptr* outputs, const stai_size n_outputs);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_return_code (*set_callback)(stai_network* network, const stai_event_cb cb, void* cb_cookie);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_network *context;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size n_inputs;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size n_outputs;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size n_activations;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size n_states;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size n_weights;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("uintptr_t *weights_addr;");
                _builder.newLine();
                _builder.append("    ");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const stai_network_details *details;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("} stai_network_entry_t;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("#define STAI_MNETWORK_NUMBER  (");
                int _size_1 = IterableExtensions.size((Iterable)networks);
                _builder.append((Object)_size_1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("STAI_API_DECLARE_BEGIN");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("const char* stai_mnetwork_find(const char *name, ai_int idx);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_init(const char *name, stai_ptr* network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_deinit(stai_ptr network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_info(stai_ptr network, stai_network_info* report);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_error(stai_ptr network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_run(stai_ptr network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_activations(stai_ptr network, const stai_ptr* activations);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_states(stai_ptr network, const stai_ptr* states);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_weights(stai_ptr network, const stai_ptr* weights);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_inputs(stai_ptr network, const stai_ptr* inputs);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_outputs(stai_ptr network, const stai_ptr* outputs);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_callback(stai_ptr network, const stai_event_cb cb, void* cb_cookie);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("const stai_network_details *stai_mnetwork_get_details(stai_ptr network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_activations(stai_ptr network, stai_ptr* activations);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_states(stai_ptr network, stai_ptr* states);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_weights(stai_ptr network, stai_ptr* weights);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_ptr *stai_mnetwork_get_weights_ext(stai_ptr network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_inputs(stai_ptr network, stai_ptr* inputs);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_outputs(stai_ptr network, stai_ptr* outputs);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_handle ai_mnetwork_get_internal_handle(const ai_handle network);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_DECLARE_END");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("#ifdef __cplusplus");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            String _networkToValidate = component.getValidate().getNetworkToValidate();
            boolean _equals_6 = Objects.equals(_networkToValidate, "");
            if (_equals_6) {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief   Validate network check.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Check the network on which the validate on target procedure");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*          is based on.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*          If empty, a preprocessor error is generated.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("#error \"For validation on target a valid network (not empty) must be selected: check the Network To Validate configuration field!\"");
                _builder.newLine();
            }
            _builder.newLine();
            String _serial = component.getValidate().getSerial();
            boolean _equals_7 = Objects.equals(_serial, "");
            if (_equals_7) {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief   Validate serial check.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Check the serial used for host to target communication on which");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*          the validate on target procedure is based on.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*          If empty, a preprocessor error is generated.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("#error \"For validation on target a Validate Serial (not empty) must be selected: check the Serial configuration field!\"");
                _builder.newLine();
                _builder.append("#define STELLAR_AI_VALIDATE_SERIAL             NONE");
                _builder.newLine();
            } else {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @brief   Validate serial.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @details Specify the serial used for host to target communication on which");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*          the validate on target procedure is based on.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("#define STELLAR_AI_VALIDATE_SERIAL             ");
                String _upperCase_5 = component.getValidate().getSerial().toUpperCase(Locale.ENGLISH);
                _builder.append(_upperCase_5);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("#endif /* _APP_STELLAR_STUDIO_AI_H_ */");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/** @} */");
            _builder.newLine();
            _xifexpression = _xblockexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public String generateValidateAIcode(AIComponent component) {
        boolean _not;
        String _xifexpression = null;
        boolean _isEnabled = component.getValidate().isEnabled();
        boolean bl = _not = !_isEnabled;
        if (_not) {
            _xifexpression = "";
        } else {
            String _xblockexpression = null;
            Functions.Function1 _function = it -> it.isEnabled();
            Iterable networks = IterableExtensions.filter(component.getNetworks(), (Functions.Function1)_function);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("/****************************************************************************");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* Copyright (c) 2023,2024 STMicroelectronics - All Rights Reserved");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
            _builder.newLine();
            _builder.append("* terms SLA0098 at www.st.com.");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
            _builder.newLine();
            _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
            _builder.newLine();
            _builder.append("*");
            _builder.newLine();
            _builder.append("*****************************************************************************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @file    app_stellar-studio-ai.c");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @author  ADG team");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @brief   Entry point for the Stellar AI test application");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @addtogroup APP_STELLAR-STUDIO-AI");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @{");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#ifdef __cplusplus");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("extern \"C\" {");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* Includes ------------------------------------------------------------------*/");
            _builder.newLine();
            _builder.append("#include <string.h>");
            _builder.newLine();
            _builder.append("#include \"app_stellar-studio-ai.h\"");
            _builder.newLine();
            _builder.append("#include \"stellar_ai_validate.h\"");
            _builder.newLine();
            _builder.append("#include \"aiTestUtility.h\"");
            _builder.newLine();
            _builder.append("#include \"aiValidation.h\"");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#if 0");
            _builder.newLine();
            _builder.append("int STELLAR_AI_Init(void)");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("int ret = 0;");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* SR5E1_UART_Init(); */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* SR6X_UART_Init(); */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("aiValidationInit();");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* USER CODE BEGIN */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* USER CODE END */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return ret;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("int STELLAR_AI_Process(void)");
            _builder.newLine();
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("int ret = aiValidationProcess();");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("port_hal_delay(1000); /* delay 1s */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* USER CODE BEGIN */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("/* USER CODE END */");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("return ret;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* IO buffers ----------------------------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("DEF_DATA_IN");
            _builder.newLine();
            _builder.newLine();
            _builder.append("DEF_DATA_OUT");
            _builder.newLine();
            _builder.newLine();
            _builder.newLine();
            _builder.append("/* Activations buffers allocation --------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration = component.getApi().getConfiguration();
            boolean _equals = Objects.equals((Object)_configuration, (Object)ModeType.LEGACY);
            if (_equals) {
                for (Network network : networks) {
                    _builder.append("#if AI_");
                    String _upperCase = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase);
                    _builder.append("_DATA_ACTIVATIONS_COUNT == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase);
                    _builder.append("_1[4];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("ai_handle data_activations_");
                    String _lowerCase_1 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_1);
                    _builder.append("[] = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_2 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_2, "  ");
                    _builder.append("_1");
                    _builder.newLineIfNotEmpty();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif AI_");
                    String _upperCase_1 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_1);
                    _builder.append("_DATA_ACTIVATIONS_COUNT == 1");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#if AI_");
                    String _upperCase_2 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_2);
                    _builder.append("_DATA_ACTIVATION_1_SIZE == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_3 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_3);
                    _builder.append("_1[4];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_4 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_4);
                    _builder.append("_1[AI_");
                    String _upperCase_3 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_3);
                    _builder.append("_DATA_ACTIVATION_1_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif");
                    _builder.newLine();
                    _builder.append("ai_handle data_activations_");
                    String _lowerCase_5 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_5);
                    _builder.append("[] = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_6 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_6, "  ");
                    _builder.append("_1");
                    _builder.newLineIfNotEmpty();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif AI_");
                    String _upperCase_4 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_4);
                    _builder.append("_DATA_ACTIVATIONS_COUNT == 2");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_7 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_7);
                    _builder.append("_1[AI_");
                    String _upperCase_5 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_5);
                    _builder.append("_DATA_ACTIVATION_1_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_8 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_8);
                    _builder.append("_2[AI_");
                    String _upperCase_6 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_6);
                    _builder.append("_DATA_ACTIVATION_2_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("ai_handle data_activations_");
                    String _lowerCase_9 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_9);
                    _builder.append("[] = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_10 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_10, "  ");
                    _builder.append("_1,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_11 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_11, "  ");
                    _builder.append("_2");
                    _builder.newLineIfNotEmpty();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif AI_");
                    String _upperCase_7 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_7);
                    _builder.append("_DATA_ACTIVATIONS_COUNT == 3");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_12 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_12);
                    _builder.append("_1[AI_");
                    String _upperCase_8 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_8);
                    _builder.append("_DATA_ACTIVATION_1_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_13 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_13);
                    _builder.append("_2[AI_");
                    String _upperCase_9 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_9);
                    _builder.append("_DATA_ACTIVATION_2_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_14 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_14);
                    _builder.append("_3[AI_");
                    String _upperCase_10 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_10);
                    _builder.append("_DATA_ACTIVATION_3_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("ai_handle data_activations_");
                    String _lowerCase_15 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_15);
                    _builder.append("[] = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_16 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_16, "  ");
                    _builder.append("_1,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_17 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_17, "  ");
                    _builder.append("_2,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_18 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_18, "  ");
                    _builder.append("_3");
                    _builder.newLineIfNotEmpty();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif AI_");
                    String _upperCase_11 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_11);
                    _builder.append("_DATA_ACTIVATIONS_COUNT == 4");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_19 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_19);
                    _builder.append("_1[AI_");
                    String _upperCase_12 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_12);
                    _builder.append("_DATA_ACTIVATION_1_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_20 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_20);
                    _builder.append("_2[AI_");
                    String _upperCase_13 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_13);
                    _builder.append("_DATA_ACTIVATION_2_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_21 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_21);
                    _builder.append("_3[AI_");
                    String _upperCase_14 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_14);
                    _builder.append("_DATA_ACTIVATION_3_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("AI_ALIGNED(32) static ai_i8 activations_");
                    String _lowerCase_22 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_22);
                    _builder.append("_4[AI_");
                    String _upperCase_15 = network.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_15);
                    _builder.append("_DATA_ACTIVATION_4_SIZE];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("ai_handle data_activations_");
                    String _lowerCase_23 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_23);
                    _builder.append("[] = {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_24 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_24, "  ");
                    _builder.append("_1,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_25 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_25, "  ");
                    _builder.append("_2,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_26 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_26, "  ");
                    _builder.append("_3,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("  ");
                    _builder.append("activations_");
                    String _lowerCase_27 = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_27, "  ");
                    _builder.append("_4");
                    _builder.newLineIfNotEmpty();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("#error Maximum of 4 activations buffer are supported for the network named ");
                    String _name = network.getName();
                    _builder.append(_name);
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif");
                    _builder.newLine();
                }
            } else {
                for (Network network_1 : networks) {
                    boolean _equals_1;
                    boolean _matches = component.getValidate().getNetworkToValidate().matches(network_1.getName());
                    if (!_matches) continue;
                    boolean _isAllocateActivations = network_1.getAdvancedSettings().isAllocateActivations();
                    boolean bl2 = _equals_1 = _isAllocateActivations;
                    if (_equals_1) {
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES 4");
                        _builder.newLine();
                    } else {
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES STAI_");
                        String _upperCase_16 = network_1.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_16);
                        _builder.append("_ACTIVATION_1_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES STAI_");
                        String _upperCase_17 = network_1.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_17);
                        _builder.append("_ACTIVATION_2_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES STAI_");
                        String _upperCase_18 = network_1.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_18);
                        _builder.append("_ACTIVATION_3_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES STAI_");
                        String _upperCase_19 = network_1.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_19);
                        _builder.append("_ACTIVATION_4_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append("#if STAI_");
                    String _upperCase_20 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_20);
                    _builder.append("_ACTIVATIONS_NUM == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[4];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_activations[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_1");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_21 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_21);
                    _builder.append("_ACTIVATIONS_NUM == 1");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#if STAI_");
                    String _upperCase_22 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_22);
                    _builder.append("_ACTIVATION_1_SIZE_BYTES == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[4];");
                    _builder.newLine();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("#endif");
                    _builder.newLine();
                    _builder.append("stai_ptr data_activations[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_1");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_23 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_23);
                    _builder.append("_ACTIVATIONS_NUM == 2");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_activations[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_2");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_24 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_24);
                    _builder.append("_ACTIVATIONS_NUM == 3");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_3[STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_activations[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_2,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_3");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_25 = network_1.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_25);
                    _builder.append("_ACTIVATIONS_NUM == 4");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_1[STAI_MNETWORK_ACTIVATION_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_2[STAI_MNETWORK_ACTIVATION_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_3[STAI_MNETWORK_ACTIVATION_3_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t activations_4[STAI_MNETWORK_ACTIVATION_4_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_activations[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_2,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_3,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("activations_4");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("#error Maximum of 4 activations buffer are supported for the network named ");
                    String _name_1 = network_1.getName();
                    _builder.append(_name_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif");
                    _builder.newLine();
                }
            }
            _builder.newLine();
            _builder.append("/* States buffers allocation -------------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration_1 = component.getApi().getConfiguration();
            boolean _equals_2 = Objects.equals((Object)_configuration_1, (Object)ModeType.STAI);
            if (_equals_2) {
                for (Network network_2 : networks) {
                    boolean _equals_3;
                    boolean _matches_1 = component.getValidate().getNetworkToValidate().matches(network_2.getName());
                    if (!_matches_1) continue;
                    boolean _isAllocateStates = network_2.getAdvancedSettings().isAllocateStates();
                    boolean bl3 = _equals_3 = _isAllocateStates;
                    if (_equals_3) {
                        _builder.append("#undef  STAI_MNETWORK_STATE_1_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_1_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_STATE_2_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_2_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_STATE_3_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_3_SIZE_BYTES 4");
                        _builder.newLine();
                        _builder.append("#undef  STAI_MNETWORK_STATE_4_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_4_SIZE_BYTES 4");
                        _builder.newLine();
                    } else {
                        _builder.append("#undef  STAI_MNETWORK_STATE_1_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_1_SIZE_BYTES STAI_");
                        String _upperCase_26 = network_2.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_26);
                        _builder.append("_STATE_1_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_STATE_2_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_2_SIZE_BYTES STAI_");
                        String _upperCase_27 = network_2.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_27);
                        _builder.append("_STATE_2_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_STATE_3_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_3_SIZE_BYTES STAI_");
                        String _upperCase_28 = network_2.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_28);
                        _builder.append("_STATE_3_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                        _builder.append("#undef  STAI_MNETWORK_STATE_4_SIZE_BYTES");
                        _builder.newLine();
                        _builder.append("#define STAI_MNETWORK_STATE_4_SIZE_BYTES STAI_");
                        String _upperCase_29 = network_2.getName().toUpperCase(Locale.ENGLISH);
                        _builder.append(_upperCase_29);
                        _builder.append("_STATE_4_SIZE_BYTES");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.newLine();
                    _builder.append("#if STAI_");
                    String _upperCase_30 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_30);
                    _builder.append("_STATES_NUM == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[4];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_states[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_1");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_31 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_31);
                    _builder.append("_STATES_NUM == 1");
                    _builder.newLineIfNotEmpty();
                    _builder.append("#if STAI_");
                    String _upperCase_32 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_32);
                    _builder.append("_STATE_1_SIZE_BYTES == 0");
                    _builder.newLineIfNotEmpty();
                    _builder.append("/* Dummy buffer is allocated */");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[4];");
                    _builder.newLine();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("#endif");
                    _builder.newLine();
                    _builder.append("stai_ptr data_states[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_1");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_33 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_33);
                    _builder.append("_STATES_NUM == 2");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_states[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_2");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_34 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_34);
                    _builder.append("_STATES_NUM == 3");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_3[STAI_MNETWORK_STATE_3_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_states[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_2,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_3");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#elif STAI_");
                    String _upperCase_35 = network_2.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_35);
                    _builder.append("_STATES_NUM == 4");
                    _builder.newLineIfNotEmpty();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_1[STAI_MNETWORK_STATE_1_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_2[STAI_MNETWORK_STATE_2_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_3[STAI_MNETWORK_STATE_3_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("STAI_ALIGNED(32) static uint8_t states_4[STAI_MNETWORK_STATE_4_SIZE_BYTES];");
                    _builder.newLine();
                    _builder.append("stai_ptr data_states[] = {");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_1,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_2,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_3,");
                    _builder.newLine();
                    _builder.append("  ");
                    _builder.append("states_4");
                    _builder.newLine();
                    _builder.append("};");
                    _builder.newLine();
                    _builder.append("#else");
                    _builder.newLine();
                    _builder.append("#error Maximum of 4 state buffer are supported for the network named ");
                    String _name_2 = network_2.getName();
                    _builder.append(_name_2);
                    _builder.newLineIfNotEmpty();
                    _builder.append("#endif");
                    _builder.newLine();
                }
            }
            _builder.newLine();
            _builder.append("/* Multiple network support --------------------------------------------------*/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("#include <string.h>");
            _builder.newLine();
            _builder.append("#include \"ai_datatypes_defines.h\"");
            _builder.newLine();
            _builder.newLine();
            ModeType _configuration_2 = component.getApi().getConfiguration();
            boolean _equals_4 = Objects.equals((Object)_configuration_2, (Object)ModeType.LEGACY);
            if (_equals_4) {
                _builder.append("static const ai_network_entry_t networks[AI_MNETWORK_NUMBER] = {");
                _builder.newLine();
                for (Network network_3 : networks) {
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("    ");
                    _builder.append(".name = (const char *)AI_");
                    String _upperCase_36 = network_3.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_36, "    ");
                    _builder.append("_MODEL_NAME,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".config = AI_");
                    String _upperCase_37 = network_3.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_37, "    ");
                    _builder.append("_DATA_CONFIG,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_get_report = ai_");
                    String _lowerCase_28 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_28, "    ");
                    _builder.append("_get_report,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_create = ai_");
                    String _lowerCase_29 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_29, "    ");
                    _builder.append("_create,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_destroy = ai_");
                    String _lowerCase_30 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_30, "    ");
                    _builder.append("_destroy,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_get_error = ai_");
                    String _lowerCase_31 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_31, "    ");
                    _builder.append("_get_error,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_init = ai_");
                    String _lowerCase_32 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_32, "    ");
                    _builder.append("_init,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_run = ai_");
                    String _lowerCase_33 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_33, "    ");
                    _builder.append("_run,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_forward = ai_");
                    String _lowerCase_34 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_34, "    ");
                    _builder.append("_forward,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".ai_data_params_get = ai_");
                    String _lowerCase_35 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_35, "    ");
                    _builder.append("_data_params_get,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("    ");
                    _builder.append(".activations = data_activations_");
                    String _lowerCase_36 = network_3.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_36, "    ");
                    _builder.newLineIfNotEmpty();
                    _builder.append("},");
                    _builder.newLine();
                }
                _builder.append("};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("struct network_instance {");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("const ai_network_entry_t *entry;");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("ai_handle handle;");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("ai_network_params params;");
                _builder.newLine();
                _builder.append("};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/* Number of instance is aligned on the number of network */");
                _builder.newLine();
                _builder.append("AI_STATIC struct network_instance gnetworks[AI_MNETWORK_NUMBER] = {0};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_DECLARE_STATIC");
                _builder.newLine();
                _builder.append("ai_bool ai_mnetwork_is_valid(const char* name,");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("const ai_network_entry_t *entry)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (name && (strlen(entry->name) == strlen(name)) &&");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("(strncmp(entry->name, name, strlen(entry->name)) == 0))");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_DECLARE_STATIC");
                _builder.newLine();
                _builder.append("struct network_instance *ai_mnetwork_handle(struct network_instance *inst)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("for (int i=0; i<AI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("if ((inst) && (&gnetworks[i] == inst))");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("return inst;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("else if ((!inst) && (gnetworks[i].entry == NULL))");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("return &gnetworks[i];");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_DECLARE_STATIC");
                _builder.newLine();
                _builder.append("void ai_mnetwork_release_handle(struct network_instance *inst)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("for (int i=0; i<AI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("if ((inst) && (&gnetworks[i] == inst)) {");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("gnetworks[i].entry = NULL;");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("return;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("const char* ai_mnetwork_find(const char *name, ai_int idx)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const ai_network_entry_t *entry;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("for (int i=0; i<AI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("entry = &networks[i];");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("if (ai_mnetwork_is_valid(name, entry))");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("return entry->name;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("else {");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("if (!idx--)");
                _builder.newLine();
                _builder.append("                ");
                _builder.append("return entry->name;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_error ai_mnetwork_create(const char *name, ai_handle* network,");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("const ai_buffer* network_config)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const ai_network_entry_t *entry;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const ai_network_entry_t *found = NULL;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_error err;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inst = ai_mnetwork_handle(NULL);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (!inst) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err.type = AI_ERROR_ALLOCATION_FAILED;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err.code = AI_ERROR_CODE_NETWORK;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return err;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("for (int i=0; i<AI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("entry = &networks[i];");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("if (ai_mnetwork_is_valid(name, entry)) {");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("found = entry;");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (!found) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err.type = AI_ERROR_INVALID_PARAM;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err.code = AI_ERROR_CODE_NETWORK;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return err;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (network_config == NULL)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err = found->ai_create(network, found->config);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("err = found->ai_create(network, network_config);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if ((err.code == AI_ERROR_CODE_NONE) && (err.type == AI_ERROR_NONE)) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("inst->entry = found;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("inst->handle = *network;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("*network = (ai_handle*)inst;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_handle ai_mnetwork_destroy(ai_handle network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("ai_handle hdl = inn->entry->ai_destroy(inn->handle);");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("if (hdl != inn->handle) {");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("ai_mnetwork_release_handle(inn);");
                _builder.newLine();
                _builder.append("            ");
                _builder.append("network = AI_HANDLE_NULL;");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return network;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_bool ai_mnetwork_get_report(ai_handle network, ai_network_report* report)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return inn->entry->ai_get_report(inn->handle, report);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_error ai_mnetwork_get_error(ai_handle network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_error err;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("err.type = AI_ERROR_INVALID_PARAM;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("err.code = AI_ERROR_CODE_NETWORK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return inn->entry->ai_get_error(inn->handle);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_bool ai_mnetwork_init(ai_handle network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("ai_network_params par;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("inn->entry->ai_data_params_get(&par);");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("for (int idx=0; idx < par.map_activations.size; idx++)");
                _builder.newLine();
                _builder.append("          ");
                _builder.append("AI_BUFFER_ARRAY_ITEM_SET_ADDRESS(&par.map_activations, idx, inn->entry->activations[idx]);");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return inn->entry->ai_init(inn->handle, &par);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_i32 ai_mnetwork_run(ai_handle network, const ai_buffer* input,");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("ai_buffer* output)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance* inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return inn->entry->ai_run(inn->handle, input, output);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_i32 ai_mnetwork_forward(ai_handle network, const ai_buffer* input)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return inn->entry->ai_forward(inn->handle, input);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("AI_API_ENTRY");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("int ai_mnetwork_get_private_handle(ai_handle network,");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("ai_handle *phandle,");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("ai_network_params *pparams)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("struct network_instance* inn;");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("inn =  ai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("if (inn && phandle && pparams) {");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("*phandle = inn->handle;");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("*pparams = inn->params;");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("return 0;");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("else");
                _builder.newLine();
                _builder.append("         ");
                _builder.append("return -1;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            } else {
                for (Network network_4 : networks) {
                    _builder.append("STAI_NETWORK_CONTEXT_DECLARE(_context_");
                    String _lowerCase_37 = network_4.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_37);
                    _builder.append(", STAI_");
                    String _upperCase_38 = network_4.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_38);
                    _builder.append("_CONTEXT_SIZE)");
                    _builder.newLineIfNotEmpty();
                    _builder.append("uintptr_t stai_");
                    String _lowerCase_38 = network_4.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_38);
                    _builder.append("_weights_addr[STAI_");
                    String _upperCase_39 = network_4.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_39);
                    _builder.append("_WEIGHTS_NUM];");
                    _builder.newLineIfNotEmpty();
                    _builder.append("extern const stai_network_details g_");
                    String _lowerCase_39 = network_4.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_39);
                    _builder.append("_details;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                _builder.append("static const stai_network_entry_t networks[STAI_MNETWORK_NUMBER] = {");
                _builder.newLine();
                for (Network network_5 : networks) {
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".name = (const char *)STAI_");
                    String _upperCase_40 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_40, "\t");
                    _builder.append("_MODEL_NAME,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_context_size = stai_");
                    String _lowerCase_40 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_40, "\t");
                    _builder.append("_get_context_size,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".init = stai_");
                    String _lowerCase_41 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_41, "\t");
                    _builder.append("_init,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".deinit = stai_");
                    String _lowerCase_42 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_42, "\t");
                    _builder.append("_deinit,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".run = stai_");
                    String _lowerCase_43 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_43, "\t");
                    _builder.append("_run,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_info = stai_");
                    String _lowerCase_44 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_44, "\t");
                    _builder.append("_get_info,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_error = stai_");
                    String _lowerCase_45 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_45, "\t");
                    _builder.append("_get_error,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".get_activations = stai_");
                    String _lowerCase_46 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_46, "\t");
                    _builder.append("_get_activations,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_states = stai_");
                    String _lowerCase_47 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_47, "\t");
                    _builder.append("_get_states,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_weights = stai_");
                    String _lowerCase_48 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_48, "\t");
                    _builder.append("_get_weights,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_inputs = stai_");
                    String _lowerCase_49 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_49, "\t");
                    _builder.append("_get_inputs,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".get_outputs = stai_");
                    String _lowerCase_50 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_50, "\t");
                    _builder.append("_get_outputs,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".set_activations = stai_");
                    String _lowerCase_51 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_51, "\t");
                    _builder.append("_set_activations,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".set_states = stai_");
                    String _lowerCase_52 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_52, "\t");
                    _builder.append("_set_states,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".set_weights = stai_");
                    String _lowerCase_53 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_53, "\t");
                    _builder.append("_set_weights,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".set_inputs = stai_");
                    String _lowerCase_54 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_54, "\t");
                    _builder.append("_set_inputs,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".set_outputs = stai_");
                    String _lowerCase_55 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_55, "\t");
                    _builder.append("_set_outputs,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".set_callback = stai_");
                    String _lowerCase_56 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_56, "\t");
                    _builder.append("_set_callback,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".context = _context_");
                    String _lowerCase_57 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_57, "\t");
                    _builder.append(",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".n_inputs = STAI_");
                    String _upperCase_41 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_41, "\t");
                    _builder.append("_IN_NUM,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".n_outputs = STAI_");
                    String _upperCase_42 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_42, "\t");
                    _builder.append("_OUT_NUM,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".n_activations = STAI_");
                    String _upperCase_43 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_43, "\t");
                    _builder.append("_ACTIVATIONS_NUM,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".n_states = STAI_");
                    String _upperCase_44 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_44, "\t");
                    _builder.append("_STATES_NUM,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".n_weights = STAI_");
                    String _upperCase_45 = network_5.getName().toUpperCase(Locale.ENGLISH);
                    _builder.append(_upperCase_45, "\t");
                    _builder.append("_WEIGHTS_NUM,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append(".weights_addr = stai_");
                    String _lowerCase_58 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_58, "\t");
                    _builder.append("_weights_addr,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append(".details = &g_");
                    String _lowerCase_59 = network_5.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase_59, "\t");
                    _builder.append("_details,");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("},");
                    _builder.newLine();
                }
                _builder.append("};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("struct network_instance {");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("const stai_network_entry_t *entry;");
                _builder.newLine();
                _builder.append("     ");
                _builder.append("ai_handle handle;");
                _builder.newLine();
                _builder.append("};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("/* Number of instance is aligned on the number of network */");
                _builder.newLine();
                _builder.append("static struct network_instance gnetworks[STAI_MNETWORK_NUMBER] = {0};");
                _builder.newLine();
                _builder.newLine();
                _builder.append("static ai_bool _stai_mnetwork_is_valid(const char* name,");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("const stai_network_entry_t *entry)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (name && (strlen(entry->name) == strlen(name)) &&");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("(strncmp(entry->name, name, strlen(entry->name)) == 0))");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return true;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("static struct network_instance *_stai_mnetwork_handle(struct network_instance *inst)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if ((inst) && (&gnetworks[i] == inst))");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("return inst;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else if ((!inst) && (gnetworks[i].entry == NULL))");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("return &gnetworks[i];");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("static void _stai_mnetwork_release_handle(struct network_instance *inst)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if ((inst) && (&gnetworks[i] == inst)) {");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("gnetworks[i].entry = NULL;");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("return;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("ai_handle stai_mnetwork_get_internal_handle(const ai_handle network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn =  _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (inn)");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("return inn->handle;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("const char* stai_mnetwork_find(const char *name, ai_int idx)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("const stai_network_entry_t *entry;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("entry = &networks[i];");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (_stai_mnetwork_is_valid(name, entry))");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("return entry->name;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("else {");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("if (!idx--)");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return entry->name;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_init(const char *name, stai_ptr* network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("const stai_network_entry_t *entry;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("const stai_network_entry_t *found = NULL;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inst = _stai_mnetwork_handle(NULL);");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (!inst || !network) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("*network = NULL;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("for (int i=0; i<STAI_MNETWORK_NUMBER; i++) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("entry = &networks[i];");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (_stai_mnetwork_is_valid(name, entry)) {");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("found = entry;");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (!found) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_err = found->init(found->context);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (stai_err == STAI_SUCCESS) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inst->entry = found;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inst->handle = found->context;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("found->get_weights(found->context, (stai_ptr *)found->weights_addr, &tmp_);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("*network = (stai_ptr)inst;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return STAI_SUCCESS;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_activations(stai_ptr network, const stai_ptr* activations)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn =  _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_activations(inn->handle, activations, inn->entry->n_activations);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_states(stai_ptr network, const stai_ptr* states)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn =  _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_states(inn->handle, states, inn->entry->n_states);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_weights(stai_ptr network, const stai_ptr* weights)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn =  _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_weights(inn->handle, weights, inn->entry->n_weights);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("inn->entry->get_weights(inn->handle, (stai_ptr *)inn->entry->weights_addr, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_inputs(stai_ptr network, const stai_ptr* inputs)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_inputs(inn->handle, inputs, inn->entry->n_inputs);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_outputs(stai_ptr network, const stai_ptr* outputs)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_outputs(inn->handle, outputs, inn->entry->n_outputs);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_set_callback(stai_ptr network, const stai_event_cb cb, void* cb_cookie)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->set_callback(inn->handle, cb, cb_cookie);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("const stai_network_details *stai_mnetwork_get_details(stai_ptr network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return inn->entry->details;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_activations(stai_ptr network, stai_ptr* activations)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->get_activations(inn->handle, activations, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_states(stai_ptr network, stai_ptr* states)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->get_states(inn->handle, states, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_weights(stai_ptr network, stai_ptr* weights)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->get_weights(inn->handle, weights, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_ptr *stai_mnetwork_get_weights_ext(stai_ptr network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return (stai_ptr *)inn->entry->weights_addr;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return NULL;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_inputs(stai_ptr network, stai_ptr* inputs)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->get_inputs(inn->handle, inputs, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_outputs(stai_ptr network, stai_ptr* outputs)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_size tmp_;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->get_outputs(inn->handle, outputs, &tmp_);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_deinit(stai_ptr network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("stai_err = inn->entry->deinit(inn->handle);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("if (stai_err == STAI_SUCCESS) {");
                _builder.newLine();
                _builder.append("      ");
                _builder.append("_stai_mnetwork_release_handle(inn);");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_info(stai_ptr network, stai_network_info* report)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return inn->entry->get_info(inn->handle, report);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_get_error(stai_ptr network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance *inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return inn->entry->get_error(inn->handle);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("STAI_API_ENTRY");
                _builder.newLine();
                _builder.append("stai_return_code stai_mnetwork_run(stai_ptr network)");
                _builder.newLine();
                _builder.append("{");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("struct network_instance* inn;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("stai_return_code stai_err = STAI_ERROR_NETWORK_INVALID_CONTEXT_HANDLE;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("  ");
                _builder.append("inn = _stai_mnetwork_handle((struct network_instance *)network);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("if (inn) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("return inn->entry->run(inn->handle, STAI_MODE_SYNC);");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("return stai_err;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("#ifdef __cplusplus");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
            _builder.newLine();
            _builder.newLine();
            _builder.append("/** @} */");
            _builder.newLine();
            _xifexpression = _xblockexpression = _builder.toString();
        }
        return _xifexpression;
    }

    public String getNetworkCustomLayerFile(String AbsoluteFilePath) {
        try {
            String line = null;
            int first_index = 0;
            int last_index = 0;
            FileReader _fileReader = new FileReader(AbsoluteFilePath);
            BufferedReader fileReader = new BufferedReader(_fileReader);
            while ((line = fileReader.readLine()) != null && !line.contains("c\":")) {
            }
            if (line != null) {
                first_index = line.indexOf("\"");
                line = line.substring(first_index + 1);
                first_index = line.indexOf("\"");
                line = line.substring(first_index + 1);
                first_index = line.indexOf("\"");
                last_index = line.length();
                line = line.substring(first_index + 1, last_index - 1);
            }
            fileReader.close();
            return line;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateMakefileAIcode(AIComponent component) {
        boolean _equals_15;
        boolean _equals_12;
        boolean _equals_10;
        boolean _equals_8;
        boolean _equals_1;
        boolean _equals;
        String _xblockexpression = null;
        Functions.Function1 _function = it -> it.isEnabled();
        Iterable networks = IterableExtensions.filter(component.getNetworks(), (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEnabled = component.getValidate().isEnabled();
        boolean bl = _equals = _isEnabled;
        if (_equals) {
            _builder.append("################################################################################");
            _builder.newLine();
            _builder.append("# Project makefile for AI validation.");
            _builder.newLine();
            _builder.append("################################################################################");
            _builder.newLine();
        } else {
            _builder.append("################################################################################");
            _builder.newLine();
            _builder.append("# Project makefile for custom AI application.");
            _builder.newLine();
            _builder.append("################################################################################");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("# AI auto-genereted folder");
        _builder.newLine();
        _builder.append("DIR_NAME := ");
        String _name = component.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("################################################################################");
        _builder.newLine();
        _builder.append("# Add project files");
        _builder.newLine();
        _builder.append("################################################################################");
        _builder.newLine();
        _builder.newLine();
        boolean _isEnabled_1 = component.getValidate().isEnabled();
        boolean bl2 = _equals_1 = _isEnabled_1;
        if (_equals_1) {
            StellarType _stellarMcu = component.getMcu().getStellarMcu();
            boolean _equals_2 = Objects.equals((Object)_stellarMcu, (Object)StellarType.SR5E1);
            if (_equals_2) {
                _builder.append("# C sources");
                _builder.newLine();
                _builder.append("C_SRCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/stellar/src/stellar_ai.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbIO.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbMemRWServices.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbMgr.c \\");
                _builder.newLine();
                ModeType _configuration = component.getApi().getConfiguration();
                boolean _equals_3 = Objects.equals((Object)_configuration, (Object)ModeType.LEGACY);
                if (_equals_3) {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/validation/src/aiValidation.c \\");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/validation/src/aiValidation_ST_AI.c \\");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_common.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_decode.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_encode.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/stellar_ai_validate.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/stm32msg.pb.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/ai_device_adaptor.c \\");
                _builder.newLine();
                ModeType _configuration_1 = component.getApi().getConfiguration();
                boolean _equals_4 = Objects.equals((Object)_configuration_1, (Object)ModeType.LEGACY);
                if (_equals_4) {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/misc/src/aiTestHelper.c \\");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/misc/src/aiTestHelper_ST_AI.c \\");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/aiTestUtility.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/syscalls.c");
                _builder.newLine();
            } else {
                _builder.append("# C sources");
                _builder.newLine();
                _builder.append("ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))");
                _builder.newLine();
                _builder.append("C_SRCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/stellar/src/stellar_ai.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbIO.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbMemRWServices.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/aiPbMgr.c \\");
                _builder.newLine();
                ModeType _configuration_2 = component.getApi().getConfiguration();
                boolean _equals_5 = Objects.equals((Object)_configuration_2, (Object)ModeType.LEGACY);
                if (_equals_5) {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/validation/src/aiValidation.c \\");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/validation/src/aiValidation_ST_AI.c \\");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_common.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_decode.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/pb_encode.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/stellar_ai_validate.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/src/stm32msg.pb.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/ai_device_adaptor.c \\");
                _builder.newLine();
                ModeType _configuration_3 = component.getApi().getConfiguration();
                boolean _equals_6 = Objects.equals((Object)_configuration_3, (Object)ModeType.LEGACY);
                if (_equals_6) {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/misc/src/aiTestHelper.c \\");
                    _builder.newLine();
                } else {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/lib/misc/src/aiTestHelper_ST_AI.c \\");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/aiTestUtility.c \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/src/syscalls.c");
                _builder.newLine();
                _builder.append("endif");
                _builder.newLine();
            }
        }
        _builder.newLine();
        for (Network network : networks) {
            ModeType _configuration_4;
            boolean _equals_7;
            _builder.append("C_SRCS += \\");
            _builder.newLine();
            boolean _isEnable = network.getCustomLayerSettings().isEnable();
            if (_isEnable) {
                _builder.append("\t");
                String customlayerfilename = this.getNetworkCustomLayerFile(network.getCustomLayerSettings().getCustomLayerJsonAbsoluteFile());
                _builder.newLineIfNotEmpty();
                if (customlayerfilename != null) {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/cfg/src/");
                    _builder.append(customlayerfilename, "\t");
                    _builder.append(" \\");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    _builder.append("$(DIR_NAME)/cfg/src/");
                    String _lowerCase = network.getName().toLowerCase(Locale.ENGLISH);
                    _builder.append(_lowerCase, "\t");
                    _builder.append("_custom_layers.c \\");
                    _builder.newLineIfNotEmpty();
                }
            }
            if (_equals_7 = Objects.equals((Object)(_configuration_4 = component.getApi().getConfiguration()), (Object)ModeType.LEGACY)) {
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/cfg/src/");
                String _lowerCase_1 = network.getName().toLowerCase(Locale.ENGLISH);
                _builder.append(_lowerCase_1, "\t");
                _builder.append("_data_params.c \\");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/cfg/src/");
            String _lowerCase_2 = network.getName().toLowerCase(Locale.ENGLISH);
            _builder.append(_lowerCase_2, "\t");
            _builder.append("_data.c \\");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/cfg/src/");
            String _lowerCase_3 = network.getName().toLowerCase(Locale.ENGLISH);
            _builder.append(_lowerCase_3, "\t");
            _builder.append(".c");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _isEnabled_2 = component.getValidate().isEnabled();
        boolean bl3 = _equals_8 = _isEnabled_2;
        if (_equals_8) {
            StellarType _stellarMcu_1 = component.getMcu().getStellarMcu();
            boolean _equals_9 = Objects.equals((Object)_stellarMcu_1, (Object)StellarType.SR5E1);
            if (_equals_9) {
                _builder.append("C_SRCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/cfg/app_stellar-studio-ai.c");
                _builder.newLine();
            } else {
                _builder.append("ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))");
                _builder.newLine();
                _builder.append("C_SRCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/cfg/app_stellar-studio-ai.c");
                _builder.newLine();
                _builder.append("endif");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("# C includes");
        _builder.newLine();
        _builder.append("C_INCS += \\");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$(DIR_NAME)/lib/ai/inc \\");
        _builder.newLine();
        boolean _isEnabled_3 = component.getValidate().isEnabled();
        boolean bl4 = _equals_10 = _isEnabled_3;
        if (_equals_10) {
            StellarType _stellarMcu_2 = component.getMcu().getStellarMcu();
            boolean _equals_11 = Objects.equals((Object)_stellarMcu_2, (Object)StellarType.SR5E1);
            if (_equals_11) {
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/stellar/inc \\");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph)) \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/stellar/inc \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("endif \\");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("$(DIR_NAME)/cfg/inc \\");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$(DIR_NAME)/cfg");
        _builder.newLine();
        _builder.newLine();
        boolean _isEnabled_4 = component.getValidate().isEnabled();
        boolean bl5 = _equals_12 = _isEnabled_4;
        if (_equals_12) {
            StellarType _stellarMcu_3 = component.getMcu().getStellarMcu();
            boolean _equals_13 = Objects.equals((Object)_stellarMcu_3, (Object)StellarType.SR5E1);
            if (_equals_13) {
                _builder.append("C_INCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/inc \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/inc");
                _builder.newLine();
            } else {
                _builder.append("ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))");
                _builder.newLine();
                _builder.append("C_INCS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/validation/inc \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("$(DIR_NAME)/lib/misc/inc");
                _builder.newLine();
                _builder.append("endif");
                _builder.newLine();
            }
        }
        _builder.newLine();
        StellarType _stellarMcu_4 = component.getMcu().getStellarMcu();
        boolean _equals_14 = Objects.equals((Object)_stellarMcu_4, (Object)StellarType.SR5E1);
        if (_equals_14) {
            _builder.append("# Library includes");
            _builder.newLine();
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarE/NetworkRuntime1020_CM7_GCC.a \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarE/NetworkRuntime1020_CM7_HT.a");
            _builder.newLine();
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarE/NetworkRuntime1020_CM7_ARMCLANG.a");
            _builder.newLine();
            _builder.append("else ifeq ($(TOOLCHAIN), IAR)");
            _builder.newLine();
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/IAR/StellarE/NetworkRuntime1020_CM7_IAR.a");
            _builder.newLine();
            _builder.append("endif");
            _builder.newLine();
        } else {
            _builder.append("# Library includes");
            _builder.newLine();
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))");
            _builder.newLine();
            _builder.append("# dme dsph cores on sr6 devices");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_M4/NetworkRuntime1020_CM4_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_M4/NetworkRuntime1020_CM4_HT.a");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_M4/NetworkRuntime1020_CM4_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("else ifneq (,$(filter $(CONFIG_DEVICE),sr6p7g7 sr6p7lp sr6p7 sr6g7))");
            _builder.newLine();
            _builder.append("# sr6p7g7 sr6p7lp sr6p7 sr6g7 cores");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0 cluster1))");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("else ifneq (,$(filter $(CONFIG_DEVICE),sr6g6))");
            _builder.newLine();
            _builder.append("# sr6g6 core");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("else ifneq (,$(filter $(CONFIG_DEVICE),sr6g3))");
            _builder.newLine();
            _builder.append("# sr6g3 core");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("ifneq (,$(filter $(CONFIG_TARGET_CORE),core0 core2))");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC_NEON.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG_NEON.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("else");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("else");
            _builder.newLine();
            _builder.append("# sr6p6 sr6p3");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("ifeq ($(TOOLCHAIN), ARM)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1020_CR52_GCC.a \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("-lm");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else ifeq ($(TOOLCHAIN), HIGHTEC)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1020_CR52_HT.a");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("else ifeq ($(TOOLCHAIN), ARMCLANG)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("LIBS += \\");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1020_CR52_ARMCLANG.a");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("endif");
            _builder.newLine();
            _builder.append("endif");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEnabled_5 = component.getValidate().isEnabled();
        boolean bl6 = _equals_15 = _isEnabled_5;
        if (_equals_15) {
            StellarType _stellarMcu_5 = component.getMcu().getStellarMcu();
            boolean _equals_16 = Objects.equals((Object)_stellarMcu_5, (Object)StellarType.SR5E1);
            if (_equals_16) {
                _builder.append("# C defines");
                _builder.newLine();
                _builder.append("C_DEFS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("SR5E1");
                _builder.newLine();
            } else {
                _builder.append("# C defines");
                _builder.newLine();
                _builder.append("ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))");
                _builder.newLine();
                _builder.append("C_DEFS += \\");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("SR6X");
                _builder.newLine();
                _builder.append("endif");
                _builder.newLine();
            }
        }
        _builder.newLine();
        for (Network network_1 : networks) {
            ModeType _configuration_5 = component.getApi().getConfiguration();
            boolean _equals_17 = Objects.equals((Object)_configuration_5, (Object)ModeType.STAI);
            if (!_equals_17) continue;
            _builder.append("# C defines");
            _builder.newLine();
            _builder.append("C_DEFS += \\");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("HAVE_");
            String _upperCase = network_1.getName().toUpperCase(Locale.ENGLISH);
            _builder.append(_upperCase, "\t");
            _builder.append("_INFO");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

