/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.commands.impl;

import com.st.stellar.ai.aiComponent.ValidationType;
import com.st.stellar.components.ai.commands.AINetParam;
import com.st.stellar.components.ai.commands.AIParam;
import com.st.stellar.components.ai.commands.AIValidateNetParam;
import com.st.stellar.components.ai.commands.impl.AICommandImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.UIJob;

public class ValidateNetworkRunnable
implements IRunnableWithProgress {
    Boolean _result = null;
    private String _taskName;
    private MessageConsoleStream _out;
    private MessageConsoleStream _err;
    protected PropertyChangeSupport _pcs = null;
    private String[] _aiCmd;
    private AINetParam _aiNetParam;
    public static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";

    public ValidateNetworkRunnable(String[] aiCmd, AINetParam aiNetParam, Boolean result, String taskName, MessageConsoleStream out, MessageConsoleStream err) {
        this._result = result;
        this._taskName = taskName;
        this._out = out;
        this._err = err;
        this._aiCmd = aiCmd;
        this._aiNetParam = aiNetParam;
        this._pcs = new PropertyChangeSupport(this);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this._taskName, -1);
        AIValidateNetParam aiValidateNetParam = (AIValidateNetParam)this._aiNetParam;
        if (this._aiCmd != null) {
            if (!aiValidateNetParam.com.equals("Auto")) {
                aiValidateComArgument = new String[]{"-d", "serial:" + aiValidateNetParam.com + ":115200"};
                this._aiCmd = AICommandImpl.concateneString(this._aiCmd, aiValidateComArgument);
            } else {
                aiValidateComArgument = new String[]{"-d", "serial:115200"};
                this._aiCmd = AICommandImpl.concateneString(this._aiCmd, aiValidateComArgument);
            }
            String base = AIParam.getInstance().getWorkingDir();
            if (aiValidateNetParam.dataType == ValidationType.INPUT_DATA || aiValidateNetParam.dataType == ValidationType.INPUT_OUTPUT_DATA) {
                if (aiValidateNetParam.customInputFile != null) {
                    if (aiValidateNetParam.customInputFile.endsWith(".npz") || aiValidateNetParam.customInputFile.endsWith(".csv")) {
                        String[] aiValidateInputArgument = new String[]{"-vi", base + File.separator + aiValidateNetParam.customInputFile};
                        this._aiCmd = AICommandImpl.concateneString(this._aiCmd, aiValidateInputArgument);
                    } else {
                        this._err.println("Wrong AI Validate Custom Input File type!!! Network validation stopped.");
                        this._result = false;
                    }
                } else {
                    this._err.println("AI Validate Custom Input File not found!!! Network validation stopped.");
                    this._result = false;
                }
                if (aiValidateNetParam.dataType == ValidationType.INPUT_OUTPUT_DATA) {
                    if (aiValidateNetParam.customOutputFile != null) {
                        if (aiValidateNetParam.customInputFile.endsWith(".npz") && aiValidateNetParam.customOutputFile.endsWith(".npz") || aiValidateNetParam.customInputFile.endsWith(".csv") && aiValidateNetParam.customOutputFile.endsWith(".csv")) {
                            String[] aiValidateOutputArgument = new String[]{"-vo", base + File.separator + aiValidateNetParam.customOutputFile};
                            this._aiCmd = AICommandImpl.concateneString(this._aiCmd, aiValidateOutputArgument);
                        } else {
                            this._err.println("Wrong AI Validate Custom Output File type!!! Network validation stopped.");
                            this._result = false;
                        }
                    } else {
                        this._err.println("AI Validate Custom Output File not found!!! Network validation stopped.");
                        this._result = false;
                    }
                }
            }
            if (this._result.booleanValue()) {
                CommandExecutionThread thread = new CommandExecutionThread(this._aiCmd);
                this.showConsoleView(100L);
                thread.start();
                while (!monitor.isCanceled() && thread.isAlive()) {
                }
                if (monitor.isCanceled()) {
                    thread.close();
                    this._result = false;
                }
            }
        } else {
            this._result = false;
        }
    }

    public Boolean getResult() {
        return this._result;
    }

    protected void showConsoleView() {
        this.showConsoleView(0L);
    }

    protected void showConsoleView(long delay) {
        new UIJob(this, "showConsole"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (ww != null) {
                    IWorkbenchPage page = ww.getActivePage();
                    IViewPart part = page.findView(ValidateNetworkRunnable.ID_CONSOLE_VIEW);
                    if (part == null) {
                        try {
                            page.showView(ValidateNetworkRunnable.ID_CONSOLE_VIEW);
                        }
                        catch (PartInitException partInitException) {}
                    } else {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule(delay);
    }

    public void addObserver(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener("text", listener);
    }

    private class CommandExecutionThread
    extends Thread {
        private volatile Boolean waiter;
        private String[] _aiCmd;

        public CommandExecutionThread(String[] aiCmd) {
            this._aiCmd = aiCmd;
            this.setName("ValidationThread");
        }

        @Override
        public synchronized void start() {
            this.waiter = Boolean.TRUE;
            super.start();
        }

        public void close() {
            this.waiter = Boolean.FALSE;
        }

        @Override
        public void run() {
            if (this._aiCmd != null) {
                for (String string : this._aiCmd) {
                    System.out.print(string + " ");
                }
                System.out.println("");
                ProcessBuilder probuilder = new ProcessBuilder(this._aiCmd);
                try {
                    String line;
                    ValidateNetworkRunnable.this.showConsoleView();
                    Process p = probuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = reader.readLine()) != null && this.waiter.booleanValue() && p.isAlive()) {
                        final String l = line;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ValidateNetworkRunnable.this._out.println(l);
                                ValidateNetworkRunnable.this._pcs.firePropertyChange("text", null, l);
                            }
                        });
                    }
                    reader.close();
                    while (this.waiter.booleanValue() && p.isAlive()) {
                        p.wait(100L);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                AICommandImpl.updateExplorer();
                System.out.println("Done");
            }
        }
    }
}

