/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.commands.impl;

import com.st.stellar.components.ai.commands.AINetParam;
import com.st.stellar.components.ai.commands.AIParam;
import com.st.stellar.components.ai.commands.impl.AICommandImpl;
import com.st.stellar.components.ai.commands.impl.ValidateNetworkRunnable;
import com.st.stellar.components.ai.commands.impl.ValidateProgressDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.WorkbenchJob;

public class ValidateNetwork
extends AICommandImpl {
    Boolean result;

    public ValidateNetwork(AIParam aiParam) {
        super(aiParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AINetParam aiNetParam) {
        try {
            this.result = true;
            String[] aiCmd = this.processAICommand("validate", aiNetParam);
            ValidateNetworkRunnable runnable = new ValidateNetworkRunnable(aiCmd, aiNetParam, this.result, "Validate the generated C-files for the '" + aiNetParam.name + "' network...", out, err);
            ValidateProgressDialog dialog = new ValidateProgressDialog(ProgressManagerUtil.getDefaultParent());
            runnable.addObserver(dialog);
            dialog.setOpenOnRun(false);
            InvocationTargetException[] invokes = new InvocationTargetException[1];
            InterruptedException[] interrupt = new InterruptedException[1];
            Runnable dialogWaitRunnable = () -> {
                try {
                    dialog.setOpenOnRun(false);
                    dialog.run(true, true, runnable);
                    this.result = dialog.getReturnCode() == 0;
                }
                catch (InvocationTargetException e1) {
                    invokes[0] = e1;
                }
                catch (InterruptedException e2) {
                    interrupt[0] = e2;
                }
            };
            this.busyCursorWhile(dialogWaitRunnable, dialog);
            if (invokes[0] != null) {
                throw invokes[0];
            }
            if (interrupt[0] != null) {
                throw interrupt[0];
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.result;
    }

    private void busyCursorWhile(Runnable dialogWaitRunnable, ProgressMonitorJobsDialog dialog) {
        this.scheduleProgressMonitorJob(dialog);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)dialogWaitRunnable);
    }

    private void scheduleProgressMonitorJob(final ProgressMonitorJobsDialog dialog) {
        WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.ProgressManager_openJobName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ValidateNetwork.this.setUserInterfaceActive(true);
                if (ProgressManagerUtil.safeToOpen((ProgressMonitorJobsDialog)dialog, null)) {
                    dialog.open();
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule((long)this.getLongOperationTime());
    }

    public int getLongOperationTime() {
        return 800;
    }

    private void setUserInterfaceActive(boolean active) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        if (active) {
            for (Shell shell : shells) {
                if (shell.isDisposed()) continue;
                shell.setEnabled(active);
            }
        } else {
            for (int i = shells.length - 1; i >= 0; --i) {
                if (shells[i].isDisposed()) continue;
                shells[i].setEnabled(active);
            }
        }
    }
}

