/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.commands.impl;

import com.st.stellar.ai.aiComponent.ModeType;
import com.st.stellar.ai.aiComponent.NetworkType;
import com.st.stellar.ai.aiComponent.StellarType;
import com.st.stellar.ai.utils.Utils;
import com.st.stellar.components.ai.commands.AICommand;
import com.st.stellar.components.ai.commands.AINetParam;
import com.st.stellar.components.ai.commands.AIParam;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.UIJob;

public abstract class AICommandImpl
implements AICommand {
    protected static MessageConsoleStream msg;
    protected static MessageConsoleStream out;
    protected static MessageConsoleStream err;
    protected static MessageConsoleStream warn;
    private AIParam _AIParam = null;
    public static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";

    public AICommandImpl(AIParam aiParam) {
        this._AIParam = aiParam;
        final MessageConsole console = Utils.findConsole("AI Console");
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Utils.activateConsole(console);
                msg = console.newMessageStream();
                msg.setColor(Utils.DEFAULT_MESSAGE);
                out = console.newMessageStream();
                out.setColor(Utils.DEFAULT_OUTPUT);
                err = console.newMessageStream();
                err.setColor(Utils.DEFAULT_ERROR);
                warn = console.newMessageStream();
                warn.setColor(Utils.DEFAULT_WARNING);
            }
        });
    }

    protected void showConsoleView() {
        this.showConsoleView(0L);
    }

    protected void showConsoleView(long delay) {
        new UIJob(this, "showConsole"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (ww != null) {
                    IWorkbenchPage page = ww.getActivePage();
                    IViewPart part = page.findView(AICommandImpl.ID_CONSOLE_VIEW);
                    if (part == null) {
                        try {
                            page.showView(AICommandImpl.ID_CONSOLE_VIEW);
                        }
                        catch (PartInitException partInitException) {}
                    } else {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule(delay);
    }

    public boolean swapEndianess(String sourceFile, String destinationFile) {
        try {
            String line;
            ArrayList<Integer> ints = new ArrayList<Integer>();
            File networdDataFile = new File(sourceFile);
            if (!networdDataFile.exists()) {
                return false;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(sourceFile));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destinationFile));
            boolean linesBeforeArray = false;
            while ((line = bufferedReader.readLine()) != null && !line.contains("0x")) {
                linesBeforeArray = true;
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            if (!linesBeforeArray) {
                bufferedReader.close();
                bufferedWriter.close();
                return false;
            }
            if (line.contains("0x")) {
                do {
                    line = line.replaceAll("\\s+", "");
                    String[] lineSplit = line.split(",");
                    for (int i = 0; i < lineSplit.length; ++i) {
                        ints.add(Integer.parseInt(lineSplit[i].replace("0x", ""), 16));
                    }
                } while ((line = bufferedReader.readLine()) != null && line.contains("0x"));
                if (ints.size() % 4 != 0) {
                    bufferedReader.close();
                    bufferedWriter.close();
                    return false;
                }
                for (int i = 0; i < ints.size(); i += 4) {
                    String byte0 = Integer.toHexString((Integer)ints.get(i + 3)).length() == 1 ? "0x0" + Integer.toHexString((Integer)ints.get(i + 3)) : "0x" + Integer.toHexString((Integer)ints.get(i + 3));
                    String byte1 = Integer.toHexString((Integer)ints.get(i + 2)).length() == 1 ? "0x0" + Integer.toHexString((Integer)ints.get(i + 2)) : "0x" + Integer.toHexString((Integer)ints.get(i + 2));
                    String byte2 = Integer.toHexString((Integer)ints.get(i + 1)).length() == 1 ? "0x0" + Integer.toHexString((Integer)ints.get(i + 1)) : "0x" + Integer.toHexString((Integer)ints.get(i + 1));
                    String byte3 = Integer.toHexString((Integer)ints.get(i)).length() == 1 ? "0x0" + Integer.toHexString((Integer)ints.get(i)) : "0x" + Integer.toHexString((Integer)ints.get(i));
                    bufferedWriter.write("    " + byte0 + ", " + byte1 + ", " + byte2 + ", " + byte3 + ",");
                    bufferedWriter.newLine();
                }
            } else {
                bufferedReader.close();
                bufferedWriter.close();
                return false;
            }
            if (!line.contains("0x")) {
                do {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                } while ((line = bufferedReader.readLine()) != null);
            } else {
                bufferedReader.close();
                bufferedWriter.close();
                return false;
            }
            bufferedReader.close();
            bufferedWriter.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void updateExplorer() {
        IProject project;
        if (AIParam.getInstance().getAppModel() != null && (project = AIParam.getInstance().getProject()) != null) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected String[] processAICommand(String command, AINetParam aiParam) {
        String[] aiCmd;
        if (command.equals("version")) {
            aiCmd = new String[]{this._AIParam.getAITool(), "--tools-version"};
        } else {
            File modelFilesFolder;
            aiCmd = new String[]{this._AIParam.getAITool(), command};
            String workingDir = this._AIParam.getWorkingDir();
            if (aiParam.modelPath == null || aiParam.modelPath.isEmpty()) {
                err.println(aiParam.name + ": AI Model Files Path not specified!!! Network processing stopped.");
                return null;
            }
            if (this._AIParam.getAppModel().getMcu().getStellarMcu() == StellarType.SR5E1) {
                aTargetArgument = new String[]{"--target", "stellar-e"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aTargetArgument);
            } else {
                aTargetArgument = new String[]{"--target", "stellar-pg"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aTargetArgument);
            }
            if (this._AIParam.getAppModel().getApi().getConfiguration() == ModeType.STAI) {
                String[] aiStApiArgument = new String[]{"--c-api", "st-ai"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiStApiArgument);
            }
            if ((modelFilesFolder = new File(workingDir + File.separator + aiParam.modelPath)).exists()) {
                int i;
                File[] listOfModelFiles = modelFilesFolder.listFiles();
                int numOfModelFiles = 0;
                for (i = 0; i < listOfModelFiles.length && listOfModelFiles[i].isFile(); ++i) {
                    ++numOfModelFiles;
                }
                if (numOfModelFiles == 0) {
                    err.println(aiParam.name + ": AI Model Files not found!!! Network processing stopped.");
                    return null;
                }
                switch (aiParam.type) {
                    case KERAS: {
                        if (numOfModelFiles == 1) {
                            if (listOfModelFiles[0].getName().endsWith(".h5") || listOfModelFiles[0].getName().endsWith(".hdf5") || listOfModelFiles[0].getName().endsWith(".keras")) break;
                            err.println(aiParam.name + ": Wrong AI Model File extension!!! Network processing stopped.");
                            return null;
                        }
                        if (numOfModelFiles == 2) {
                            if ((listOfModelFiles[0].getName().endsWith(".h5") || listOfModelFiles[0].getName().endsWith(".hdf5")) && listOfModelFiles[1].getName().endsWith(".json") || (listOfModelFiles[1].getName().endsWith(".h5") || listOfModelFiles[1].getName().endsWith(".hdf5")) && listOfModelFiles[0].getName().endsWith(".json")) break;
                            err.println(aiParam.name + ": Wrong AI Model File extension!!! Network processing stopped.");
                            return null;
                        }
                        err.println(aiParam.name + ": Too many AI Model Files!!! Network processing stopped.");
                        return null;
                    }
                    case TF_LITE: {
                        if (numOfModelFiles == 1) {
                            if (listOfModelFiles[0].getName().endsWith(".tflite")) break;
                            err.println(aiParam.name + ": Wrong AI Model File extension!!! Network processing stopped.");
                            return null;
                        }
                        err.println(aiParam.name + ": Too many AI Model Files!!! Network processing stopped.");
                        return null;
                    }
                    case ONNX: {
                        if (numOfModelFiles == 1) {
                            if (listOfModelFiles[0].getName().endsWith(".onnx")) break;
                            err.println(aiParam.name + ": Wrong AI Model File extension!!! Network processing stopped.");
                            return null;
                        }
                        err.println(aiParam.name + ": Too many AI Model Files!!! Network processing stopped.");
                        return null;
                    }
                    default: {
                        err.println(aiParam.name + ": AI Network Type not supported!!! Network processing stopped.");
                        return null;
                    }
                }
                for (i = 0; i < numOfModelFiles; ++i) {
                    String[] aiModelFilesArgument = new String[]{"-m", workingDir + File.separator + aiParam.modelPath + File.separator + listOfModelFiles[i].getName()};
                    aiCmd = AICommandImpl.concateneString(aiCmd, aiModelFilesArgument);
                }
            } else {
                err.println(aiParam.name + ": AI Model Files not found!!! Network processing stopped.");
                return null;
            }
            String[] aiNetworkNameArgument = new String[]{"--name", aiParam.name};
            aiCmd = AICommandImpl.concateneString(aiCmd, aiNetworkNameArgument);
            String[] aiTypeArgument = new String[]{"--type", aiParam.type.getLiteral()};
            aiCmd = AICommandImpl.concateneString(aiCmd, aiTypeArgument);
            String[] aiCompressionArgument = new String[]{"--compression", aiParam.compression.getLiteral()};
            aiCmd = AICommandImpl.concateneString(aiCmd, aiCompressionArgument);
            if (aiParam.optimization.getLiteral() != "balanced") {
                String[] aiOptimizationArgument = new String[]{"--optimization", aiParam.optimization.getLiteral()};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiOptimizationArgument);
            }
            String folderName = AIParam.getInstance().getAppModel().getName();
            String[] aiWorkSpaceArgument = new String[]{"--workspace", workingDir + File.separator + folderName + File.separator + "ws" + File.separator};
            aiCmd = AICommandImpl.concateneString(aiCmd, aiWorkSpaceArgument);
            String[] aiOutputArgument = new String[]{"--output", workingDir + File.separator + folderName + File.separator + "cfg" + File.separator};
            aiCmd = AICommandImpl.concateneString(aiCmd, aiOutputArgument);
            if (command.equals("validate")) {
                String[] aiModeArgument = new String[]{"--mode", "target"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiModeArgument);
            }
            if (!aiParam.alloc_in) {
                String[] aiAllocateInputsArgument = new String[]{"--no-inputs-allocation"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiAllocateInputsArgument);
            }
            if (!aiParam.alloc_out) {
                String[] aiAllocateOutputsArgument = new String[]{"--no-outputs-allocation"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiAllocateOutputsArgument);
            }
            if ((command.equals("generate") || command.equals("validate")) && aiParam.split_weights) {
                String[] aiSplitWeightsArgument = new String[]{"--split-weights"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiSplitWeightsArgument);
            }
            if (aiParam.alloc_act && this._AIParam.getAppModel().getApi().getConfiguration() == ModeType.STAI) {
                String[] aiAllocateActivationsArgument = new String[]{"--allocate-activations"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiAllocateActivationsArgument);
            }
            if (aiParam.alloc_states && this._AIParam.getAppModel().getApi().getConfiguration() == ModeType.STAI) {
                String[] aiAllocateStatesArgument = new String[]{"--allocate-states"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiAllocateStatesArgument);
            }
            if (aiParam.customlayer_enable && aiParam.type == NetworkType.KERAS) {
                String[] aiCustomLayerArgument = new String[]{"--custom", workingDir + File.separator + aiParam.customlayer_file};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiCustomLayerArgument);
            }
            if (command.equals("validate") && aiParam.classifier) {
                String[] aiClassifierArgument = new String[]{"--classifier"};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiClassifierArgument);
            }
            if (aiParam.extra_options != null && !aiParam.extra_options.isEmpty()) {
                String[] aiExtraOptionsArgument = new String[]{aiParam.extra_options};
                aiCmd = AICommandImpl.concateneString(aiCmd, aiExtraOptionsArgument);
            }
        }
        return aiCmd;
    }

    public static String[] concateneString(String[] first, String[] second) {
        int length = first.length + second.length;
        String[] result = new String[length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

