/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.Bundle;

public class Utils {
    private static Logger logger = LogManager.getLogger(Utils.class);
    public static final String CONSOLE_NAME = "AI Console";
    public static final Color DEFAULT_MESSAGE = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
    public static final Color DEFAULT_OUTPUT = new Color((Device)Display.getDefault(), new RGB(0, 0, 0));
    public static final Color DEFAULT_WARNING = new Color((Device)Display.getDefault(), new RGB(255, 100, 0));
    public static final Color DEFAULT_ERROR = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
    public static final Color DEFAULT_PATCH = new Color((Device)Display.getDefault(), new RGB(0, 100, 0));
    public static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";
    public static String REGEX_SYMBOL_NAME = "[a-zA-Z0-9_]+";

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        for (int i = 0; i < existing.length; ++i) {
            if (!name.equals(existing[i].getName())) continue;
            return (MessageConsole)existing[i];
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public static void activateConsole(MessageConsole console) {
        IWorkbenchPage page = null;
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                page = window.getActivePage();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        try {
            IConsoleView view;
            if (page != null && (view = (IConsoleView)page.showView(ID_CONSOLE_VIEW, null, 2)) != null) {
                view.display((IConsole)console);
            }
        }
        catch (PartInitException e) {
            System.err.println(e.getMessage());
        }
    }

    public static IProject getProject(EObject model) {
        IProject project = null;
        URI uri = model.eResource().getURI();
        if (!uri.isFile()) {
            project = null;
        }
        String projectName = ((String)uri.segmentsList().get(1)).toString();
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project;
    }

    public static String normalizeSlashes(String source) {
        return source != null ? source.replace("\\", "/") : null;
    }

    public static String getPath(String pluginId, String relativeResourcePath) {
        Bundle b = Platform.getBundle((String)pluginId);
        String path = new String("");
        if (b != null) {
            try {
                URL url = b.getEntry(relativeResourcePath);
                Path libpath = new Path(FileLocator.toFileURL((URL)url).getPath());
                path = URLDecoder.decode(libpath.toOSString(), "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path;
    }

    public static void showConsoleView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (ww != null) {
                    IWorkbenchPage page = ww.getActivePage();
                    IViewPart part = page.findView(Utils.ID_CONSOLE_VIEW);
                    if (part == null) {
                        try {
                            page.showView(Utils.ID_CONSOLE_VIEW);
                        }
                        catch (PartInitException partInitException) {}
                    } else {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
            }
        });
    }

    public static void updateExplorer(EObject model) {
        IProject project = Utils.getProject(model);
        if (project != null) {
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static String sanitize(Object object) {
        String dest = new String();
        if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < string.length(); ++i) {
                String c = string.substring(i, i + 1);
                dest = Pattern.matches(REGEX_SYMBOL_NAME, c) ? dest.concat(c) : dest.concat("_");
            }
        }
        return dest.toLowerCase(Locale.ENGLISH);
    }

    public static void setReadonly(IFolder folder) {
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    ResourceAttributes attrs = resource.getResourceAttributes();
                    attrs.setReadOnly(true);
                    resource.setResourceAttributes(attrs);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void copydir(File srcPath, IContainer destFolder) throws IOException, CoreException {
        File[] files = srcPath.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IFolder newFolder = destFolder.getFolder((IPath)new Path(f.getName()));
                    if (!newFolder.exists()) {
                        newFolder.create(true, true, null);
                        Utils.setReadonly(newFolder);
                    }
                    Utils.copydir(f, (IContainer)newFolder);
                    continue;
                }
                IFile newFile = destFolder.getFile((IPath)new Path(f.getName()));
                if (FileUtils.contentEquals((File)f, (File)newFile.getLocation().toFile())) continue;
                if (newFile.exists()) {
                    newFile.delete(true, null);
                }
                newFile.create((InputStream)new FileInputStream(f), true, null);
            }
        }
    }
}

