/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent.impl;

import com.st.stellar.ai.aiComponent.AIComponent;
import com.st.stellar.ai.aiComponent.AIPackage;
import com.st.stellar.ai.aiComponent.CompressionType;
import com.st.stellar.ai.aiComponent.Network;
import com.st.stellar.ai.aiComponent.NetworkType;
import com.st.stellar.ai.aiComponent.OptimizationType;
import com.st.stellar.ai.aiComponent.StellarType;
import com.st.stellar.ai.aiComponent.Validate;
import com.st.stellar.ai.aiComponent.ValidationType;
import com.st.stellar.ai.aiComponent.impl.AIComponentImpl;
import com.st.stellar.ai.aiComponent.impl.MValidateImpl;
import com.st.stellar.ai.utils.AIComponentHelper;
import com.st.stellar.ai.utils.Utils;
import com.st.stellar.component.model.DerivedAttributeService;
import com.st.stellar.components.ai.commands.AIParam;
import com.st.stellar.components.ai.commands.AIValidateNetParam;
import com.st.stellar.components.ai.commands.impl.ValidateNetwork;
import gnu.io.CommPortIdentifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ValidateImpl
extends MValidateImpl
implements Validate {
    private static Logger logger = LogManager.getLogger(ValidateImpl.class);
    private static MessageConsoleStream msg;
    private static MessageConsoleStream out;
    private static MessageConsoleStream err;
    private static MessageConsoleStream warn;
    private String aiValidateFilePathParam;
    private AIComponentHelper helper = AIComponentHelper.instance;
    private List<String> listCOM = null;

    public ValidateImpl() {
        MessageConsole console = Utils.findConsole("AI Console");
        console.clearConsole();
        Runnable _function = () -> {
            Utils.activateConsole(console);
            msg = console.newMessageStream();
            msg.setColor(Utils.DEFAULT_MESSAGE);
            out = console.newMessageStream();
            out.setColor(Utils.DEFAULT_OUTPUT);
            err = console.newMessageStream();
            err.setColor(Utils.DEFAULT_ERROR);
            warn = console.newMessageStream();
            warn.setColor(Utils.DEFAULT_WARNING);
        };
        Display.getDefault().syncExec(_function);
        EAttribute _validate_BrowseInput = AIPackage.eINSTANCE.getValidate_BrowseInput();
        DerivedAttributeService.INSTANCE.addDependencyListener((EObject)this, AIPackage.eINSTANCE.getValidate_InputPath(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_validate_BrowseInput})));
        EAttribute _validate_BrowseOutput = AIPackage.eINSTANCE.getValidate_BrowseOutput();
        DerivedAttributeService.INSTANCE.addDependencyListener((EObject)this, AIPackage.eINSTANCE.getValidate_OutputPath(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_validate_BrowseOutput})));
    }

    @Override
    public void validate() {
        boolean outputOk;
        boolean inputOk;
        boolean networkOk;
        EObject _eContainer = this.eContainer();
        AIComponentImpl model = (AIComponentImpl)_eContainer;
        model.getOut().println("AI network validate processing...");
        System.out.println("AI network validate processing...");
        AIParam.getInstance().setAppModel(model);
        Utils.showConsoleView();
        MessageConsole console = Utils.findConsole("AI Console");
        console.clearConsole();
        String aiValidateComParam = this.getComPort();
        ValidationType aiValidateDataTypeParam = this.getValidationType();
        String aiValidateCustomOutputFileParam = this.getOutputPath();
        String aiValidateCustomInputFileParam = this.getInputPath();
        boolean bl = networkOk = this.networkToValidate != null && !this.networkToValidate.isEmpty();
        if (!networkOk) {
            err.println("No network to validate selected!!!");
            logger.error((Object)"No network to validate selected!!!");
            return;
        }
        boolean bl2 = inputOk = this.inputPath != null && !this.inputPath.isEmpty();
        if (!inputOk && !Objects.equals((Object)this.validationType, (Object)ValidationType.RANDOM)) {
            err.println("No validation inputPath selected!!!");
            logger.error((Object)"No validation inputPath selected!!!");
            return;
        }
        boolean bl3 = outputOk = this.outputPath != null && !this.outputPath.isEmpty();
        if (!outputOk && Objects.equals((Object)this.validationType, (Object)ValidationType.INPUT_OUTPUT_DATA)) {
            err.println("No validation outputPath selected!!!");
            logger.error((Object)"No validation outputPath selected!!!");
            return;
        }
        Functions.Function1 _function = it -> it.getName().equals(this.networkToValidate);
        Network network = (Network)IterableExtensions.findFirst((Iterable)model.networks, (Functions.Function1)_function);
        if (network != null) {
            boolean aiIsNetworkEnableParam = network.isEnabled();
            if (aiIsNetworkEnableParam) {
                boolean _not;
                NetworkType aiTypeParam = network.getType();
                CompressionType aiCompressionParam = network.getCompression();
                OptimizationType aiOptimizationParam = network.getOptimization();
                String aiModelFilePathParam = network.getFilePath();
                boolean aiIsAllocInEnableParam = network.getAdvancedSettings().isAllocateInputs();
                boolean aiIsAllocOutEnableParam = network.getAdvancedSettings().isAllocateOutputs();
                boolean aiIsSplitWeightsEnableParam = network.getAdvancedSettings().isSplitWeights();
                boolean aiIsAllocActivationsEnableParam = network.getAdvancedSettings().isAllocateActivations();
                boolean aiIsAllocStatesEnableParam = network.getAdvancedSettings().isAllocateStates();
                boolean aiIsClassifierEnableParam = network.getAdvancedSettings().isClassifier();
                String aiExtraCommandLineOptions = network.getAdvancedSettings().getExtraCommandLineOptions();
                boolean aiIsCustomLayerEnableParam = network.getCustomLayerSettings().isEnable();
                String aiCustomLayerFilePathParam = network.getCustomLayerSettings().getCustomLayerJsonFile();
                AIValidateNetParam aiNetParam = new AIValidateNetParam(this.networkToValidate, aiTypeParam, aiCompressionParam, aiOptimizationParam, aiModelFilePathParam, aiIsAllocInEnableParam, aiIsAllocOutEnableParam, aiIsSplitWeightsEnableParam, aiIsAllocActivationsEnableParam, aiIsAllocStatesEnableParam, aiIsClassifierEnableParam, aiExtraCommandLineOptions, aiIsCustomLayerEnableParam, aiCustomLayerFilePathParam, aiValidateComParam, aiValidateDataTypeParam, aiValidateCustomInputFileParam, aiValidateCustomOutputFileParam);
                AIParam _instance = AIParam.getInstance();
                ValidateNetwork cmd = new ValidateNetwork(_instance);
                boolean _execute = cmd.execute(aiNetParam);
                boolean bl4 = _not = !_execute;
                if (_not) {
                    logger.error((Object)"AI network validation failed");
                }
            }
        } else {
            err.println("Network to validate not found!!!");
            logger.error((Object)"Network to validate not found!!!");
        }
        Utils.showConsoleView();
    }

    @Override
    public String getDescription() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("In order to run the Validate on Target:");
        _builder.newLine();
        _builder.newLine();
        _builder.append("1. Enable the validation view selecting the Enabled flag");
        _builder.newLine();
        _builder.append("2. Select from the \"Validate settings\" tab:");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("2.1 the Network To Validate");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("2.2 the Validate Serial");
        _builder.newLine();
        _builder.append("3. Generate the Validate Project code using the Generate button from the \"Actions\" panel");
        _builder.newLine();
        _builder.append("4. Compile the Validate Project");
        _builder.newLine();
        _builder.append("5. Upload and run it on the target");
        _builder.newLine();
        _builder.append("6. Select from the \"Validate parameters\" tab:");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("6.1 the Validate Type (Random or Custom Input Data or Custom Input/Output Data) ");
        _builder.newLine();
        _builder.append("   ");
        _builder.append("6.2 the Com Port");
        _builder.newLine();
        _builder.append("7. Press the Validate button");
        _builder.newLine();
        _builder.append("For the selected network a report will be displayed in the console and will be stored in a dedicated file inside the project folder:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("...\\");
        String _name = ((AIComponent)this.eContainer).getName();
        _builder.append(_name, " ");
        _builder.append("\\cfg\\");
        return _builder.toString();
    }

    @Override
    public void browseInputPath() {
        EObject _eContainer = this.eContainer();
        AIComponentImpl model = (AIComponentImpl)_eContainer;
        AIParam.getInstance().setAppModel(model);
        Runnable _function = () -> {
            Shell _activeShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(_activeShell);
            dlg.setFilterPath("");
            if (this.aiValidateFilePathParam == null) {
                AIParam.getInstance().setAppModel(model);
                String _workingDir = AIParam.getInstance().getWorkingDir();
                String _plus = _workingDir + "/source/";
                dlg.setFilterPath(_plus);
            } else {
                dlg.setFilterPath(this.aiValidateFilePathParam);
            }
            dlg.setText("DirectoryDialog");
            dlg.setText("Select an input file");
            String dir = dlg.open();
            if (dir != null) {
                Path location = new Path(dir);
                IPath base = Utils.getProject((EObject)model).getLocation();
                location = location.makeRelativeTo(base);
                this.helper.setAttributeValue(this, AIPackage.eINSTANCE.getValidate_InputPath(), location.toString());
            }
        };
        Display.getDefault().syncExec(_function);
    }

    @Override
    public void browseOutputPath() {
        EObject _eContainer = this.eContainer();
        AIComponentImpl model = (AIComponentImpl)_eContainer;
        AIParam.getInstance().setAppModel(model);
        Runnable _function = () -> {
            Shell _activeShell = Display.getDefault().getActiveShell();
            FileDialog dlg = new FileDialog(_activeShell);
            dlg.setFilterPath("");
            if (this.aiValidateFilePathParam == null) {
                AIParam.getInstance().setAppModel(model);
                String _workingDir = AIParam.getInstance().getWorkingDir();
                String _plus = _workingDir + "/source/";
                dlg.setFilterPath(_plus);
            } else {
                dlg.setFilterPath(this.aiValidateFilePathParam);
            }
            dlg.setText("DirectoryDialog");
            dlg.setText("Select an input/output file");
            String dir = dlg.open();
            if (dir != null) {
                Path location = new Path(dir);
                IPath base = Utils.getProject((EObject)model).getLocation();
                location = location.makeRelativeTo(base);
                this.helper.setAttributeValue(this, AIPackage.eINSTANCE.getValidate_OutputPath(), location.toString());
            }
        };
        Display.getDefault().syncExec(_function);
    }

    @Override
    public String availableNetworks() {
        String _xblockexpression = null;
        String listToString = "";
        EObject _eContainer = this.eContainer();
        AIComponentImpl model = (AIComponentImpl)_eContainer;
        EList networks = model.networks;
        Functions.Function1 _function = it -> it.isEnabled();
        Iterable _filter = IterableExtensions.filter((Iterable)networks, (Functions.Function1)_function);
        for (Network network : _filter) {
            listToString = listToString.concat(",").concat(network.getName());
        }
        _xblockexpression = listToString;
        return _xblockexpression;
    }

    private void refreshCOMList() {
        if (this.listCOM == null || this.listCOM.isEmpty()) {
            Runnable _function = () -> {
                System.out.print("Initializing COM port list...");
                ValidateImpl validateImpl = this;
                synchronized (validateImpl) {
                    this.listCOM = CollectionLiterals.newArrayList();
                    Enumeration ports = CommPortIdentifier.getPortIdentifiers();
                    while (ports.hasMoreElements()) {
                        Object _nextElement = ports.nextElement();
                        CommPortIdentifier com = (CommPortIdentifier)_nextElement;
                        int _portType = com.getPortType();
                        boolean _tripleEquals = _portType == 1;
                        if (!_tripleEquals) continue;
                        this.listCOM.add(com.getName());
                    }
                }
                System.out.println("Done");
            };
            Display.getDefault().asyncExec(_function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String availableCOMPorts() {
        String _xblockexpression = null;
        String listToString = "Auto";
        ValidateImpl validateImpl = this;
        synchronized (validateImpl) {
            for (String com : this.listCOM) {
                listToString = listToString.concat(",").concat(com);
            }
        }
        _xblockexpression = listToString;
        return _xblockexpression;
    }

    @Override
    public String getErrorMessage() {
        String _xifexpression = null;
        Functions.Function1 _function = it -> it.isEnabled();
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(((AIComponent)this.eContainer).getNetworks(), (Functions.Function1)_function));
        boolean _equals = _size == 0;
        _xifexpression = _equals ? "Cannot edit as no network is available" : super.getErrorMessage();
        return _xifexpression;
    }

    @Override
    public String availableSerialValues() {
        String _xifexpression = null;
        StellarType _stellarMcu = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
        boolean _equals = Objects.equals((Object)_stellarMcu, (Object)StellarType.SR5E1);
        if (_equals) {
            _xifexpression = "SR5E1_UART1,SR5E1_UART2,SR5E1_UART3";
        } else {
            String _xifexpression_1 = null;
            StellarType _stellarMcu_1 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
            boolean _equals_1 = Objects.equals((Object)_stellarMcu_1, (Object)StellarType.SR6P3);
            if (_equals_1) {
                _xifexpression_1 = "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15";
            } else {
                String _xifexpression_2 = null;
                StellarType _stellarMcu_2 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
                boolean _equals_2 = Objects.equals((Object)_stellarMcu_2, (Object)StellarType.SR6P6);
                if (_equals_2) {
                    _xifexpression_2 = "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10";
                } else {
                    String _xifexpression_3 = null;
                    StellarType _stellarMcu_3 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
                    boolean _equals_3 = Objects.equals((Object)_stellarMcu_3, (Object)StellarType.SR6P7);
                    if (_equals_3) {
                        _xifexpression_3 = "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10";
                    } else {
                        String _xifexpression_4 = null;
                        StellarType _stellarMcu_4 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
                        boolean _equals_4 = Objects.equals((Object)_stellarMcu_4, (Object)StellarType.SR6G6);
                        if (_equals_4) {
                            _xifexpression_4 = "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23";
                        } else {
                            String _xifexpression_5 = null;
                            StellarType _stellarMcu_5 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
                            boolean _equals_5 = Objects.equals((Object)_stellarMcu_5, (Object)StellarType.SR6G7);
                            if (_equals_5) {
                                _xifexpression_5 = "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23,SR6X_UART24,SR6X_UART25,SR6X_UART26,SR6X_UART27";
                            } else {
                                String _xifexpression_6 = null;
                                StellarType _stellarMcu_6 = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
                                boolean _equals_6 = Objects.equals((Object)_stellarMcu_6, (Object)StellarType.SR6P7G7);
                                _xifexpression_6 = _equals_6 ? "SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23,SR6X_UART24,SR6X_UART25,SR6X_UART26,SR6X_UART27" : "";
                                _xifexpression_5 = _xifexpression_6;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    @Override
    public String availableTimerValues() {
        String _xifexpression = null;
        StellarType _stellarMcu = ((AIComponent)this.eContainer).getMcu().getStellarMcu();
        boolean _equals = Objects.equals((Object)_stellarMcu, (Object)StellarType.SR5E1);
        _xifexpression = _equals ? "SYSTICK_and_DWT" : "SYSTICK";
        return _xifexpression;
    }

    @Override
    public boolean isEnabled() {
        boolean btnEnabled;
        boolean _xblockexpression = false;
        this.refreshCOMList();
        _xblockexpression = btnEnabled = super.isEnabled() && IterableExtensions.size((Iterable)IterableExtensions.filter(((AIComponent)this.eContainer).getNetworks(), it -> it.isEnabled())) > 0;
        return _xblockexpression;
    }
}

