/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent.impl;

import com.st.stellar.ai.aiComponent.AIComponent;
import com.st.stellar.ai.aiComponent.Actions;
import com.st.stellar.ai.aiComponent.Generate;
import com.st.stellar.ai.aiComponent.impl.AIComponentImpl;
import com.st.stellar.ai.aiComponent.impl.MGenerateImpl;
import com.st.stellar.ai.utils.Utils;
import com.st.stellar.components.ai.commands.AIParam;
import com.st.stellar.components.ai.commands.impl.GenerateCommand;
import com.st.stellar.components.ai.generator.AIGenerator;
import com.st.stellar.osutils.OsUtils;
import java.io.File;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class GenerateImpl
extends MGenerateImpl
implements Generate {
    private static Logger logger = LogManager.getLogger(GenerateImpl.class);

    @Override
    public void generate() {
        EObject _eContainer = this.eContainer();
        Actions actions = (Actions)_eContainer;
        EObject _eContainer_1 = actions.eContainer();
        AIComponentImpl root = (AIComponentImpl)_eContainer_1;
        AIParam.getInstance().setAppModel(root);
        this.preProcess();
        boolean _isWindows = OsUtils.isWindows();
        if (_isWindows) {
            root.getOut().println("AI network generate processing...");
            System.out.println("AI network generate processing...");
            AIParam.getInstance().setAppModel(root);
            Utils.showConsoleView();
            MessageConsole console = Utils.findConsole("AI Console");
            console.clearConsole();
            Runnable _function = () -> {
                boolean _not;
                AIParam _instance = AIParam.getInstance();
                GenerateCommand cmd = new GenerateCommand(_instance);
                boolean _launchCommand = AIParam.getInstance().launchCommand(cmd);
                boolean bl = _not = !_launchCommand;
                if (_not) {
                    logger.error((Object)"AI network generate failed");
                }
                Utils.updateExplorer(this);
                Utils.showConsoleView();
            };
            Display.getDefault().asyncExec(_function);
        } else {
            root.getOut().println("This only works on windows");
            System.out.println("This only works on windows");
        }
    }

    public IProject getCurrentProjectFromEditor() {
        IEditorInput input;
        IFile file;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (file = (IFile)(input = editor.getEditorInput()).getAdapter(IFile.class)) != null) {
            return file.getProject();
        }
        return null;
    }

    public void deleteFolder(IProject currentProject, String folderPath) {
        boolean _not;
        if (!currentProject.exists() || !currentProject.isOpen()) {
            InputOutput.println((Object)"Project does not exist or is not open");
            return;
        }
        IFolder folder = currentProject.getFolder(folderPath);
        boolean _exists = folder.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            InputOutput.println((Object)"Folder does not exist");
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        boolean flags = true;
        try {
            final Procedures.Procedure1 _function = monitor -> this.deleteFolderContentsExcept(folder, (IProgressMonitor)monitor);
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor arg0) {
                    _function.apply((Object)arg0);
                }
            }, null, 1, null);
            InputOutput.println((Object)"Workspace operation completed successfully");
        }
        catch (Throwable _t) {
            if (_t instanceof CoreException) {
                CoreException e = (CoreException)_t;
                String _message = e.getMessage();
                String _plus = "Workspace operation failed: " + _message;
                InputOutput.println((Object)_plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void deleteFolderContentsExcept(IFolder folder, IProgressMonitor monitor) {
        try {
            IResource[] members;
            for (IResource member : members = folder.members()) {
                boolean _matched = false;
                if (member instanceof IFile) {
                    boolean _not;
                    _matched = true;
                    boolean _contains = ((IFile)member).getName().contains("_analyze_report.txt");
                    boolean bl = _not = !_contains;
                    if (_not) {
                        ((IFile)member).delete(1, monitor);
                    }
                }
                if (_matched || !(member instanceof IFolder)) continue;
                _matched = true;
                this.deleteFolderContentsExcept((IFolder)member, monitor);
                boolean _isEmpty = ((List)Conversions.doWrapArray((Object)((IFolder)member).members())).isEmpty();
                if (!_isEmpty) continue;
                ((IFolder)member).delete(1, monitor);
            }
            boolean _isEmpty = ((List)Conversions.doWrapArray((Object)folder.members())).isEmpty();
            if (_isEmpty) {
                folder.delete(1, monitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void preProcess() {
        AIComponent model = AIParam.getInstance().getAppModel();
        String folderName = model.getName();
        IProject currentProject = this.getCurrentProjectFromEditor();
        this.deleteFolder(currentProject, folderName + File.separator + "lib" + File.separator);
        this.deleteFolder(currentProject, folderName + File.separator + "ws" + File.separator);
        this.deleteFolder(currentProject, folderName + File.separator + "cfg" + File.separator);
        Generator generator = new Generator();
        generator.setInput((Object)model);
        BasicMonitor.Printing _printing = new BasicMonitor.Printing(System.out);
        generator.generate((Object)model, AIGenerator.MODEL_PROJECT_TYPE, (Monitor)_printing);
        System.out.println("Generation done");
    }

    @Override
    public boolean isEnabled() {
        boolean res;
        boolean _xblockexpression = false;
        Actions actions = (Actions)this.eContainer;
        EObject _eContainer = actions.eContainer();
        AIComponent parent = (AIComponent)_eContainer;
        Functions.Function1 _function = it -> it.isEnabled();
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(parent.getNetworks(), (Functions.Function1)_function));
        _xblockexpression = res = _size > 0;
        return _xblockexpression;
    }
}

