/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValidationType implements Enumerator
{
    RANDOM(0, "Random", "Random"),
    INPUT_DATA(1, "InputData", "Custom Input Data"),
    INPUT_OUTPUT_DATA(2, "InputOutputData", "Custom Input/Output Data");

    public static final int RANDOM_VALUE = 0;
    public static final int INPUT_DATA_VALUE = 1;
    public static final int INPUT_OUTPUT_DATA_VALUE = 2;
    private static final ValidationType[] VALUES_ARRAY;
    public static final List<ValidationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ValidationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ValidationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ValidationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ValidationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ValidationType get(int value) {
        switch (value) {
            case 0: {
                return RANDOM;
            }
            case 1: {
                return INPUT_DATA;
            }
            case 2: {
                return INPUT_OUTPUT_DATA;
            }
        }
        return null;
    }

    private ValidationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ValidationType[]{RANDOM, INPUT_DATA, INPUT_OUTPUT_DATA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

