/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OptimizationType implements Enumerator
{
    BALANCED(0, "Balanced", "balanced"),
    RAM(1, "Ram", "ram"),
    TIME(2, "Time", "time");

    public static final int BALANCED_VALUE = 0;
    public static final int RAM_VALUE = 1;
    public static final int TIME_VALUE = 2;
    private static final OptimizationType[] VALUES_ARRAY;
    public static final List<OptimizationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static OptimizationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OptimizationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static OptimizationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            OptimizationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static OptimizationType get(int value) {
        switch (value) {
            case 0: {
                return BALANCED;
            }
            case 1: {
                return RAM;
            }
            case 2: {
                return TIME;
            }
        }
        return null;
    }

    private OptimizationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new OptimizationType[]{BALANCED, RAM, TIME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

