/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompressionType implements Enumerator
{
    NONE(0, "None", "none"),
    LOSSLESS(1, "Lossless", "lossless"),
    LOW(2, "Low", "low"),
    MEDIUM(3, "Medium", "medium"),
    HIGH(4, "High", "high");

    public static final int NONE_VALUE = 0;
    public static final int LOSSLESS_VALUE = 1;
    public static final int LOW_VALUE = 2;
    public static final int MEDIUM_VALUE = 3;
    public static final int HIGH_VALUE = 4;
    private static final CompressionType[] VALUES_ARRAY;
    public static final List<CompressionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CompressionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CompressionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CompressionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CompressionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CompressionType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return LOSSLESS;
            }
            case 2: {
                return LOW;
            }
            case 3: {
                return MEDIUM;
            }
            case 4: {
                return HIGH;
            }
        }
        return null;
    }

    private CompressionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CompressionType[]{NONE, LOSSLESS, LOW, MEDIUM, HIGH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

