package com.st.stellar.ai.component.validation

import com.st.stellar.ai.aiComponent.MAIPackage
import com.st.stellar.ai.aiComponent.util.AIValidator
import java.util.Map
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import com.st.stellar.ai.aiComponent.AIComponent
import com.google.common.collect.HashMultimap
import com.st.stellar.ai.aiComponent.Network
import com.st.stellar.ai.utils.Utils
import java.io.File
import org.eclipse.core.runtime.Path
import java.util.Locale

class MyValidator extends AIValidator {

	public static final MyValidator INSTANCE = new MyValidator();

	AIComponent currentComponent

	override validateNetworkName_checkName(String networkName, DiagnosticChain diagnostics,
		Map<Object, Object> context) {

		var res = checkNoDuplicatedNetwork(diagnostics, context)
		if (networkName === null || networkName.isEmpty || networkName.contains(" ")) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic",
						#["checkName", getValueLabel(MAIPackage.Literals.NETWORK_NAME, networkName, context)],
						#[networkName], context))
			}
			res = false
		}
		return res
	}

	/**
	 * Overridden method to set the Clock being validated
	 */
	override validateAIComponent(AIComponent aiComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = aiComponent
		super.validateAIComponent(aiComponent, diagnostics, context)
	}

	static val ISSUE_CODE_PREFIX = "com.st.stellar.ai.component."

	static val DUPLICATED_ELEMENT = ISSUE_CODE_PREFIX + 'duplicatedElement'

	def checkNoDuplicatedNetwork(DiagnosticChain diagnostics, Map<Object, Object> context) {

		if(currentComponent === null) return true

		// Implements SDD_NETWORK_NAMES_ARE_UNIQUE
		val multiMap = HashMultimap.create()

		for (e : currentComponent.networks) {
			multiMap.put(e.name.toLowerCase(Locale.ENGLISH), e)
		}

		var res = true
		for (entry : multiMap.asMap.entrySet) {
			val duplicates = entry.value
			if (duplicates.size > 1) {
				for (d : duplicates) {
					if (diagnostics !== null) {
						diagnostics.add(
							createDiagnostic(Diagnostic.ERROR, DUPLICATED_ELEMENT, 0,
								"_UI_GenericConstraint_diagnostic",
								#["checkName", getValueLabel(MAIPackage.Literals.NETWORK_NAME, d.name, context)],
								#[d.name], context))

					}
					res = false
				}
			}
		}
		res
	}

	override validateNetwork(Network network, DiagnosticChain diagnostics, Map<Object, Object> context) {
		this.network = network
		super.validateNetwork(network, diagnostics, context)
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'

	Network network

	override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
		var res = checkPath(network, path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MAIPackage.Literals.PATH, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}

	def checkPath(Network network, String location, DiagnosticChain chain, Map<Object, Object> map) {
		if(network === null) return true

		val fileName = Utils.getProject(network).getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

}
