package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.Version
import com.st.stellar.ai.utils.Utils
import com.st.stellar.components.ai.commands.AIParam
import com.st.stellar.osutils.OsUtils
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.swt.widgets.Display
import org.eclipse.ui.console.MessageConsole
import com.st.stellar.ai.aiComponent.Actions
import com.st.stellar.components.ai.commands.impl.VersionCommand

// This class overrides the generated class and will be instantiated by factory
class VersionImpl extends MVersionImpl implements Version
{
	static Logger logger = LogManager.getLogger(VersionImpl)

	override void version() {
		val Actions actions = (this.eContainer() as Actions)
		val AIComponentImpl root = (actions.eContainer() as AIComponentImpl)
		AIParam.getInstance().setAppModel(root)

		if (OsUtils.isWindows()) {
			root.out.println("AI tools version processing...")
			System.out.println("AI tools version processing...")
			/* Get the path of the project that includes the AI Component */
			AIParam.getInstance().setAppModel(root)
			Utils.showConsoleView()
			/* Find or create a console. */
			val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
			/* Clear console before printing the version information output */
			console.clearConsole()
			Display.getDefault().asyncExec([
				/* Get AI Command */
				var VersionCommand cmd = new VersionCommand(AIParam.getInstance())
				if (!AIParam.getInstance().launchCommand(cmd)) {
					logger.error("AI tools version failed")
				}
				// Refresh explorer view
				Utils.updateExplorer(VersionImpl.this)
				Utils.showConsoleView()
			])
		} else {
			root.out.println("This only works on windows")
			System.out.println("This only works on windows")
		}
	}
}
