package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.AIPackage
import com.st.stellar.ai.aiComponent.Network
import com.st.stellar.ai.aiComponent.Validate
import com.st.stellar.ai.aiComponent.ValidationType
import com.st.stellar.ai.utils.AIComponentHelper
import com.st.stellar.ai.utils.Utils
import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.components.ai.commands.AIParam
import com.st.stellar.components.ai.commands.AIValidateNetParam
import com.st.stellar.components.ai.commands.impl.ValidateNetwork
import gnu.io.CommPortIdentifier
import java.util.Enumeration
import java.util.List
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.EList
import org.eclipse.swt.widgets.Display
import org.eclipse.swt.widgets.FileDialog
import org.eclipse.ui.console.MessageConsole
import org.eclipse.ui.console.MessageConsoleStream
import com.st.stellar.ai.aiComponent.StellarType

// This class overrides the generated class and will be instantiated by factory
class ValidateImpl extends MValidateImpl implements Validate {

	static Logger logger = LogManager.getLogger(ValidateImpl)

	static MessageConsoleStream msg
	static MessageConsoleStream out
	static MessageConsoleStream err
	static MessageConsoleStream warn
	String aiValidateFilePathParam

	AIComponentHelper helper
	new() {
		helper = AIComponentHelper.instance
		val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
		/* Clear console before printing the output */
		console.clearConsole()
		Display.getDefault().syncExec([
			Utils.activateConsole(console)
			msg = console.newMessageStream()
			msg.setColor(Utils.DEFAULT_MESSAGE)
			out = console.newMessageStream()
			out.setColor(Utils.DEFAULT_OUTPUT)
			err = console.newMessageStream()
			err.setColor(Utils.DEFAULT_ERROR)
			warn = console.newMessageStream()
			warn.setColor(Utils.DEFAULT_WARNING)
		])

		DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			AIPackage.eINSTANCE.validate_InputPath,
			#[
				AIPackage.eINSTANCE.validate_BrowseInput
			]
		)
		DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			AIPackage.eINSTANCE.validate_OutputPath,
			#[
				AIPackage.eINSTANCE.validate_BrowseOutput
			]
		)
	}

	override void validate() {
		var AIComponentImpl model = (this.eContainer() as AIComponentImpl)
		model.out.println("AI network validate processing...")
		System.out.println("AI network validate processing...")
		AIParam.getInstance().setAppModel(model)
		Utils.showConsoleView()
		/* Find or create a console. */
		val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
		/* Clear console before printing the Validate output */
		console.clearConsole() //
		/* Get AI Validate COM on which the target is connected */
		val aiValidateComParam = getComPort

		/* Get AI Validate Data Type */
		val aiValidateDataTypeParam = getValidationType

		/* Get custom file input/output */
		val aiValidateCustomOutputFileParam = getOutputPath

		/* Get custom file input */
		val aiValidateCustomInputFileParam = getInputPath

		val networkOk = networkToValidate !== null && !networkToValidate.isEmpty
		if (!networkOk) {
			err.println("No network to validate selected!!!");
			logger.error("No network to validate selected!!!");
			return
		}
		val inputOk = inputPath !== null && !inputPath.isEmpty
		if (!inputOk && validationType != ValidationType.RANDOM) {
			err.println("No validation inputPath selected!!!");
			logger.error("No validation inputPath selected!!!");
			return
		}
		val outputOk = outputPath !== null && !outputPath.isEmpty
		if (!outputOk && validationType == ValidationType.INPUT_OUTPUT_DATA) {
			err.println("No validation outputPath selected!!!");
			logger.error("No validation outputPath selected!!!");
			return
		}

		/* for the auto-detect mode this check can be removed
		val COMOk = comPort !== null && !comPort.isEmpty
		if (!COMOk) {
			err.println("No serial COM selected!!!");
			logger.error("No serial COM selected!!!");
			return
		}
		*/

		/*
		 * Find the Network to validate based on the Network Name selected by the
		 * graphic interface
		 */
		/* Get AI Network List */
		val network = model.networks.findFirst[name.equals(networkToValidate)]
		if (network !== null) {
			/* Get AI Network Enable flag */
			val aiIsNetworkEnableParam = network.isEnabled

			/* Only the enable Networks are processed */
			if (aiIsNetworkEnableParam) {

				/* Get AI Type */
				val aiTypeParam = network.type

				/* Get AI Compression */
				val aiCompressionParam = network.compression

				/* Get AI Optimization */
				val aiOptimizationParam = network.optimization

				/* Get AI Model Files Path */
				val aiModelFilePathParam = network.filePath

				/*Get AI Allocate Input Enable Flag */
				val aiIsAllocInEnableParam = network.advancedSettings.allocateInputs

				/*Get AI Allocate Output Enable Flag */
				val aiIsAllocOutEnableParam = network.advancedSettings.allocateOutputs

				/* Get AI Split Weights Enable Flag */
				val aiIsSplitWeightsEnableParam = network.advancedSettings.splitWeights

				/*Get AI Allocate Activations Enable Flag */
				val aiIsAllocActivationsEnableParam = network.advancedSettings.allocateActivations

				/*Get AI Allocate States Enable Flag */
				val aiIsAllocStatesEnableParam = network.advancedSettings.allocateStates

				/* Get Classifier Enable Flag */
				val aiIsClassifierEnableParam = network.advancedSettings.classifier

				/* Get AI Classifier Enable Flag */
				val aiExtraCommandLineOptions = network.advancedSettings.extraCommandLineOptions

				/* Get AI Custom Layer support Enable Flag */
				val aiIsCustomLayerEnableParam = network.customLayerSettings.enable

				/* Get AI Custom Layer File Path */
				val aiCustomLayerFilePathParam = network.customLayerSettings.customLayerJsonFile

				val aiNetParam = new AIValidateNetParam(networkToValidate, aiTypeParam, aiCompressionParam, aiOptimizationParam,
					aiModelFilePathParam, aiIsAllocInEnableParam, aiIsAllocOutEnableParam, aiIsSplitWeightsEnableParam, aiIsAllocActivationsEnableParam, aiIsAllocStatesEnableParam, 
					aiIsClassifierEnableParam, aiExtraCommandLineOptions, aiIsCustomLayerEnableParam, aiCustomLayerFilePathParam,
					aiValidateComParam, aiValidateDataTypeParam, aiValidateCustomInputFileParam,
					aiValidateCustomOutputFileParam);
				val cmd = new ValidateNetwork(AIParam.getInstance());
				if (!cmd.execute(aiNetParam)) {
					logger.error("AI network validation failed");
				}

			}
		} else {
			err.println("Network to validate not found!!!");
			logger.error("Network to validate not found!!!");
		}

		Utils.showConsoleView();
	}

	override getDescription() {
		'''In order to run the Validate on Target:

1. Enable the validation view selecting the Enabled flag
2. Select from the "Validate settings" tab:
   2.1 the Network To Validate
   2.2 the Validate Serial
3. Generate the Validate Project code using the Generate button from the "Actions" panel
4. Compile the Validate Project
5. Upload and run it on the target
6. Select from the "Validate parameters" tab:
   6.1 the Validate Type (Random or Custom Input Data or Custom Input/Output Data) 
   6.2 the Com Port
7. Press the Validate button
For the selected network a report will be displayed in the console and will be stored in a dedicated file inside the project folder:
 ...\«(eContainer as AIComponent).name»\cfg\'''
	}

	override browseInputPath() {
		val AIComponentImpl model = (this.eContainer() as AIComponentImpl)
		AIParam.getInstance().setAppModel(model)
		Display.getDefault().syncExec([
			val dlg = new FileDialog(Display.getDefault().getActiveShell())

			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("");

			if (aiValidateFilePathParam === null) {
				AIParam.getInstance().setAppModel(model);
				dlg.setFilterPath(AIParam.getInstance().getWorkingDir() + "/source/");
			} else {
				dlg.setFilterPath(aiValidateFilePathParam);
			}

			// Change the title bar text
			dlg.setText("DirectoryDialog");

			// Customizable message displayed in the dialog
			dlg.setText("Select an input file");

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or
			// null if user cancels
			val dir = dlg.open();
			if (dir !== null) {
				// Replace absolute file name by relative path to the workspace
				var IPath location = new Path(dir);
				val base = Utils.getProject(model).getLocation();
				location = location.makeRelativeTo(base);
				helper.setAttributeValue(this, AIPackage.eINSTANCE.validate_InputPath, location.toString);
			}
		])
	}

	override browseOutputPath() {
		val AIComponentImpl model = (this.eContainer() as AIComponentImpl)
		AIParam.getInstance().setAppModel(model)
		Display.getDefault().syncExec([
			val dlg = new FileDialog(Display.getDefault().getActiveShell())

			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("");

			if (aiValidateFilePathParam === null) {
				AIParam.getInstance().setAppModel(model);
				dlg.setFilterPath(AIParam.getInstance().getWorkingDir() + "/source/");
			} else {
				dlg.setFilterPath(aiValidateFilePathParam);
			}

			// Change the title bar text
			dlg.setText("DirectoryDialog");

			// Customizable message displayed in the dialog
			dlg.setText("Select an input/output file");

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or
			// null if user cancels
			val dir = dlg.open();
			if (dir !== null) {
				// Replace absolute file name by relative path to the workspace
				var IPath location = new Path(dir);
				val base = Utils.getProject(model).getLocation();
				location = location.makeRelativeTo(base);
				helper.setAttributeValue(this, AIPackage.eINSTANCE.validate_OutputPath, location.toString);
			}
		])
	}

	override availableNetworks() {
		var listToString = "";

		val AIComponentImpl model = (this.eContainer() as AIComponentImpl)
		var EList<Network> networks = model.networks
		for (network : networks.filter[isEnabled]) {
			listToString = listToString.concat(",").concat(network.name);
		}
		listToString
	}

	var List<String> listCOM = null

	def private void refreshCOMList() {
		if (listCOM === null || listCOM.isEmpty) {
			Display.getDefault().asyncExec([
				System.out.print("Initializing COM port list...")
				synchronized (this) {
					listCOM = newArrayList
					var Enumeration<?> ports = CommPortIdentifier.getPortIdentifiers()
					while (ports.hasMoreElements()) {
						var CommPortIdentifier com = (ports.nextElement() as CommPortIdentifier)
						if (com.getPortType() === CommPortIdentifier.PORT_SERIAL) {
							listCOM.add(com.name)
						}
					}
				}
				System.out.println("Done")
			])
		}
	}

	override availableCOMPorts() {
		var listToString = "Auto";

		synchronized (this) {
			for (com : listCOM) {
				listToString = listToString.concat(",").concat(com);
			}
		}
		listToString
	}

	override getErrorMessage() {
		if ((eContainer as AIComponent).networks.filter[isEnabled].size == 0) {
			"Cannot edit as no network is available"
		} else {
			super.getErrorMessage
		}

	}

	override availableSerialValues() {
		if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR5E1) {
			"SR5E1_UART1,SR5E1_UART2,SR5E1_UART3"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6P3) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6P6) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6P7) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6G6) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6G7) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23,SR6X_UART24,SR6X_UART25,SR6X_UART26,SR6X_UART27"
		} else if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR6P7G7) {
			"SR6X_UART0,SR6X_UART1,SR6X_UART2,SR6X_UART3,SR6X_UART4,SR6X_UART5,SR6X_UART6,SR6X_UART7,SR6X_UART8,SR6X_UART9,SR6X_UART10,SR6X_UART11,SR6X_UART12,SR6X_UART13,SR6X_UART14,SR6X_UART15,SR6X_UART16,SR6X_UART17,SR6X_UART18,SR6X_UART19,SR6X_UART20,SR6X_UART21,SR6X_UART22,SR6X_UART23,SR6X_UART24,SR6X_UART25,SR6X_UART26,SR6X_UART27"
		} else {
			""
		}
	}

	override availableTimerValues() {
		if ((eContainer as AIComponent).mcu.stellarMcu == StellarType.SR5E1) {
			"SYSTICK_and_DWT"
		} else {
			"SYSTICK"
		}
	}

	override isEnabled() {
		refreshCOMList
		val btnEnabled = super.isEnabled() && (eContainer as AIComponent).networks.filter[isEnabled].size > 0
		btnEnabled
	}
	
	

}
