package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIPackage
import com.st.stellar.ai.aiComponent.Network
import com.st.stellar.ai.utils.AIComponentHelper
import com.st.stellar.ai.utils.Utils
import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.components.ai.commands.AIParam
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.swt.widgets.DirectoryDialog
import org.eclipse.swt.widgets.Display

// This class overrides the generated class and will be instantiated by factory
class NetworkImpl extends MNetworkImpl implements Network {
	String aiNetworkFilePathParam = null

	AIComponentHelper helper
	new() {
		helper = AIComponentHelper.instance

		DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			AIPackage.eINSTANCE.network_FilePath,
			#[
				AIPackage.eINSTANCE.network_Browse
			]
		)
	}

	override void browseModelPath() {
		AIParam.getInstance().setAppModel((this.eContainer() as AIComponentImpl))
		Display.getDefault().syncExec([
			var DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell()) // FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("")
			if (aiNetworkFilePathParam === null) {
				AIParam.getInstance().setAppModel((NetworkImpl.this.eContainer() as AIComponentImpl))
				dlg.setFilterPath('''«AIParam.getInstance().getWorkingDir()»/source/''')
			} else {
				dlg.setFilterPath(aiNetworkFilePathParam)
			}

			// Change the title bar text
			dlg.setText("Select a folder to model")

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or null if user cancels
			var String dir = dlg.open()
			if (dir !== null) {
				var IPath location = null;
				if (dir !== null) {
					// Replace absolute file name by relative path to the workspace
					location = new Path(dir);
					val base = Utils.getProject(this).getLocation();
					location = location.makeRelativeTo(base);

					helper.setAttributeValue(this, AIPackage.eINSTANCE.network_FilePath, location.toString);
				}
			}
		])
	}
}
