package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.Actions
import com.st.stellar.ai.aiComponent.Generate
import com.st.stellar.ai.utils.Utils
import com.st.stellar.components.ai.commands.AIParam
import com.st.stellar.components.ai.commands.impl.GenerateCommand
import com.st.stellar.components.ai.generator.AIGenerator
import com.st.stellar.osutils.OsUtils
import java.io.File
import org.apache.log4j.LogManager
import org.apache.log4j.Logger
import org.eclipse.core.resources.IFile
import org.eclipse.core.resources.IFolder
import org.eclipse.core.resources.IProject
import org.eclipse.core.runtime.NullProgressMonitor
import org.eclipse.emf.codegen.ecore.generator.Generator
import org.eclipse.emf.common.util.BasicMonitor
import org.eclipse.swt.widgets.Display
import org.eclipse.ui.IEditorPart
import org.eclipse.ui.PlatformUI
import org.eclipse.ui.console.MessageConsole
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.IProgressMonitor
import org.eclipse.core.resources.IWorkspaceRunnable
import org.eclipse.core.resources.IResourceChangeListener
import org.eclipse.core.resources.IResourceChangeEvent
import org.eclipse.core.resources.IResource
import org.eclipse.core.runtime.CoreException
import org.eclipse.core.resources.IWorkspace
import org.eclipse.core.runtime.jobs.ISchedulingRule

// This class overrides the generated class and will be instantiated by factory
class GenerateImpl extends MGenerateImpl implements Generate {

	static Logger logger = LogManager.getLogger(GenerateImpl)

	override void generate() {
		val Actions actions = (this.eContainer() as Actions)
		val AIComponentImpl root = (actions.eContainer() as AIComponentImpl)
		AIParam.getInstance().setAppModel(root)

		preProcess();
		if (OsUtils.isWindows()) {
			root.out.println("AI network generate processing...")
			System.out.println("AI network generate processing...")
			/* Get the path of the project that includes the AI Component */
			AIParam.getInstance().setAppModel(root)
			Utils.showConsoleView()
			/* Find or create a console. */
			val MessageConsole console = Utils.findConsole(Utils.CONSOLE_NAME)
			/* Clear console before printing the Validate output */
			console.clearConsole()
			Display.getDefault().asyncExec([
				/* Get AI Command */
				var GenerateCommand cmd = new GenerateCommand(AIParam.getInstance())
				if (!AIParam.getInstance().launchCommand(cmd)) {
					logger.error("AI network generate failed")
				}
				// Refresh explorer view
				Utils.updateExplorer(GenerateImpl.this)
				Utils.showConsoleView()
			])
		} else {
			root.out.println("This only works on windows")
			System.out.println("This only works on windows")
		}
	}

	def IProject getCurrentProjectFromEditor() {
		val IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()
		if (editor !== null) {
			val input = editor.getEditorInput()
			val file = input.getAdapter(IFile)
			if (file !== null) {
				return file.getProject
			}
		}
		return null
	}

	def void deleteFolder(IProject currentProject, String folderPath) {
		if (!currentProject.exists || !currentProject.isOpen) {
			println("Project does not exist or is not open")
			return
		}

		val IFolder folder = currentProject.getFolder(folderPath)
		if (!folder.exists) {
			println("Folder does not exist")
			return
		}

		val workspace = ResourcesPlugin.getWorkspace
		val int flags = IWorkspace.AVOID_UPDATE

		try {
			workspace.run([ IProgressMonitor monitor |
				// Recursively delete folder contents except files containing "_analyze_report.txt"
				deleteFolderContentsExcept(folder, monitor)
			] as IWorkspaceRunnable, null, flags, null)
			println("Workspace operation completed successfully")
		} catch (CoreException e) {
			println("Workspace operation failed: " + e.message)
		}
	}

	def void deleteFolderContentsExcept(IFolder folder, IProgressMonitor monitor) {
		// List all members (files and folders) in the folder
		val members = folder.members

		for (member : members) {
			switch member {
				IFile: {
					// Check if file name contains "_analyze_report.txt"
					if (!member.name.contains("_analyze_report.txt")) {
						// Delete the file forcibly
						member.delete(IResource.FORCE, monitor)
					}
				// else: skip this file (do not delete)
				}
				IFolder: {
					// Recursive call for subfolders
					deleteFolderContentsExcept(member, monitor)

					// After deleting contents, check if folder is empty, then delete it
					if (member.members.empty) {
						member.delete(IResource.FORCE, monitor)
					}
				}
			}
		}

		// After processing all members, if the folder is empty, delete it
		if (folder.members.empty) {
			folder.delete(IResource.FORCE, monitor)
		}
	}

	def preProcess() {
		/*
		 * Delete content of the cfg, lib and ws directories. In this way, when a new AI generate
		 * command is issued, the directories will not contain files generated
		 * by the previous AI generate command.
		 * The analyze report, under the cfg folder, is not deleted.
		 */
		val model = AIParam.getInstance().appModel
		val folderName = model.name
		val currentProject = getCurrentProjectFromEditor

		deleteFolder(currentProject, folderName + File.separator + "lib" + File.separator)
		deleteFolder(currentProject, folderName + File.separator + "ws" + File.separator)
		deleteFolder(currentProject, folderName + File.separator + "cfg" + File.separator)

		val generator = new Generator()
		generator.setInput(model)
		generator.generate(model, AIGenerator.MODEL_PROJECT_TYPE, new BasicMonitor.Printing(System.out))
		System.out.println("Generation done")
	}

	override boolean isEnabled() {
		val actions = eContainer as Actions
		val parent = actions.eContainer as AIComponent
		val res = parent.networks.filter[isEnabled].size > 0
		res
	}
}
