package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.AIPackage
import com.st.stellar.ai.aiComponent.CustomLayerSettings
import com.st.stellar.ai.utils.AIComponentHelper
import com.st.stellar.ai.utils.Utils
import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.components.ai.commands.AIParam
import org.eclipse.core.runtime.IPath
import org.eclipse.core.runtime.Path
import org.eclipse.swt.widgets.Display
import org.eclipse.swt.widgets.FileDialog
//import com.st.stellar.ai.aiComponent.AIComponent
//import java.io.IOException
//import java.io.BufferedReader
//import java.io.FileReader
//import java.io.IOException

//import java.io.File

// This class overrides the generated class and will be instantiated by factory
class CustomLayerSettingsImpl extends MCustomLayerSettingsImpl implements CustomLayerSettings {
	String aiNetworkCustomLayerFilePathParam = null

	AIComponentHelper helper

	new() {
		helper = AIComponentHelper.instance

		DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			AIPackage.eINSTANCE.network_FilePath,
			#[
				AIPackage.eINSTANCE.network_Browse
			]
		)
	}

	override void browseInputCustomLayer() {
		val network = (this.eContainer() as NetworkImpl)
		val model = network.eContainer as AIComponentImpl
		AIParam.getInstance().setAppModel(model)
		Display.getDefault().syncExec([
			val dlg = new FileDialog(Display.getDefault().getActiveShell());
			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("")
			dlg.setFilterExtensions(#["*.json"])
			if (aiNetworkCustomLayerFilePathParam === null) {
				AIParam.getInstance().setAppModel(model)
				dlg.setFilterPath('''«AIParam.getInstance().getWorkingDir()»/source/''')
			} else {
				dlg.setFilterPath(aiNetworkCustomLayerFilePathParam)
			}

			// Change the title bar text
			dlg.setText("Select a folder to model")

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or null if user cancels
			var String dir = dlg.open()
			if (dir !== null) {
				var IPath location = null;
				if (dir !== null) {
					// Replace absolute file name by relative path to the workspace
					location = new Path(dir);
					helper.setAttributeValue(this, AIPackage.eINSTANCE.customLayerSettings_CustomLayerJsonAbsoluteFile,
						location.toString);
					val base = Utils.getProject(this).getLocation();
					location = location.makeRelativeTo(base);
					helper.setAttributeValue(this, AIPackage.eINSTANCE.customLayerSettings_CustomLayerJsonFile,
						location.toString);
				}
			}
		])
	}

}
