package com.st.stellar.ai.aiComponent.impl

import com.st.stellar.ai.aiComponent.Actions
import com.st.stellar.ai.aiComponent.AIComponent
import com.st.stellar.ai.aiComponent.Network
import org.eclipse.emf.common.util.EList

// This class overrides the generated class and will be instantiated by factory
class ActionsImpl extends MActionsImpl implements Actions {

        override String getDescription() {
        var String desc = ""
        val aiComp = eContainer as AIComponent
        var EList<Network> networks = aiComp.getNetworks()
        for (Network network : networks) {
            /* Get AI Network Enable flag */
            var boolean aiIsNetworkEnableParam = network.isEnabled()
            /* Only the enable Networks are processed */
            if (aiIsNetworkEnableParam === true) {
                /* Get Network Name value */
                var aiNetworkNameParam = network.name
                /* Get Network Type value */
                var aiTypeParam = network.type
                /* Get Network Compression value */
                var aiCompressionParam = network.compression
                /* Get Network Optimization value */
                var aiOptimizationParam = network.optimization
                /* Get  Network Model Files Path */
                var aiModelFilePathParam = network.filePath
                /* Get Network Macc value */
                var aiNetworkMacc = network.macc
                if (desc.length() > 0) {
                    desc += "\n"
                } else {
                    desc = "Enabled networks:\n"
                }
                desc += '''	- Name: «aiNetworkNameParam», Type: «aiTypeParam», Compression: «aiCompressionParam», Optimization: «aiOptimizationParam», Model path: «aiModelFilePathParam», Complexity: «aiNetworkMacc»'''
            }
        }
        if (desc.isEmpty()) {
            desc = "No enabled networks!"
        }
        else {
            desc += "\n\n"
            desc += "Network enabled for validation on target:\n"
            if (aiComp.getValidate().isEnabled()) {
                desc += '''	- «aiComp.getValidate().getNetworkToValidate()»'''
            }
			else {
                desc += '''	- No network to validate.'''
            }
        }
		return desc
    }

}
