/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.components.ai.commands.impl;

import com.st.stellar.components.ai.commands.AINetParam;
import com.st.stellar.components.ai.commands.AIParam;
import com.st.stellar.components.ai.commands.impl.AICommandImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressService;

public class AnalyzeCommand
extends AICommandImpl {
    private static Logger logger = Logger.getLogger(AnalyzeCommand.class);
    boolean result;

    public AnalyzeCommand(AIParam aiParam) {
        super(aiParam);
    }

    @Override
    public boolean execute(final AINetParam aiNetParam) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            this.result = true;
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Import, parse, check and render the '" + aiNetParam.name + "' network...", -1);
                    String[] aiCmd = AnalyzeCommand.this.processAICommand("analyze", aiNetParam);
                    if (aiCmd != null) {
                        CommandExecutionThread thread = new CommandExecutionThread(aiCmd, AICommandImpl.out);
                        thread.start();
                        while (!monitor.isCanceled() && thread.isAlive()) {
                        }
                        if (monitor.isCanceled()) {
                            thread.close();
                            AnalyzeCommand.this.result = false;
                        }
                    } else {
                        AnalyzeCommand.this.result = false;
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            logger.error((Object)e1);
        }
        catch (InterruptedException e1) {
            logger.error((Object)e1);
        }
        return this.result;
    }

    private class CommandExecutionThread
    extends Thread {
        private volatile Boolean waiter;
        private String[] _aiCmd;
        private MessageConsoleStream _stream;

        public CommandExecutionThread(String[] aiCmd, MessageConsoleStream stream) {
            this._aiCmd = aiCmd;
            this._stream = stream;
            this.setName("AnalysisThread");
        }

        @Override
        public synchronized void start() {
            this.waiter = Boolean.TRUE;
            super.start();
        }

        public void close() {
            this.waiter = Boolean.FALSE;
        }

        @Override
        public void run() {
            if (this._aiCmd != null) {
                for (String string : this._aiCmd) {
                    System.out.print(string + " ");
                }
                System.out.println("");
                ProcessBuilder probuilder = new ProcessBuilder(this._aiCmd);
                try {
                    String line;
                    AnalyzeCommand.this.showConsoleView();
                    Process p = probuilder.start();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = reader.readLine()) != null && this.waiter.booleanValue() && p.isAlive()) {
                        final String l = line;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CommandExecutionThread.this._stream.println(l);
                            }
                        });
                    }
                    reader.close();
                    while (this.waiter.booleanValue() && p.isAlive()) {
                        p.wait(100L);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                AICommandImpl.updateExplorer();
                System.out.println("Done");
            }
        }
    }
}

