/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.component.validation;

import com.google.common.collect.HashMultimap;
import com.st.stellar.ai.aiComponent.AIComponent;
import com.st.stellar.ai.aiComponent.MAIPackage;
import com.st.stellar.ai.aiComponent.Network;
import com.st.stellar.ai.aiComponent.util.AIValidator;
import com.st.stellar.ai.utils.Utils;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class MyValidator
extends AIValidator {
    public static final MyValidator INSTANCE = new MyValidator();
    private AIComponent currentComponent;
    private static final String ISSUE_CODE_PREFIX = "com.st.stellar.ai.component.";
    private static final String DUPLICATED_ELEMENT = "com.st.stellar.ai.component.duplicatedElement";
    private static final String WRONG_PATH = "com.st.stellar.ai.component.wrongPath";
    private Network network;

    @Override
    public boolean validateNetworkName_checkName(String networkName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean res = this.checkNoDuplicatedNetwork(diagnostics, context);
        if (networkName == null || networkName.isEmpty() || networkName.contains(" ")) {
            if (diagnostics != null) {
                String _valueLabel = EObjectValidator.getValueLabel((EDataType)MAIPackage.Literals.NETWORK_NAME, (Object)networkName, context);
                diagnostics.add((Diagnostic)this.createDiagnostic(4, "com.st.stellar.ai.aiComponent", 0, "_UI_GenericConstraint_diagnostic", new Object[]{"checkName", _valueLabel}, new Object[]{networkName}, context));
            }
            res = false;
        }
        return res;
    }

    @Override
    public boolean validateAIComponent(AIComponent aiComponent, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        this.currentComponent = aiComponent;
        _xblockexpression = super.validateAIComponent(aiComponent, diagnostics, context);
        return _xblockexpression;
    }

    public boolean checkNoDuplicatedNetwork(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        if (this.currentComponent == null) {
            return true;
        }
        HashMultimap multiMap = HashMultimap.create();
        EList<Network> _networks = this.currentComponent.getNetworks();
        for (Network e : _networks) {
            multiMap.put((Object)e.getName().toLowerCase(Locale.ENGLISH), (Object)e);
        }
        boolean res = true;
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (Network d : duplicates) {
                if (diagnostics != null) {
                    String _valueLabel = EObjectValidator.getValueLabel((EDataType)MAIPackage.Literals.NETWORK_NAME, (Object)d.getName(), context);
                    String _name = d.getName();
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DUPLICATED_ELEMENT, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"checkName", _valueLabel}, new Object[]{_name}, context));
                }
                res = false;
            }
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    @Override
    public boolean validateNetwork(Network network, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean _xblockexpression = false;
        this.network = network;
        _xblockexpression = super.validateNetwork(network, diagnostics, context);
        return _xblockexpression;
    }

    @Override
    public boolean validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean res = this.checkPath(this.network, path, diagnostics, context);
        if (!res && diagnostics != null) {
            String _valueLabel = EObjectValidator.getValueLabel((EDataType)MAIPackage.Literals.PATH, (Object)path, context);
            diagnostics.add((Diagnostic)this.createDiagnostic(4, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"checkPath", _valueLabel}, new Object[]{path}, context));
            res = false;
        }
        return res;
    }

    public boolean checkPath(Network network, String location, DiagnosticChain chain, Map<Object, Object> map) {
        boolean _xblockexpression = false;
        if (network == null) {
            return true;
        }
        String _oSString = Utils.getProject(network).getLocation().toOSString();
        String _plus = _oSString + File.separator;
        String fileName = _plus + location;
        Path path = new Path(fileName);
        boolean res = false;
        boolean _isValidPath = path.isValidPath(fileName);
        if (_isValidPath) {
            File file = new File(fileName);
            res = file.exists();
        }
        _xblockexpression = res;
        return _xblockexpression;
    }
}

