/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.ai.aiComponent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NetworkType implements Enumerator
{
    KERAS(0, "Keras", "keras"),
    TF_LITE(1, "TFLite", "tflite"),
    ONNX(2, "ONNX", "onnx");

    public static final int KERAS_VALUE = 0;
    public static final int TF_LITE_VALUE = 1;
    public static final int ONNX_VALUE = 2;
    private static final NetworkType[] VALUES_ARRAY;
    public static final List<NetworkType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static NetworkType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            NetworkType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static NetworkType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            NetworkType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static NetworkType get(int value) {
        switch (value) {
            case 0: {
                return KERAS;
            }
            case 1: {
                return TF_LITE;
            }
            case 2: {
                return ONNX;
            }
        }
        return null;
    }

    private NetworkType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new NetworkType[]{KERAS, TF_LITE, ONNX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

